/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.Hashtable;
import java.util.Stack;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class ASTHelper {
    public static String resolveVariavleValue(SimpleName variable, int location, String entireCode) {
        ASTParser parser = ASTParser.newParser((int)2);
        parser.setSource(entireCode.toCharArray());
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        VariableValueVisitor valueVisitor = new VariableValueVisitor(variable.getIdentifier(), location);
        cu.accept((ASTVisitor)valueVisitor);
        return valueVisitor.getValue();
    }

    public static class VariableValueVisitor
    extends ASTVisitor {
        private String selector = null;
        private ASTNode value = null;
        private Hashtable varToValHash = null;
        private Stack scopeStack = null;
        private int selectorLocation = -1;

        public VariableValueVisitor(String selector, int selectorLocation) {
            this.selector = selector;
            this.selectorLocation = selectorLocation;
        }

        public String getValue() {
            if (this.value != null) {
                return this.value.toString();
            }
            return this.selector;
        }

        private boolean isValuable(ASTNode node) {
            if (node instanceof BooleanLiteral) {
                return true;
            }
            if (node instanceof CharacterLiteral) {
                return true;
            }
            if (node instanceof NullLiteral) {
                return true;
            }
            if (node instanceof NumberLiteral) {
                return true;
            }
            if (node instanceof StringLiteral) {
                return true;
            }
            if (node instanceof TypeLiteral) {
                return true;
            }
            return node instanceof ArrayCreation;
        }

        private Stack getScopeStack() {
            if (this.scopeStack == null) {
                this.scopeStack = new Stack();
            }
            return this.scopeStack;
        }

        private Hashtable getHash() {
            if (this.varToValHash == null) {
                this.varToValHash = new Hashtable();
            }
            return this.varToValHash;
        }

        private void pushScope() {
            this.getScopeStack().push(this.getHash().clone());
        }

        private void popScope() {
            this.varToValHash = (Hashtable)this.getScopeStack().pop();
        }

        public boolean visit(Assignment assignment) {
            if (this.isValuable((ASTNode)assignment.getRightHandSide())) {
                Expression ref = assignment.getLeftHandSide();
                String varName = "?";
                if (ref instanceof SimpleName) {
                    SimpleName varNameNode = (SimpleName)ref;
                    varName = varNameNode.getIdentifier();
                }
                if (ref instanceof QualifiedName) {
                    QualifiedName qname = (QualifiedName)ref;
                    varName = qname.getName().getIdentifier();
                }
                this.getHash().put(varName, assignment.getRightHandSide());
            }
            return super.visit(assignment);
        }

        public boolean visit(VariableDeclarationFragment node) {
            if (this.isValuable((ASTNode)node.getInitializer())) {
                this.getHash().put(node.getName().toString(), node.getInitializer());
            }
            return super.visit(node);
        }

        public void endVisit(Block block) {
            this.exitingScope(block.getStartPosition(), block.getStartPosition() + block.getLength());
            super.endVisit(block);
        }

        public void endVisit(CompilationUnit compilationUnit) {
            this.exitingScope(compilationUnit.getStartPosition(), compilationUnit.getStartPosition() + compilationUnit.getLength());
            super.endVisit(compilationUnit);
        }

        public void endVisit(ForStatement forStatement) {
            this.exitingScope(forStatement.getStartPosition(), forStatement.getStartPosition() + forStatement.getLength());
            super.endVisit(forStatement);
        }

        public void endVisit(MethodDeclaration methodDeclaration) {
            this.exitingScope(methodDeclaration.getStartPosition(), methodDeclaration.getStartPosition() + methodDeclaration.getLength());
            super.endVisit(methodDeclaration);
        }

        private void exitingScope(int scopeStart, int scopeEnd) {
            if (scopeStart < 0 || scopeEnd < 0 || scopeStart > scopeEnd) {
                return;
            }
            if (this.selectorLocation >= scopeStart && this.selectorLocation <= scopeEnd && this.value == null) {
                this.value = (ASTNode)this.getHash().get(this.selector);
            }
            this.popScope();
        }

        public boolean visit(Block block) {
            this.pushScope();
            return super.visit(block);
        }

        public boolean visit(CompilationUnit compilationUnit) {
            this.pushScope();
            return super.visit(compilationUnit);
        }

        public boolean visit(MethodDeclaration methodDeclaration) {
            this.pushScope();
            return super.visit(methodDeclaration);
        }

        public boolean visit(ForStatement forStatement) {
            this.pushScope();
            return super.visit(forStatement);
        }
    }
}

