/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.logging.Level;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jem.internal.beaninfo.PropertyDecorator;
import org.eclipse.jem.internal.beaninfo.core.Utilities;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.ve.internal.java.codegen.java.IJavaFeatureMapper;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public abstract class AbstractFeatureMapper
implements IJavaFeatureMapper {
    protected EStructuralFeature fSF = null;
    protected String fSFname = null;
    protected PropertyDecorator fPD = null;
    protected IJavaInstance fRefObj = null;
    protected String fMethodName = null;
    protected String fReadMethodName = null;
    protected boolean fisMethod = true;

    public abstract EStructuralFeature getFeature(Statement var1);

    public boolean isFieldFeature() {
        return !this.fisMethod;
    }

    public void setFeature(EStructuralFeature sf) {
        this.fSF = sf;
        if (sf != null) {
            block4: {
                try {
                    this.fSFname = this.fSF.getName();
                    this.fPD = Utilities.getPropertyDecorator((EModelElement)sf);
                }
                catch (Throwable e) {
                    if (!JavaVEPlugin.isLoggingLevel((Level)Level.WARNING)) break block4;
                    JavaVEPlugin.log((Object)("Utilities.getPropertyDecorator on:" + sf), (Level)Level.WARNING);
                    JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
                }
            }
            if (this.fPD != null && this.fPD.getField() != null) {
                this.fisMethod = false;
                this.fMethodName = this.fPD.getField().getName();
            }
        }
    }

    public String getFeatureName() {
        return this.fSFname;
    }

    public void setRefObject(IJavaInstance obj) {
        this.fRefObj = obj;
    }

    public IJavaInstance getRefObject() {
        return this.fRefObj;
    }

    public String getMethodName() {
        if (this.fMethodName == null && this.fPD != null && this.fPD.getWriteMethod() != null) {
            this.fMethodName = this.fPD.getWriteMethod().getName();
        }
        return this.fMethodName;
    }

    public String getReadMethodName() {
        if (this.fReadMethodName == null && this.fPD != null && this.fPD.getReadMethod() != null) {
            this.fReadMethodName = this.fPD.getReadMethod().getName();
        }
        return this.fReadMethodName;
    }

    protected String getMethodName(Statement exp) {
        if (this.fMethodName == null) {
            this.fMethodName = AbstractFeatureMapper.getWriteMethod(exp);
        }
        return this.fMethodName;
    }

    public PropertyDecorator getDecorator() {
        return this.fPD;
    }

    public String getIndexMethodName() {
        return this.getMethodName();
    }

    public int getFeaturePriority(String methodType) {
        return 10000;
    }

    public static String getWriteMethod(Statement expr) {
        Type tr;
        Expression e = null;
        if (expr instanceof ExpressionStatement) {
            e = ((ExpressionStatement)expr).getExpression();
        } else if (expr instanceof VariableDeclarationStatement && (tr = ((VariableDeclarationStatement)expr).getType()) instanceof SimpleType) {
            return "new" + ((SimpleType)tr).getName().toString();
        }
        if (e != null) {
            if (expr == null) {
                return null;
            }
            if (e instanceof MethodInvocation) {
                return ((MethodInvocation)e).getName().getIdentifier();
            }
            if (e instanceof Assignment) {
                if (((Assignment)e).getLeftHandSide() instanceof QualifiedName) {
                    return ((QualifiedName)((Assignment)e).getLeftHandSide()).getName().getIdentifier();
                }
                if (((Assignment)e).getRightHandSide() instanceof ClassInstanceCreation) {
                    return "new";
                }
                if (((Assignment)e).getLeftHandSide() instanceof SimpleName) {
                    return ((SimpleName)((Assignment)e).getLeftHandSide()).getIdentifier();
                }
            }
        }
        return null;
    }
}

