/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jface.util.Assert;
import org.eclipse.ve.internal.java.codegen.java.IExpressionDecoder;
import org.eclipse.ve.internal.java.codegen.java.IExpressionDecoderHelper;
import org.eclipse.ve.internal.java.codegen.java.IJavaFeatureMapper;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class AggregateDecoderHelper
implements IExpressionDecoderHelper {
    private IExpressionDecoderHelper[] helpers = null;
    private IExpressionDecoderHelper decodedHelper = null;

    public AggregateDecoderHelper(BeanPart bean, Statement exp, IJavaFeatureMapper fm, IExpressionDecoder owner, Class[] helperClasses) {
        Assert.isNotNull((Object)helperClasses, (String)"Must have atleast one decoder helper to aggregate");
        Assert.isTrue((helperClasses.length > 0 ? 1 : 0) != 0, (String)"Must have atleast one decoder helper to aggregate");
        this.helpers = new IExpressionDecoderHelper[helperClasses.length];
        Class[] paramClasses = new Class[4];
        try {
            paramClasses[0] = this.getClass().getClassLoader().loadClass("org.eclipse.ve.internal.java.codegen.model.BeanPart");
            paramClasses[1] = this.getClass().getClassLoader().loadClass("org.eclipse.jdt.core.dom.Statement");
            paramClasses[2] = this.getClass().getClassLoader().loadClass("org.eclipse.ve.internal.java.codegen.java.IJavaFeatureMapper");
            paramClasses[3] = this.getClass().getClassLoader().loadClass("org.eclipse.ve.internal.java.codegen.java.IExpressionDecoder");
            int helperClassCount = 0;
            while (helperClassCount < helperClasses.length) {
                IExpressionDecoderHelper helper;
                Constructor constructor = helperClasses[helperClassCount].getConstructor(paramClasses);
                this.helpers[helperClassCount] = helper = (IExpressionDecoderHelper)constructor.newInstance(bean, exp, fm, owner);
                ++helperClassCount;
            }
        }
        catch (ClassNotFoundException e) {
            JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
        }
        catch (SecurityException e) {
            JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
        }
        catch (NoSuchMethodException e) {
            JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
        }
        catch (IllegalArgumentException e) {
            JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
        }
        catch (InstantiationException e) {
            JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
        }
        catch (IllegalAccessException e) {
            JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
        }
        catch (InvocationTargetException e) {
            JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
        }
    }

    public boolean decode() throws CodeGenException {
        int helperCount = 0;
        while (helperCount < this.helpers.length) {
            if (this.helpers[helperCount].decode()) {
                this.decodedHelper = this.helpers[helperCount];
                return true;
            }
            ++helperCount;
        }
        return false;
    }

    public boolean restore() throws CodeGenException {
        int helperCount = 0;
        while (helperCount < this.helpers.length) {
            if (this.helpers[helperCount].restore()) {
                this.decodedHelper = this.helpers[helperCount];
                return true;
            }
            ++helperCount;
        }
        return false;
    }

    public String generate(Object[] args) throws CodeGenException {
        if (this.decodedHelper != null) {
            return this.decodedHelper.generate(args);
        }
        return null;
    }

    public void removeFromModel() {
        if (this.decodedHelper != null) {
            this.decodedHelper.removeFromModel();
        }
    }

    public String primRefreshFromComposition(String expSig) throws CodeGenException {
        if (this.decodedHelper != null) {
            return this.decodedHelper.primRefreshFromComposition(expSig);
        }
        return null;
    }

    public boolean primIsDeleted() {
        if (this.decodedHelper != null) {
            return this.decodedHelper.primIsDeleted();
        }
        return false;
    }

    public Object[] getArgsHandles(Statement expr) {
        if (this.decodedHelper != null) {
            return this.decodedHelper.getArgsHandles(expr);
        }
        return null;
    }

    public boolean isImplicit(Object[] args) {
        if (this.decodedHelper != null) {
            return this.decodedHelper.isImplicit(args);
        }
        return false;
    }

    public void setDecodingContent(Statement exp) {
        int i = 0;
        while (i < this.helpers.length) {
            this.helpers[i].setDecodingContent(exp);
            ++i;
        }
    }

    public IJavaFeatureMapper.VEexpressionPriority getPriorityOfExpression() {
        if (this.decodedHelper != null) {
            return this.decodedHelper.getPriorityOfExpression();
        }
        return null;
    }

    public boolean canRefreshFromComposition() {
        if (this.decodedHelper != null) {
            return this.decodedHelper.canRefreshFromComposition();
        }
        return false;
    }

    public String getCurrentExpression() {
        if (this.decodedHelper != null) {
            return this.decodedHelper.getCurrentExpression();
        }
        return null;
    }

    public void adaptToCompositionModel(IExpressionDecoder decoder) {
        if (this.decodedHelper != null) {
            this.decodedHelper.adaptToCompositionModel(decoder);
        }
    }

    public void unadaptToCompositionModel() {
        if (this.decodedHelper != null) {
            this.decodedHelper.unadaptToCompositionModel();
        }
    }

    public boolean isGenerateOnImplicit() {
        if (this.decodedHelper != null) {
            return this.decodedHelper.isGenerateOnImplicit();
        }
        return false;
    }

    public Object[] getAddedInstance() {
        if (this.decodedHelper != null) {
            return this.decodedHelper.getAddedInstance();
        }
        return null;
    }

    public Object[] getReferencedInstances() {
        if (this.decodedHelper != null) {
            return this.decodedHelper.getReferencedInstances();
        }
        return null;
    }

    public boolean isRelevantFeature(EStructuralFeature sf) {
        if (this.decodedHelper != null) {
            return this.decodedHelper.isRelevantFeature(sf);
        }
        return false;
    }
}

