/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.ArrayList;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.ve.internal.java.codegen.java.EventCallBackExpressionVisitor;
import org.eclipse.ve.internal.java.codegen.java.MethodVisitor;
import org.eclipse.ve.internal.java.codegen.java.rules.IVisitorFactoryRule;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeTypeRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;

public class EventMethodCallBackVisitor
extends MethodVisitor {
    public void initialize(MethodDeclaration node, IBeanDeclModel model, CodeTypeRef typeRef, String methodHandle, ISourceRange range, String content, IVisitorFactoryRule visitorFactory) {
        super.initialize(node, model, new ArrayList(), typeRef, methodHandle, range, content, visitorFactory);
    }

    protected void processStatementArray(Statement[] statements) throws CodeGenException {
        if (statements == null) {
            return;
        }
        int i = 0;
        while (i < statements.length) {
            this.processAStatement(statements[i]);
            ++i;
        }
    }

    protected void processAStatement(Statement stmt) throws CodeGenException {
        if (stmt instanceof IfStatement) {
            this.processIFStatement((IfStatement)stmt);
        }
    }

    protected BeanPart getBeanPart(Expression exp) {
        if (exp instanceof MethodInvocation) {
            if (((MethodInvocation)exp).getExpression() instanceof ThisExpression) {
                String getter = ((MethodInvocation)exp).getName().getIdentifier();
                return this.fModel.getBeanReturned(getter);
            }
        } else {
            if (exp instanceof ThisExpression) {
                return this.fModel.getABean("this");
            }
            if (exp instanceof SimpleName) {
                return this.fModel.getABean(((SimpleName)exp).getIdentifier());
            }
        }
        return null;
    }

    protected boolean processCondition(Expression condition, IfStatement stmt) {
        boolean result = false;
        if (condition instanceof InfixExpression) {
            InfixExpression ee = (InfixExpression)condition;
            if (ee.getOperator().equals(InfixExpression.Operator.EQUALS)) {
                BeanPart bp;
                String selector;
                if (ee.getLeftOperand() instanceof MethodInvocation && (selector = ((MethodInvocation)ee.getLeftOperand()).getName().getIdentifier()).equals("getSource") && (bp = this.getBeanPart(ee.getRightOperand())) != null) {
                    EventCallBackExpressionVisitor v = this.visitorFactory.getEventCallBackExpressionVisitor();
                    v.initialize(bp, this.fMethod, (Statement)stmt, this.fModel);
                    v.setProgressMonitor(this.getProgressMonitor());
                    v.visit();
                    return true;
                }
            } else if (ee.getLeftOperand() instanceof InfixExpression) {
                return this.processCondition(ee.getLeftOperand(), stmt);
            }
        }
        return result;
    }

    protected void processIFStatement(IfStatement stmt) throws CodeGenException {
        if (stmt.getExpression() instanceof InfixExpression) {
            this.processCondition(stmt.getExpression(), stmt);
        }
    }
}

