/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.ve.internal.java.codegen.java.CodeGenSourceRange;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenSourceRange;
import org.eclipse.ve.internal.java.codegen.java.ObjectDecoder;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeExpressionRef;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeTemplateHelper;
import org.eclipse.ve.internal.java.codegen.util.ExpressionParser;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class ExpressionRefFactory {
    static final String CLASS_PREFIX = "class Foo {\n";
    BeanPart fBeanPart;
    EStructuralFeature fSF;
    CodeExpressionRef fExpr = null;

    public ExpressionRefFactory(BeanPart bean, EStructuralFeature sf) {
        this.fBeanPart = bean;
        this.fSF = sf;
    }

    public void insertContentToDocument() throws CodeGenException {
        if (this.fExpr == null) {
            throw new CodeGenException("Invalid Context");
        }
        if (this.fExpr.getMethod().getMethodHandle() != null) {
            this.fExpr.insertContentToDocument();
        } else {
            this.fExpr.setState(512, true);
        }
    }

    public CodeExpressionRef createInitExpression() {
        CodeExpressionRef exp;
        IJavaObjectInstance obj = (IJavaObjectInstance)this.fBeanPart.getEObject();
        ExpressionRefFactory f = new ExpressionRefFactory(this.fBeanPart, ObjectDecoder.getAllocationFeature(obj));
        try {
            exp = f.createFromJVEModel(null);
        }
        catch (CodeGenException e1) {
            JavaVEPlugin.log((Throwable)((Object)e1));
            return null;
        }
        exp.setState(4096, true);
        this.fExpr = exp;
        return this.fExpr;
    }

    /*
     * Unable to fully structure code
     */
    public CodeExpressionRef createFromJVEModel(Object[] args) throws CodeGenException {
        block7: {
            if (this.fExpr != null) {
                return this.fExpr;
            }
            if (this.getExistingExpressionRef(args) != null) {
                throw new CodeGenException("Expression already exists");
            }
            mr = this.fBeanPart.getInitMethod();
            exp = new CodeExpressionRef(mr, this.fBeanPart);
            exp.setArguments(args);
            exp.clearState();
            exp.setState(1, true);
            exp.generateSource(this.fSF);
            if (!exp.isAnyStateSet() || exp.isStateSet(8)) {
                return exp;
            }
            this.fExpr = exp;
            try {
                mr.updateExpressionOrder();
                break block7;
            }
            catch (Throwable e) {
                JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
                itr = mr.getExpressions();
                prev = null;
                ** while (itr.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                x = (CodeExpressionRef)itr.next();
                if (x.equals(exp)) break;
                prev = x;
                continue;
            }
lbl27:
            // 2 sources

            if (prev == null) {
                prev = (CodeExpressionRef)itr.next();
            }
            exp.setOffset(prev.getOffset() + prev.getLen());
        }
        return exp;
    }

    public CodeExpressionRef getExistingExpressionRef(Object[] args) {
        if (this.fExpr != null) {
            return this.fExpr;
        }
        Iterator itr = this.fBeanPart.getRefExpressions().iterator();
        while (itr.hasNext()) {
            CodeExpressionRef exp = (CodeExpressionRef)itr.next();
            if (exp.getExpDecoder() == null || !this.fSF.equals(exp.getExpDecoder().getSF()) || (exp.getArgs() != null || args != null) && (exp.getArgs() == null || !exp.getArgs().equals(args))) continue;
            this.fExpr = exp;
            break;
        }
        return this.fExpr;
    }

    private Statement getInitExpression(String src) {
        ASTParser parser = ASTParser.newParser((int)2);
        parser.setSource(src.toCharArray());
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        Statement Stmt = null;
        List stmts = ((TypeDeclaration)cu.types().get(0)).getMethods()[0].getBody().statements();
        if (stmts.size() > 0) {
            Statement ts;
            Statement s = (Statement)stmts.get(0);
            if (s instanceof VariableDeclarationStatement || s instanceof ExpressionStatement && ((ExpressionStatement)s).getExpression() instanceof Assignment) {
                Stmt = s;
            } else if (s instanceof IfStatement && (ts = ((IfStatement)s).getThenStatement()) instanceof Block && (Stmt = (Statement)((Block)ts).statements().get(0)) instanceof TryStatement) {
                Stmt = (Statement)((TryStatement)Stmt).getBody().statements().get(0);
            }
        }
        return Stmt;
    }

    protected String classWrapper(String content, boolean generateMethod) {
        StringBuffer sb = new StringBuffer();
        sb.append(CLASS_PREFIX);
        if (generateMethod) {
            sb.append("void method() {\n");
        }
        sb.append(content);
        if (generateMethod) {
            sb.append("}");
        }
        sb.append("\n}");
        return sb.toString();
    }

    protected Statement parseMethodForInitExpr(String method) {
        return this.getInitExpression(this.classWrapper(method, false));
    }

    public CodeExpressionRef parseInitExpression() {
        CodeMethodRef mr = this.fBeanPart.getInitMethod();
        Statement s = this.parseMethodForInitExpr(mr.getContent());
        CodeExpressionRef exp = new CodeExpressionRef(s, mr, mr.getOffset() - CLASS_PREFIX.length());
        exp.clearState();
        exp.setState(1, true);
        exp.setState(4096, true);
        exp.setState(2, true);
        exp.setState(128, true);
        exp.setBean(this.fBeanPart);
        this.fExpr = exp;
        try {
            exp.getExpDecoder().generate(exp.getSF(), null);
        }
        catch (CodeGenException e) {
            JavaVEPlugin.log((Throwable)((Object)e));
        }
        return this.fExpr;
    }

    public CodeExpressionRef createFromSource(CodeExpressionRef exp, CodeMethodRef method) {
        this.fExpr = new CodeExpressionRef(method, this.fBeanPart);
        this.fExpr.setState(128, true);
        this.fExpr.setExprStmt(exp.getExprStmt());
        this.fExpr.setContent(exp.getContentParser());
        this.fExpr.setOffset(exp.getOffset());
        return this.fExpr;
    }

    public static CodeExpressionRef createShadowExpression(String content, int SrcOffset, int ExpOffset, int len, CodeMethodRef method, BeanPart b) {
        CodeExpressionRef exp = new CodeExpressionRef(method, b);
        exp.clearState();
        exp.setState(1, true);
        exp.setContent(new ExpressionParser(content, SrcOffset, len, b.getModel().getScannerFactory()));
        exp.setOffset(ExpOffset);
        return exp;
    }

    protected static CodeGenSourceRange computeSR(MethodDeclaration m, ASTNode node, IMethod im) throws JavaModelException {
        String src = im.getCompilationUnit().getSource();
        int realMethodStart = m.getStartPosition();
        try {
            String methodSource = im.getSource();
            realMethodStart = src.indexOf(methodSource);
        }
        catch (JavaModelException javaModelException) {
            realMethodStart = m.getStartPosition();
        }
        int start = node.getStartPosition();
        int filler = 0;
        int i = start - 1;
        while (i >= 0 && src.charAt(i) != '\n') {
            filler = src.charAt(i) == '\t' ? (filler += 4) : ++filler;
            --i;
        }
        String content = src.substring(start, start + node.getLength());
        start += content.indexOf(10) + 1;
        return new CodeGenSourceRange(start -= realMethodStart, filler);
    }

    public static ICodeGenSourceRange getOffsetForFirstExpression(IMethod m) {
        CodeGenSourceRange sr = null;
        try {
            ASTParser parser = ASTParser.newParser((int)2);
            parser.setSource(m.getCompilationUnit());
            CompilationUnit jDom = (CompilationUnit)parser.createAST(null);
            Message[] errors = jDom.getMessages();
            if (errors != null) {
                int cfr_ignored_0 = errors.length;
            }
            if (jDom.types().size() > 0) {
                TypeDeclaration t = (TypeDeclaration)jDom.types().get(0);
                MethodDeclaration[] methods = t.getMethods();
                MethodDeclaration method = null;
                if (methods != null && methods.length > 0) {
                    int i = 0;
                    while (i < methods.length) {
                        int args;
                        String name = methods[i].getName().getIdentifier();
                        String rType = methods[i].getReturnType().toString();
                        if (methods[i].getReturnType().isPrimitiveType()) {
                            rType = ((PrimitiveType)methods[i].getReturnType()).getPrimitiveTypeCode().toString();
                        }
                        int n = args = methods[i].parameters() == null ? 0 : methods[i].parameters().size();
                        if (name != null && rType != null && name.equals(m.getElementName()) && rType.equals(Signature.toString((String)m.getReturnType())) && m.getNumberOfParameters() == args) {
                            method = methods[i];
                            break;
                        }
                        ++i;
                    }
                }
                Object node = null;
                if (method != null) {
                    if (method.getBody() != null) {
                        if (method.getBody().statements() != null && method.getBody().statements().size() > 0) {
                            Statement s = (Statement)method.getBody().statements().get(0);
                            node = s instanceof TryStatement ? (((TryStatement)s).getBody() != null ? ((TryStatement)s).getBody() : s) : s;
                        } else {
                            int start = method.getBody().getStartPosition();
                            String src = m.getCompilationUnit().getSource();
                            int realStart = src.indexOf(10, start);
                            if (realStart >= method.getBody().getStartPosition() + method.getBody().getLength()) {
                                realStart = start;
                            } else if (realStart == -1) {
                                realStart = start;
                            }
                            int differenceInASTandJDT = m.getSourceRange().getOffset() - method.getStartPosition();
                            sr = new CodeGenSourceRange(++realStart - method.getStartPosition() - differenceInASTandJDT, CodeTemplateHelper.getCharLength(CodeTemplateHelper.getFillerForLevel(CodeTemplateHelper.NORMAL_METHOD_CONTENT_LEVEL)));
                            node = null;
                        }
                    }
                    if (node != null) {
                        sr = ExpressionRefFactory.computeSR(method, node, m);
                    }
                }
            }
        }
        catch (Throwable throwable) {}
        return sr;
    }
}

