/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.ve.internal.java.codegen.java.CodeGenJavaMessages;
import org.eclipse.ve.internal.java.codegen.java.ISourceVisitor;
import org.eclipse.ve.internal.java.codegen.java.SourceVisitor;
import org.eclipse.ve.internal.java.codegen.java.rules.IReturnStmtRule;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;

public class ReturnStmtVisitor
extends SourceVisitor {
    CodeMethodRef fMethod = null;
    ReturnStatement fReturnStmt = null;

    public void initialize(CodeMethodRef method, ReturnStatement stmt, IBeanDeclModel model, List reTryList) {
        super.initialize((ASTNode)stmt, model, reTryList);
        this.fMethod = method;
        this.fReturnStmt = stmt;
    }

    void processAReturnStatement() {
        String value;
        BeanPart bean;
        Expression exp = this.fReturnStmt.getExpression();
        if (exp instanceof SimpleName && (bean = CodeGenUtil.getBeanPart(this.fModel, value = ((SimpleName)exp).getIdentifier(), this.fMethod, this.fReturnStmt.getStartPosition() - this.fMethod.getOffset())) != null) {
            bean.addReturnMethod(this.fMethod);
            try {
                this.fModel.addMethodReturningABean(this.fMethod.getDeclMethod().getName().getIdentifier(), bean.getUniqueName());
            }
            catch (CodeGenException codeGenException) {}
        }
    }

    public void visit() {
        ISourceVisitor override;
        this.getProgressMonitor().subTask(MessageFormat.format(CodeGenJavaMessages.ReturnStmtVisitor_TypeMethodExpression, this.fMethod.getTypeRef().getSimpleName(), this.fMethod.getMethodName(), this.fReturnStmt.toString()));
        IReturnStmtRule returnRule = (IReturnStmtRule)CodeGenUtil.getEditorStyle(this.fModel).getRule("ruleReturnStatement");
        if (returnRule != null && (override = returnRule.overideReturnVisit(this.fMethod.getDeclMethod(), this.fReturnStmt, this.fModel)) != null) {
            override.visit();
            return;
        }
        this.processAReturnStatement();
    }
}

