/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.ve.internal.java.codegen.java.BeanPartFactory;
import org.eclipse.ve.internal.java.codegen.java.MethodVisitor;
import org.eclipse.ve.internal.java.codegen.java.SourceVisitor;
import org.eclipse.ve.internal.java.codegen.java.rules.IInstanceVariableRule;
import org.eclipse.ve.internal.java.codegen.java.rules.IThisReferenceRule;
import org.eclipse.ve.internal.java.codegen.java.rules.IVisitorFactoryRule;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.BeanPartDecleration;
import org.eclipse.ve.internal.java.codegen.model.CodeExpressionRef;
import org.eclipse.ve.internal.java.codegen.model.CodeTypeRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.model.JavaElementInfo;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.codegen.util.TypeResolver;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class TypeVisitor
extends SourceVisitor {
    CodeTypeRef fType = null;
    String[] methodHandles = null;
    boolean forceJDOMUsage = false;
    char[] content = null;
    Map fInstanceDeclaredBeans = new HashMap();
    JavaElementInfo[] JDTMethods = null;
    protected IVisitorFactoryRule visitorFactory = null;

    public void initialize(TypeDeclaration node, IBeanDeclModel model, char[] content, String[] methodHandles, List reTryList, boolean forceJDOMUsage, IVisitorFactoryRule visitorFactory) {
        this.initialize(node, model, reTryList, forceJDOMUsage, visitorFactory);
        this.methodHandles = methodHandles;
        this.content = content;
    }

    public void initialize(TypeDeclaration node, IBeanDeclModel model, List reTryList, boolean forceJDOMUsage, IVisitorFactoryRule visitorFactory) {
        super.initialize((ASTNode)node, model, reTryList);
        this.forceJDOMUsage = forceJDOMUsage;
        this.visitorFactory = visitorFactory;
        this.fType = new CodeTypeRef(node, model);
        model.setTypeRef(this.fType);
    }

    public void initialize(CodeTypeRef tr, TypeDeclaration node, IBeanDeclModel model, List reTryList, boolean forceJDOMUsage, IVisitorFactoryRule visitorFactory) {
        super.initialize((ASTNode)node, model, reTryList);
        this.forceJDOMUsage = forceJDOMUsage;
        this.visitorFactory = visitorFactory;
        this.fType = tr;
    }

    public static JavaElementInfo[] getCUMethods(MethodDeclaration[] aMethods, JavaElementInfo[] elements, IBeanDeclModel model) {
        ArrayList<JavaElementInfo> methods = new ArrayList<JavaElementInfo>();
        if (elements == null || elements.length == 0) {
            return null;
        }
        int i = 0;
        while (i < aMethods.length) {
            String Name2 = new String(aMethods[i].getName().getIdentifier());
            int Prev = 0;
            int dupCount = 0;
            i = 0;
            while (i < methods.size()) {
                if (methods.get(i) != null && ((JavaElementInfo)methods.get(i)).getName().equals(Name2)) {
                    ++dupCount;
                }
                ++i;
            }
            int j = Prev;
            while (j < elements.length) {
                if (Name2.equals(elements[j].getName()) && --dupCount < 0) break;
                ++j;
            }
            if (j >= elements.length) {
                methods.add(null);
            } else {
                methods.add(elements[j]);
                Prev = j + 1;
            }
            ++i;
        }
        return methods.toArray(new JavaElementInfo[elements.length]);
    }

    protected void createThisIfNecessary() {
        IThisReferenceRule thisRule = (IThisReferenceRule)CodeGenUtil.getEditorStyle(this.fModel).getRule("ruleIThisReference");
        TypeResolver.ResolvedType superResolved = null;
        if (this.fType.getTypeDecl().getSuperclass() != null) {
            superResolved = this.fModel.getResolver().resolveType(this.fType.getTypeDecl().getSuperclass());
        }
        ResourceSet rs = this.fModel.getCompositionModel().getModelResourceSet();
        if (superResolved != null && thisRule.useInheritance(((TypeResolver.Resolved)superResolved).getName(), rs) || thisRule.useInheritance(this.fType.getName(), rs)) {
            BeanPartFactory bpg = new BeanPartFactory(this.fType.getBeanModel(), null);
            bpg.createThisBeanPartIfNeeded(null);
        }
    }

    public void addFieldToMap(BeanPart bp, String method) {
        ArrayList<BeanPart> l = (ArrayList<BeanPart>)this.fInstanceDeclaredBeans.get(method);
        if (l == null) {
            l = new ArrayList<BeanPart>();
            this.fInstanceDeclaredBeans.put(method, l);
        }
        l.add(bp);
    }

    protected void visitAMethod(MethodDeclaration method, IBeanDeclModel model, List reTryList, CodeTypeRef typeRef, String methodHandle, ISourceRange range, String content) {
        Iterator itr;
        if (this.skipMethod(method)) {
            return;
        }
        String mName = method.getName().getIdentifier();
        MethodVisitor v = this.visitorFactory.getMethodVisitor();
        v.initialize(method, model, reTryList, typeRef, methodHandle, range, content, this.visitorFactory);
        v.setProgressMonitor(this.getProgressMonitor());
        if (this.fInstanceDeclaredBeans.get(mName) != null) {
            itr = ((List)this.fInstanceDeclaredBeans.get(mName)).iterator();
            while (itr.hasNext()) {
                v.setInitMethodFor((BeanPart)itr.next());
            }
        }
        v.visit();
        if (this.fInstanceDeclaredBeans.get(mName) != null) {
            itr = ((List)this.fInstanceDeclaredBeans.get(mName)).iterator();
            while (itr.hasNext()) {
                VariableDeclarationFragment f;
                FieldDeclaration fd;
                BeanPartDecleration bpDecl;
                BeanPart bp = (BeanPart)itr.next();
                if (bp.getInitExpression() != null || !bp.isInstanceInstantiation() || bp.getInitMethod() == null || !((bpDecl = bp.getDecleration()).getFieldDecl() instanceof FieldDeclaration) || (fd = (FieldDeclaration)bpDecl.getFieldDecl()).fragments() == null || fd.fragments().size() <= 0 || (f = (VariableDeclarationFragment)fd.fragments().get(0)) == null || f.getInitializer() == null || f.getInitializer() instanceof NullLiteral) continue;
                String typeSource = (String)typeRef.getTypeDecl().getProperty("org.eclipse.ve.codegen.source");
                AST ast = fd.getAST();
                VariableDeclarationStatement vds = ast.newVariableDeclarationStatement((VariableDeclarationFragment)ASTNode.copySubtree((AST)ast, (ASTNode)f));
                vds.setType((Type)ASTNode.copySubtree((AST)ast, (ASTNode)fd.getType()));
                vds.setModifiers(fd.getModifiers());
                vds.setSourceRange(fd.getStartPosition(), fd.getLength());
                CodeExpressionRef exp = new CodeExpressionRef((Statement)vds, typeSource, bp);
                exp.setState(4096, true);
                exp.setState(16384, true);
            }
        }
    }

    private boolean skipMethod(MethodDeclaration method) {
        boolean skip = false;
        if (method == null) {
            skip = true;
        } else {
            SingleVariableDeclaration svd;
            List params;
            String methodName = method.getName().getIdentifier();
            if ("main".equals(methodName) && Modifier.isStatic((int)method.getModifiers()) && (params = method.parameters()) != null && params.size() == 1 && params.get(0) instanceof SingleVariableDeclaration && (svd = (SingleVariableDeclaration)params.get(0)).getType() instanceof ArrayType) {
                Type simpleType = ((ArrayType)svd.getType()).getElementType();
                if (simpleType.isSimpleType()) {
                    if ("java.lang.String".equals(((SimpleType)simpleType).getName().getFullyQualifiedName()) || "String".equals(((SimpleType)simpleType).getName().getFullyQualifiedName())) {
                        skip = true;
                    }
                } else if (simpleType.isQualifiedType() && ("java.lang.String".equals(((QualifiedType)simpleType).getName().getFullyQualifiedName()) || "String".equals(((QualifiedType)simpleType).getName().getFullyQualifiedName()))) {
                    skip = true;
                }
            }
        }
        return skip;
    }

    public void visit() {
        this.getProgressMonitor().subTask(this.fType.getSimpleName());
        FieldDeclaration[] fields = this.fType.getTypeDecl().getFields();
        IInstanceVariableRule instVarRule = (IInstanceVariableRule)CodeGenUtil.getEditorStyle(this.fModel).getRule("ruleInstanceVariable");
        if (fields != null) {
            int i = 0;
            while (i < fields.length) {
                if (this.progressMonitor.isCanceled()) {
                    return;
                }
                if (instVarRule == null || !instVarRule.ignoreVariable(fields[i], this.fModel.getResolver(), this.fModel.getCompositionModel())) {
                    BeanPartDecleration decl = new BeanPartDecleration(fields[i]);
                    BeanPart bp = new BeanPart(decl);
                    this.fModel.addBean(bp);
                    String overidInitMethod = instVarRule.getDefaultInitializationMethod(fields[i], this.fModel.getResolver(), (TypeDeclaration)this.fVisitedNode);
                    if (overidInitMethod != null) {
                        this.addFieldToMap(bp, overidInitMethod);
                        bp.setInstanceInstantiation(true);
                    }
                }
                ++i;
            }
        }
        this.createThisIfNecessary();
        MethodDeclaration[] methods = this.fType.getTypeDecl().getMethods();
        if (this.forceJDOMUsage) {
            if (methods == null || methods.length == 0) {
                return;
            }
            int methodHandleUseCount = 0;
            int i = 0;
            while (i < methods.length) {
                block21: {
                    if (this.progressMonitor.isCanceled()) {
                        return;
                    }
                    try {
                        if (!methods[i].isConstructor()) {
                            String thisMethodHandle = "";
                            thisMethodHandle = this.methodHandles[methodHandleUseCount];
                            ++methodHandleUseCount;
                            this.visitAMethod(methods[i], this.fModel, this.fReTryLater, this.fType, thisMethodHandle, this.getSourceRange(methods[i].getStartPosition(), methods[i].getStartPosition() + methods[i].getLength()), String.copyValueOf(this.content, methods[i].getStartPosition(), methods[i].getLength()));
                        }
                    }
                    catch (Exception e) {
                        if (e.getCause() == null) break block21;
                        JavaVEPlugin.log((Throwable)e.getCause(), (Level)Level.WARNING);
                    }
                }
                ++i;
            }
        } else {
            JavaElementInfo[] cuMethods = TypeVisitor.getCUMethods(methods, this.JDTMethods, this.fModel);
            if (cuMethods == null || cuMethods.length < 1) {
                return;
            }
            if (cuMethods.length != methods.length) {
                throw new RuntimeException("methods length error");
            }
            int i = 0;
            while (i < methods.length) {
                block22: {
                    if (this.progressMonitor.isCanceled()) {
                        return;
                    }
                    try {
                        if (cuMethods[i] != null) {
                            this.visitAMethod(methods[i], this.fModel, this.fReTryLater, this.fType, cuMethods[i].getHandle(), cuMethods[i].getSourceRange(), cuMethods[i].getContent());
                        }
                    }
                    catch (Exception e) {
                        if (!JavaVEPlugin.isLoggingLevel((Level)Level.WARNING)) break block22;
                        String msg = e.getMessage();
                        if (e.getCause() != null) {
                            msg = e.getCause().getMessage();
                        }
                        JavaVEPlugin.log((Object)("TypeVisitor.visit() could not visit " + String.valueOf(methods[i].getName().getIdentifier()) + " : " + msg), (Level)Level.WARNING);
                    }
                }
                ++i;
            }
        }
    }

    protected ISourceRange getSourceRange(int start, int end) {
        final int offset = start;
        final int length = end - start + 1;
        return new ISourceRange(){

            public int getOffset() {
                return offset;
            }

            public int getLength() {
                return length;
            }
        };
    }

    public String toString() {
        return super.toString();
    }

    public void setJDTMethods(JavaElementInfo[] methods) {
        this.JDTMethods = methods;
    }
}

