/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.ve.internal.cde.emf.InverseMaintenanceAdapter;
import org.eclipse.ve.internal.java.codegen.java.CodeGenSourceRange;
import org.eclipse.ve.internal.java.codegen.java.ExpressionRefFactory;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenAdapter;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenSourceRange;
import org.eclipse.ve.internal.java.codegen.java.IJavaFeatureMapper;
import org.eclipse.ve.internal.java.codegen.java.MemberDecoderAdapter;
import org.eclipse.ve.internal.java.codegen.model.AbstractCodeRef;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeEventRef;
import org.eclipse.ve.internal.java.codegen.model.CodeExpressionRef;
import org.eclipse.ve.internal.java.codegen.model.CodeTypeRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.vce.rules.VCEPostSetCommand;
import org.eclipse.ve.internal.jcm.JCMFactory;
import org.eclipse.ve.internal.jcm.JCMMethod;

public class CodeMethodRef
extends AbstractCodeRef {
    protected MethodDeclaration fdeclMethod = null;
    protected CodeTypeRef fTypeRef = null;
    protected ArrayList fExpressions = new ArrayList();
    protected ArrayList fEventExpressions = new ArrayList();
    protected String fMethodHandle = null;
    protected String fMethodName;
    protected Object fSync = this;
    protected IBeanDeclModel fModel = null;
    protected JCMMethod fcompMethod = null;
    protected boolean fgenerationRequired = false;
    protected boolean fStaleOffset = false;
    private String[] fArgumentNames = null;

    public CodeMethodRef(MethodDeclaration method, CodeTypeRef tRef, String methodHandle, ISourceRange range, String content) {
        super(range.getOffset(), range.getLength(), content);
        this.fTypeRef = tRef;
        this.setMethodHandle(methodHandle);
        this.setDeclMethod(method);
        tRef.addRefMethod(this);
    }

    public CodeMethodRef(CodeTypeRef tr, String mName) {
        this.fTypeRef = tr;
        tr.addRefMethod(this);
        this.fMethodName = mName;
    }

    public CodeMethodRef(CodeTypeRef tr, String mName, JCMMethod cMethod) {
        this(tr, mName);
        this.fcompMethod = cMethod;
    }

    protected void setDeclMethod(MethodDeclaration method) {
        this.fdeclMethod = method;
        if (this.fdeclMethod != null) {
            this.fMethodName = method.getName().getIdentifier();
            List parameters = method.parameters();
            this.fArgumentNames = null;
            if (parameters != null) {
                this.fArgumentNames = new String[parameters.size()];
                int argCount = 0;
                while (argCount < parameters.size()) {
                    SingleVariableDeclaration svd = (SingleVariableDeclaration)parameters.get(argCount);
                    this.fArgumentNames[argCount] = svd.getName().getFullyQualifiedName();
                    ++argCount;
                }
            }
        }
    }

    public String getMethodName() {
        return this.fMethodName;
    }

    public MethodDeclaration getDeclMethod() {
        return this.fdeclMethod;
    }

    public void setMethodHandle(String handle) {
        this.fMethodHandle = handle;
        if (this.fModel != null) {
            Collection beans = this.fModel.getBeansInitilizedByMethod(this);
            Iterator iter = beans.iterator();
            while (iter.hasNext()) {
                BeanPart bean = (BeanPart)iter.next();
                this.fModel.updateBeanNameChange(bean);
            }
        }
    }

    public String getMethodHandle() {
        return this.fMethodHandle;
    }

    public int isEquivalent(AbstractCodeRef code) {
        return -1;
    }

    public void addExpressionRef(CodeExpressionRef ref) {
        int offset = ref.getOffset();
        if (this.fExpressions == null) {
            this.fExpressions = new ArrayList();
        }
        if (ref.isStateSet(128) && offset > -1) {
            int index = 0;
            while (index < this.fExpressions.size()) {
                if (((CodeExpressionRef)this.fExpressions.get(index)).getOffset() > offset) break;
                ++index;
            }
            if (index == this.fExpressions.size()) {
                this.fExpressions.add(ref);
            } else {
                this.fExpressions.add(index, ref);
            }
        } else {
            this.fExpressions.add(ref);
        }
    }

    public void addEventExpressionRef(CodeEventRef ref) {
        int offset = ref.getOffset();
        if (this.fEventExpressions == null) {
            this.fEventExpressions = new ArrayList();
        }
        if (ref.isStateSet(128) && offset > -1) {
            int index = 0;
            while (index < this.fEventExpressions.size()) {
                if (((CodeEventRef)this.fEventExpressions.get(index)).getOffset() > offset) break;
                ++index;
            }
            if (index == this.fEventExpressions.size()) {
                this.fEventExpressions.add(ref);
            } else {
                this.fEventExpressions.add(index, ref);
            }
        } else {
            this.fEventExpressions.add(ref);
        }
    }

    public void removeExpressionRef(CodeExpressionRef ref) {
        if (ref instanceof CodeEventRef) {
            this.removeEventRef((CodeEventRef)ref);
        } else if (this.fExpressions != null) {
            this.fExpressions.remove(ref);
        }
    }

    public void removeEventRef(CodeEventRef ref) {
        if (this.fEventExpressions != null) {
            this.fEventExpressions.remove(ref);
        }
    }

    public Iterator getExpressions() {
        if (this.fExpressions == null) {
            this.fExpressions = new ArrayList();
        }
        return new ArrayList(this.fExpressions).iterator();
    }

    public Iterator getEventExpressions() {
        if (this.fEventExpressions == null) {
            this.fEventExpressions = new ArrayList();
        }
        return new ArrayList(this.fEventExpressions).iterator();
    }

    public Iterator getAllExpressions() {
        final Iterator exp = this.getExpressions();
        final Iterator events = this.getEventExpressions();
        return new Iterator(){
            boolean eventsFlag = false;

            public boolean hasNext() {
                return exp.hasNext() || events.hasNext();
            }

            public Object next() {
                if (exp.hasNext()) {
                    return exp.next();
                }
                this.eventsFlag = true;
                return events.next();
            }

            public void remove() {
                if (this.eventsFlag) {
                    events.remove();
                } else {
                    exp.remove();
                }
            }
        };
    }

    protected void resetExpressionPriorities() {
        CodeExpressionRef expression;
        int count = 0;
        while (count < this.fExpressions.size()) {
            expression = (CodeExpressionRef)this.fExpressions.get(count);
            try {
                if (!expression.isStateSet(4) && expression.isAnyStateSet() && !expression.isStateSet(16)) {
                    expression.setProprity(expression.primGetDecoder().determinePriority());
                } else {
                    expression.isStateSet(4096);
                }
            }
            catch (Exception e) {
                JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
            }
            ++count;
        }
        count = 0;
        while (count < this.fEventExpressions.size()) {
            expression = (CodeExpressionRef)this.fEventExpressions.get(count);
            try {
                if (!expression.isStateSet(4) && expression.isAnyStateSet() && !expression.isStateSet(16)) {
                    expression.setProprity(expression.primGetDecoder().determinePriority());
                } else {
                    expression.isStateSet(4096);
                }
            }
            catch (Exception e) {
                JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
            }
            ++count;
        }
    }

    protected Object[] getUsableOffsetAndFiller() throws CodeGenException {
        int offset = -1;
        String filler = null;
        ArrayList list = new ArrayList();
        list.addAll(this.fExpressions);
        list.addAll(this.fEventExpressions);
        int i = list.size() - 1;
        while (i >= 0) {
            CodeExpressionRef ce = (CodeExpressionRef)list.get(i);
            if (ce.isStateSet(128) && ce.getOffset() >= 0 && !ce.isStateSet(8)) {
                offset = ce.getOffset() + ce.getLen();
                filler = ce.getFillerContent();
                break;
            }
            --i;
        }
        if (offset != -1 && filler != null) {
            return new Object[]{new Integer(offset), filler};
        }
        IType mainType = CodeGenUtil.getMainType(this.fModel.getCompilationUnit());
        IMethod fMethod = CodeGenUtil.getMethod(mainType, this.getMethodHandle());
        if (fMethod != null) {
            ICodeGenSourceRange sr = ExpressionRefFactory.getOffsetForFirstExpression(fMethod);
            if (sr == null) {
                throw new CodeGenException("Could not find Offset");
            }
            offset = sr.getOffset();
            StringBuffer sb = new StringBuffer();
            int i2 = 0;
            while (i2 < sr.getLength()) {
                sb.append(' ');
                ++i2;
            }
            filler = sb.toString();
        }
        return new Object[]{new Integer(offset), filler};
    }

    protected void addExpression(List l, CodeExpressionRef exp, int index) throws CodeGenException {
        String filler;
        int offset;
        CodeExpressionRef targetExp;
        int prevIndex = index - 1;
        if (index < l.size()) {
            targetExp = (CodeExpressionRef)l.get(index);
            while (index < l.size() && targetExp.isStateSet(8)) {
                if (++index >= l.size()) continue;
                targetExp = (CodeExpressionRef)l.get(index);
            }
        }
        if (prevIndex > 0) {
            targetExp = (CodeExpressionRef)l.get(prevIndex);
            while (prevIndex >= 0 && targetExp.isStateSet(8)) {
                if (--prevIndex < 0) continue;
                targetExp = (CodeExpressionRef)l.get(prevIndex);
            }
        }
        if (index >= l.size() && prevIndex < 0) {
            Object[] result = this.getUsableOffsetAndFiller();
            offset = (Integer)result[0];
            filler = (String)result[1];
        } else {
            CodeExpressionRef cExp;
            if (prevIndex >= 0) {
                cExp = (CodeExpressionRef)l.get(prevIndex);
                offset = cExp.getOffset() + cExp.getLen();
            } else {
                cExp = (CodeExpressionRef)l.get(index);
                offset = cExp.getOffset();
            }
            if (cExp.isStateSet(8192)) {
                filler = ((CodeExpressionRef)cExp.getSameLineExpressions().get(0)).getFillerContent();
                cExp.updateSharedLineExpressions(true);
                offset = prevIndex >= 0 ? cExp.getOffset() + cExp.getLen() : cExp.getOffset();
            } else {
                filler = cExp.getFillerContent();
            }
        }
        exp.setFillerContent(filler);
        exp.setOffset(offset);
        exp.setState(128, true);
        l.add(index, exp);
    }

    protected boolean isGrouping(BeanPart bp, List expressions, int index) {
        boolean result = false;
        int i = index;
        while (i >= 0) {
            CodeExpressionRef exp = (CodeExpressionRef)expressions.get(i);
            if (exp.getBean() != bp) break;
            if (exp.isStateSet(4096)) {
                result = true;
                break;
            }
            --i;
        }
        return result;
    }

    protected boolean isLowZOrderInGroup(BeanPart bp, List expressions, int index, IJavaFeatureMapper.VEexpressionPriority pri) {
        boolean result = false;
        if (pri.isIndexed()) {
            int i = index;
            while (i >= 0) {
                CodeExpressionRef exp = (CodeExpressionRef)expressions.get(i);
                IJavaFeatureMapper.VEexpressionPriority cp = exp.getPriority();
                if (cp.isIndexed() && pri.comparePriority(cp) > 0) {
                    result = true;
                    break;
                }
                if (exp.getBean() != bp || exp.isStateSet(4096)) break;
                --i;
            }
        }
        return result;
    }

    protected int getGroupLastIndex(List sortedList, BeanPart bp) {
        int idx = 0;
        while (idx < sortedList.size()) {
            CodeExpressionRef exp = (CodeExpressionRef)sortedList.get(idx);
            if (exp.getBean() == bp && exp.isStateSet(4096)) {
                while (idx < sortedList.size()) {
                    CodeExpressionRef exp2 = (CodeExpressionRef)sortedList.get(idx);
                    if (exp2.getBean() != bp) {
                        return idx - 1;
                    }
                    ++idx;
                }
                return idx - 1;
            }
            ++idx;
        }
        return -1;
    }

    private boolean isRelated(CodeExpressionRef exp, List references) {
        Object[] args;
        EReference sf = (EReference)exp.getPriority().getProiorityIndex().getSf();
        if (VCEPostSetCommand.isChildRelationShip((EReference)sf) && (args = exp.getArgs()) != null) {
            int i = 0;
            while (i < args.length) {
                if (references.contains(args[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void addExpressionToSortedList(List sortedList, CodeExpressionRef exp) throws CodeGenException {
        int index;
        block13: {
            int last;
            int first;
            List dependantBeans;
            IJavaFeatureMapper.VEexpressionPriority expPriority;
            block12: {
                index = -1;
                expPriority = exp.getPriority();
                dependantBeans = exp.getReferences();
                first = -1;
                last = -1;
                if (!expPriority.equals(IJavaFeatureMapper.NOPriority)) break block12;
                index = sortedList.size();
                break block13;
            }
            boolean firstBean = true;
            int i = sortedList.size() - 1;
            while (i >= 0 && first < 0) {
                block14: {
                    int compare;
                    block18: {
                        boolean indexsSet;
                        CodeExpressionRef cExp;
                        block15: {
                            block19: {
                                block20: {
                                    block17: {
                                        block16: {
                                            if (first >= 0) break;
                                            cExp = (CodeExpressionRef)sortedList.get(i);
                                            if (cExp.isStateSet(8)) break block14;
                                            boolean sameBean = cExp.getBean() == exp.getBean();
                                            firstBean &= !sameBean;
                                            if (!sameBean) break block15;
                                            if (!exp.isStateSet(4096)) break block16;
                                            last = i;
                                            break block14;
                                        }
                                        if (!cExp.isStateSet(4096)) break block17;
                                        compare = -1;
                                        break block18;
                                    }
                                    if (!cExp.getPriority().isIndexed()) break block19;
                                    if (!expPriority.isIndexed()) break block20;
                                    compare = expPriority.comparePriority(cExp.getPriority());
                                    if (compare == 0 && this.isRelated(cExp, dependantBeans)) {
                                        compare = -1;
                                    }
                                    break block18;
                                }
                                boolean grouping = this.isGrouping(exp.getBean(), sortedList, i);
                                boolean related = this.isRelated(cExp, dependantBeans);
                                if (!grouping && !related) break block14;
                                compare = 1;
                                if (!related) break block18;
                                compare = -1;
                                break block18;
                            }
                            compare = expPriority.comparePriority(cExp.getPriority());
                            break block18;
                        }
                        boolean bl = indexsSet = cExp.getPriority().isIndexed() && expPriority.isIndexed() && expPriority.sameIndexFeature(cExp.getPriority());
                        if (indexsSet && cExp.getPriority().compareIndex(expPriority) > 0 || dependantBeans.contains(cExp.getBean().getEObject()) && this.isGrouping(cExp.getBean(), sortedList, i) && !this.isLowZOrderInGroup(cExp.getBean(), sortedList, i, expPriority)) {
                            if (!dependantBeans.contains(cExp.getBean().getEObject())) {
                                dependantBeans.add(cExp.getBean().getEObject());
                            }
                            int firstIndex = i + 1 >= sortedList.size() ? sortedList.size() : i + 1;
                            int j = i + 1;
                            while (j < sortedList.size()) {
                                CodeExpressionRef skip = (CodeExpressionRef)sortedList.get(j);
                                if (skip.getBean() != cExp.getBean()) break;
                                firstIndex = j + 1 >= sortedList.size() ? sortedList.size() : j + 1;
                                ++j;
                            }
                            first = firstIndex;
                        } else if (indexsSet && cExp.getPriority().compareIndex(expPriority) < 0) {
                            last = i;
                        }
                        break block14;
                    }
                    switch (compare) {
                        case -1: {
                            first = i + 1 >= sortedList.size() ? sortedList.size() : i + 1;
                            break;
                        }
                        case 0: {
                            if (last >= 0 && last <= this.getGroupLastIndex(sortedList, exp.getBean())) break;
                            last = i + 1 >= sortedList.size() ? sortedList.size() : i + 1;
                            break;
                        }
                        case 1: {
                            last = i;
                        }
                    }
                }
                --i;
            }
            index = first >= 0 ? (last >= 0 ? last : first) : (firstBean ? 0 : (last >= 0 ? last : 0));
        }
        this.addExpression(sortedList, exp, index);
    }

    protected ArrayList sortExpressions(List list) throws CodeGenException {
        ArrayList<CodeExpressionRef> sortedList = new ArrayList<CodeExpressionRef>();
        ArrayList<CodeExpressionRef> needSorting = new ArrayList<CodeExpressionRef>();
        ArrayList<CodeExpressionRef> notReadyForSorting = new ArrayList<CodeExpressionRef>();
        int i = 0;
        while (i < list.size()) {
            CodeExpressionRef exp = (CodeExpressionRef)list.get(i);
            if (!exp.isStateSet(2)) {
                notReadyForSorting.add(exp);
            } else if (!exp.isStateSet(128)) {
                if (!exp.isStateSet(16384)) {
                    needSorting.add(exp);
                }
            } else {
                sortedList.add(exp);
                if (exp.getOffset() < 0) {
                    throw new CodeGenException("Invalid Offset: " + exp);
                }
            }
            ++i;
        }
        if (needSorting.size() > 1) {
            throw new CodeGenException("Limitation ... only one new expression is allowed");
        }
        i = 0;
        while (i < needSorting.size()) {
            this.addExpressionToSortedList(sortedList, (CodeExpressionRef)needSorting.get(i));
            ++i;
        }
        sortedList.addAll(notReadyForSorting);
        return sortedList;
    }

    public void updateExpressionOrder() throws CodeGenException {
        ArrayList sortedList;
        this.fExpressions = sortedList = this.sortExpressions(this.fExpressions);
        if (this.fEventExpressions != null && this.fEventExpressions.size() > 0) {
            ArrayList allExpressions = new ArrayList(this.fExpressions);
            allExpressions.addAll(this.fEventExpressions);
            sortedList = this.sortExpressions(allExpressions);
            sortedList.removeAll(this.fExpressions);
            this.fEventExpressions = sortedList;
        }
    }

    protected static Enumeration determineBeanOrder(Enumeration beans) {
        TreeSet beanSorter = new TreeSet(CodeMethodRef.getDefaultBeanOrderComparator());
        while (beans.hasMoreElements()) {
            boolean added = beanSorter.add(beans.nextElement());
            if (added) continue;
            JavaVEPlugin.log((Object)"No addition to the treeset", (Level)Level.FINE);
        }
        Vector order = new Vector();
        Iterator sorted = beanSorter.iterator();
        while (sorted.hasNext()) {
            order.add(sorted.next());
        }
        return order.elements();
    }

    protected static Comparator getDefaultBeanOrderComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                int np2;
                BeanPart bp1 = (BeanPart)o1;
                BeanPart bp2 = (BeanPart)o2;
                int np1 = this.getImportanceCount(bp1, bp2);
                if (np1 < (np2 = this.getImportanceCount(bp2, bp1))) {
                    return 1;
                }
                if (np1 == np2) {
                    return -1;
                }
                return -1;
            }

            protected boolean isReferenced(BeanPart parent, BeanPart reference) {
                EReference[] sfs = InverseMaintenanceAdapter.getReferencesFrom((EObject)parent.getEObject(), (Notifier)reference.getEObject());
                return sfs != null && sfs.length > 0;
            }

            protected int getImportanceCount(BeanPart main, BeanPart subMain) {
                boolean sV;
                if (this.isAChildOf(main, subMain)) {
                    return Integer.MAX_VALUE;
                }
                if (this.isReferenced(main, subMain)) {
                    return Integer.MIN_VALUE;
                }
                boolean mV = main.getDecleration().isInstanceVar();
                boolean bl = sV = subMain.getDecleration().isInstanceVar();
                if (mV > sV) {
                    return Integer.MIN_VALUE;
                }
                if (mV < sV) {
                    return Integer.MAX_VALUE;
                }
                int parentCount = this.getParentCount(main);
                int hasChildren = this.getConstraintCount(main);
                return -hasChildren - parentCount;
            }

            protected boolean isAChildOf(BeanPart parent, BeanPart reference) {
                Iterator children = parent.getChildren();
                while (children.hasNext()) {
                    BeanPart child = (BeanPart)children.next();
                    if (child.getSimpleName().equals(reference.getSimpleName())) {
                        return true;
                    }
                    if (!this.isAChildOf(child, reference)) continue;
                    return true;
                }
                return false;
            }

            protected int getConstraintCount(BeanPart b) {
                EStructuralFeature sf = b.getEObject().eClass().getEStructuralFeature("components");
                if (sf != null) {
                    return 1;
                }
                if (CodeGenUtil.getConstraintFeature(b.getEObject()) != null) {
                    return 1;
                }
                return 0;
            }

            protected int getParentCount(BeanPart b) {
                int pc = 0;
                int safetyCount = 1000;
                BeanPart parent = b;
                while (parent != null && safetyCount > 0) {
                    parent = CodeGenUtil.determineParentBeanpart(parent);
                    ++pc;
                    --safetyCount;
                }
                return pc;
            }
        };
    }

    public void dispose() {
        Object[] tmp;
        if (this.fModel != null) {
            Iterator itr = this.fModel.getBeansInitilizedByMethod(this).iterator();
            while (itr.hasNext()) {
                BeanPart b = (BeanPart)itr.next();
                b.removeInitMethod(this);
                b.removeReturnMethod(this);
            }
        }
        if (this.fExpressions != null) {
            tmp = this.fExpressions.toArray();
            int i = 0;
            while (i < tmp.length) {
                ((CodeExpressionRef)tmp[i]).dispose();
                ++i;
            }
        }
        this.fExpressions = null;
        if (this.fEventExpressions != null) {
            tmp = this.fEventExpressions.toArray();
            int i = 0;
            while (i < tmp.length) {
                ((CodeEventRef)tmp[i]).dispose();
                ++i;
            }
        }
        this.fExpressions = null;
        if (this.fTypeRef != null) {
            this.fTypeRef.removeRefMethod(this);
        }
        if (this.fModel != null) {
            this.fModel.removeMethodRef(this);
        }
        this.fdeclMethod = null;
        if (this.fcompMethod != null) {
            this.fTypeRef.getBeanComposition().getMethods().remove((Object)this.fcompMethod);
        }
        this.fTypeRef = null;
        this.fcompMethod = null;
    }

    public ICodeGenSourceRange getTargetSourceRange() {
        if (this.fModel == null) {
            return null;
        }
        ISourceRange sr = this.fModel.getWorkingCopyProvider().getSourceRange(this.getMethodHandle());
        CodeGenSourceRange result = new CodeGenSourceRange(sr);
        if (sr != null) {
            result.setLineOffset(this.fModel.getWorkingCopyProvider().getLineNo(result.getOffset()));
        }
        return result;
    }

    public ICodeGenSourceRange getHighlightSourceRange() {
        if (this.fModel == null || this.fModel.getWorkingCopyProvider() == null) {
            return null;
        }
        try {
            IMethod mtd = (IMethod)this.fModel.getWorkingCopyProvider().getElement(this.getMethodHandle());
            if (mtd != null) {
                int start = mtd.getNameRange().getOffset();
                int end = mtd.getSourceRange().getOffset() + mtd.getSourceRange().getLength();
                start = this.fModel.getCompilationUnit().getSource().lastIndexOf(10, start) + 1;
                CodeGenSourceRange result = new CodeGenSourceRange(start, end - start);
                result.setLineOffset(this.fModel.getWorkingCopyProvider().getLineNo(result.getOffset()));
                return result;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public void setModel(IBeanDeclModel model) {
        this.fModel = model;
    }

    public void refreshIMethod() {
        try {
            try {
                if (!this.fModel.getCompilationUnit().isConsistent()) {
                    this.fModel.getCompilationUnit().reconcile(0, false, null, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (JavaModelException javaModelException) {}
            IType mainType = CodeGenUtil.getMainType(this.fModel.getCompilationUnit());
            IMethod m = CodeGenUtil.getMethod(mainType, this.getMethodHandle());
            this.refreshIMethod(m);
        }
        catch (Exception e) {
            JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
        }
    }

    public void refreshIMethod(IMethod m) {
        try {
            if (m != null) {
                this.setOffset(m.getSourceRange().getOffset());
            }
        }
        catch (JavaModelException e) {
            JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
        }
    }

    public String _debugExpressions() {
        StringBuffer sb = new StringBuffer();
        int mOffset = this.getOffset();
        String doc = this.fModel.getDocumentBuffer().getContents();
        Iterator itr = this.getExpressions();
        try {
            while (itr.hasNext()) {
                CodeExpressionRef exp = (CodeExpressionRef)itr.next();
                sb.append(String.valueOf(exp.toString()) + "\n\"");
                if (!exp.isStateSet(16) && !exp.isStateSet(8)) {
                    sb.append(doc.substring(mOffset + exp.getOffset(), mOffset + exp.getOffset() + exp.getLen()));
                } else {
                    sb.append("STATE_NOT_EXISTANT");
                }
                sb.append("\"\n");
            }
        }
        catch (Exception exception) {
            sb.append("**Error***\n");
        }
        return sb.toString();
    }

    public JCMMethod getCompMethod() {
        if (this.fcompMethod == null) {
            this.fcompMethod = JCMFactory.eINSTANCE.createJCMMethod();
            this.fcompMethod.setName(this.getMethodName());
            MemberDecoderAdapter a = new MemberDecoderAdapter(this.fModel);
            a.setMethodRef(this);
            a.setTarget((Notifier)this.fcompMethod);
            this.fcompMethod.eAdapters().add((Object)a);
            this.fTypeRef.getBeanComposition().getMethods().add((Object)this.fcompMethod);
        }
        return this.fcompMethod;
    }

    public void restore() {
        if (this.fcompMethod == null) {
            EList methods = this.fTypeRef.getBeanComposition().getMethods();
            int i = 0;
            while (i < methods.size()) {
                JCMMethod method = (JCMMethod)methods.get(i);
                if (method.getName().equals(this.getMethodName())) {
                    this.fcompMethod = method;
                    MemberDecoderAdapter a = new MemberDecoderAdapter(this.fModel);
                    a.setMethodRef(this);
                    a.setTarget((Notifier)this.fcompMethod);
                    this.fcompMethod.eAdapters().add((Object)a);
                    return;
                }
                ++i;
            }
            JavaVEPlugin.log((Object)"should not be here", (Level)Level.SEVERE);
        }
    }

    public void setCompMethod(JCMMethod m) throws CodeGenException {
        if (this.fcompMethod != null) {
            throw new CodeGenException("Already initialized");
        }
        this.fcompMethod = m;
        MemberDecoderAdapter ma = (MemberDecoderAdapter)EcoreUtil.getExistingAdapter((Notifier)m, (Object)ICodeGenAdapter.JVE_MEMBER_ADAPTER);
        ma.setMethodRef(this);
        m.setName(this.getMethodName());
    }

    public boolean isGenerationRequired() {
        return this.fgenerationRequired;
    }

    public void setGenerationRequired(boolean enerationRequired) {
        this.fgenerationRequired = enerationRequired;
    }

    public CodeTypeRef getTypeRef() {
        return this.fTypeRef;
    }

    public String toString() {
        return this.fStaleOffset ? "***StaleOffset***\n" + super.toString() : super.toString();
    }

    public void setOffset(int off) {
        super.setOffset(off);
        this.fStaleOffset = false;
    }

    public void setContent(String content) {
        super.setContent(content);
        this.fStaleOffset = false;
    }

    public void updateExpressionsOffset(int offset, int delta) {
        Iterator itr = this.getAllExpressions();
        while (itr.hasNext()) {
            CodeExpressionRef exp = (CodeExpressionRef)itr.next();
            if (exp.isStateSet(64) || exp.isStateSet(16) || exp.getOffset() + this.getOffset() < offset) continue;
            exp.setOffset(exp.getOffset() + delta);
        }
    }

    protected void refreshExpressionOrder(List currentList, CodeExpressionRef exp) throws CodeGenException {
        currentList.remove(exp);
        this.addExpressionToSortedList(currentList, exp);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateExpressionIndex(CodeExpressionRef exp) throws CodeGenException {
        if (exp.isStateSet(8)) return;
        if (exp.isStateSet(16)) {
            return;
        }
        if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
            JavaVEPlugin.log((Object)("CodeExpressionRef: moving:\n" + this.getContent() + "\n"), (Level)Level.FINE);
        }
        try {
            exp.setState(64, true);
            String txt = exp.getContent();
            int docOff = exp.getOffset() + this.getOffset();
            if (exp.isStateSet(128)) {
                exp.updateDocument(docOff, txt.length(), "");
            }
            if (this.fExpressions.indexOf(exp) >= 0) {
                this.refreshExpressionOrder(this.fExpressions, exp);
            } else if (this.fEventExpressions.indexOf(exp) > 0) {
                this.refreshExpressionOrder(this.fEventExpressions, exp);
            }
            txt = exp.getContent();
            docOff = exp.getOffset() + this.getOffset();
            exp.updateDocument(docOff, 0, txt);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            exp.setState(64, false);
            throw throwable;
        }
        {
            Object var4_6 = null;
            exp.setState(64, false);
            return;
        }
    }

    public boolean refresh(CodeMethodRef cmr) {
        if (cmr == null) {
            return false;
        }
        if (this.getOffset() != cmr.getOffset()) {
            this.setOffset(cmr.getOffset());
        }
        if (this.getContent() != null && !this.getContent().equals(cmr.getContent())) {
            this.setContent(cmr.getContent());
        }
        if (cmr.getDeclMethod() != null) {
            this.setDeclMethod(cmr.getDeclMethod());
        }
        return true;
    }

    public String[] getArgumentNames() {
        return this.fArgumentNames;
    }
}

