/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.util;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.ve.internal.java.codegen.util.CodeTemplateHelper;
import org.eclipse.ve.internal.java.vce.VCEPreferences;

public class BeanMethodTemplate {
    public static final String COMMENT_BEG = "/**";
    public static final String COMMENT_END = " */";
    public static final String COMMENT = " * ";
    public static final String MODIFIER = "private";
    public static final String EQNULL = " == null";
    public static final String RETURN = "return";
    public static final String COMMENT_IMPLICIT = "  // Generated";
    public static final String COMMENT_EXPLICIT = "  // Generated";
    public static final String VCE_COMMENT = "This method initializes ";
    public static final String VOID = "void";
    String fBeanType;
    String fBeanName;
    String fMethodName;
    String[] fComments;
    String fBeanInitString;
    String fBeanConstructorString = null;
    int fBeanInitStringOffset = -1;
    boolean fImplicitMethod = false;
    String fLineSeperator = System.getProperty("line.separator");
    boolean fInLineMethod = false;
    boolean fisThisMethod = false;
    String vce_comment = null;
    String fModifier = "private";
    boolean fGenerateComments = false;
    boolean fGenerateTryCatch = false;

    public BeanMethodTemplate(String btype, String bname, String mname, String[] comments) {
        this.fBeanType = btype;
        this.fBeanName = bname;
        this.fMethodName = mname;
        this.fComments = comments;
        this.fBeanInitString = null;
        this.vce_comment = VCE_COMMENT + this.fBeanName;
        Preferences store = VCEPreferences.getPlugin().getPluginPreferences();
        this.fGenerateComments = store.getBoolean("GENERATE_EXPRESSION_COMMENT");
        this.fGenerateTryCatch = store.getBoolean("GENERATE_TRY_CATCH_BLOCK");
    }

    public void setInLineMethod(boolean flag) {
        this.fInLineMethod = flag;
    }

    public void setThisMethod(boolean flag) {
        this.fisThisMethod = flag;
        if (flag) {
            this.setBeanInitString("");
        }
    }

    public void setSeperator(String sep) {
        this.fLineSeperator = sep;
    }

    public void setModifier(String m) {
        this.fModifier = m;
    }

    public int getInitExpressionOffset() {
        return this.fBeanInitStringOffset;
    }

    public String getInitExpression() {
        String line = this.getInitString();
        return line.substring(0, line.indexOf(")") + 1);
    }

    public void setImplicit(boolean flag) {
        this.fImplicitMethod = flag;
    }

    public void setComments(String[] comments) {
        this.fComments = comments;
    }

    protected void punchLine(StringBuffer sb, Object content, int codeLevel) {
        if (content != null) {
            sb.append(CodeTemplateHelper.getFillerForLevel(codeLevel));
            sb.append(content.toString());
        }
        sb.append(this.fLineSeperator);
    }

    public void setBeanInitString(String str) {
        this.fBeanInitString = str;
    }

    public void setBeanConstructorString(String str) {
        this.fBeanConstructorString = str;
    }

    public static String getInitExprFiller() {
        if (VCEPreferences.getPlugin().getPluginPreferences().getBoolean("GENERATE_TRY_CATCH_BLOCK")) {
            return CodeTemplateHelper.getFillerForLevel(CodeTemplateHelper.NORMAL_TRY_CONTENT_LEVEL);
        }
        return CodeTemplateHelper.getFillerForLevel(CodeTemplateHelper.NORMAL_IF_CONTENT_LEVEL);
    }

    private String getInitString() {
        String result;
        if (this.fBeanInitString == null) {
            result = this.fInLineMethod ? String.valueOf(this.fBeanType) + " " : "";
            if (this.fImplicitMethod) {
                result = String.valueOf(result) + this.fBeanName + " = arg;";
                if (this.fGenerateComments) {
                    result = String.valueOf(result) + "  // Generated";
                }
            } else {
                result = this.fBeanConstructorString == null ? String.valueOf(result) + this.fBeanName + " = new " + this.fBeanType + "(); " : String.valueOf(result) + this.fBeanName + " = " + this.fBeanConstructorString + ";";
                if (this.fGenerateComments) {
                    result = String.valueOf(result) + "  // Generated";
                }
            }
        } else {
            result = this.fBeanInitString;
        }
        return result;
    }

    public String getPrefix() {
        int level;
        StringBuffer sb = new StringBuffer(1000);
        this.punchLine(sb, COMMENT_BEG, CodeTemplateHelper.NORMAL_METHOD_DEF_LEVEL);
        this.punchLine(sb, COMMENT + this.vce_comment, CodeTemplateHelper.NORMAL_METHOD_DEF_LEVEL);
        this.punchLine(sb, COMMENT, CodeTemplateHelper.NORMAL_METHOD_DEF_LEVEL);
        if (this.fComments != null) {
            int i = 0;
            while (i < this.fComments.length) {
                this.punchLine(sb, COMMENT + this.fComments[i], CodeTemplateHelper.NORMAL_METHOD_DEF_LEVEL);
                ++i;
            }
            this.punchLine(sb, COMMENT, CodeTemplateHelper.NORMAL_METHOD_DEF_LEVEL);
        }
        if (!this.fBeanType.equals(VOID)) {
            this.punchLine(sb, " * @return " + this.fBeanType, CodeTemplateHelper.NORMAL_METHOD_DEF_LEVEL);
        }
        this.punchLine(sb, COMMENT_END, CodeTemplateHelper.NORMAL_METHOD_DEF_LEVEL);
        if (this.fImplicitMethod) {
            this.punchLine(sb, String.valueOf(this.fModifier) + " " + this.fBeanType + " " + this.fMethodName + "(" + this.fBeanType + " " + "arg" + ")" + " " + "{", CodeTemplateHelper.NORMAL_METHOD_DEF_LEVEL);
        } else {
            this.punchLine(sb, String.valueOf(this.fModifier) + " " + this.fBeanType + " " + this.fMethodName + "(" + ")" + " " + "{", CodeTemplateHelper.NORMAL_METHOD_DEF_LEVEL);
        }
        if (!this.fisThisMethod) {
            this.punchLine(sb, "if(" + this.fBeanName + EQNULL + ")" + " " + "{", CodeTemplateHelper.NORMAL_METHOD_CONTENT_LEVEL);
            level = CodeTemplateHelper.NORMAL_IF_CONTENT_LEVEL;
        } else {
            level = CodeTemplateHelper.NORMAL_METHOD_CONTENT_LEVEL;
        }
        if (this.fGenerateTryCatch) {
            this.punchLine(sb, "try {", level);
        }
        this.fBeanInitStringOffset = sb.length() + BeanMethodTemplate.getInitExprFiller().length();
        if (this.fGenerateTryCatch) {
            this.punchLine(sb, this.getInitString(), CodeTemplateHelper.NORMAL_TRY_CONTENT_LEVEL);
        } else {
            this.punchLine(sb, this.getInitString(), CodeTemplateHelper.NORMAL_IF_CONTENT_LEVEL);
        }
        return sb.toString();
    }

    public String getPostfix() {
        StringBuffer sb = new StringBuffer();
        int level = 0;
        if (this.fGenerateTryCatch) {
            level = this.fisThisMethod ? CodeTemplateHelper.NORMAL_METHOD_CONTENT_LEVEL : CodeTemplateHelper.NORMAL_IF_CONTENT_LEVEL;
            this.punchLine(sb, "}", level);
            this.punchLine(sb, "catch (java.lang.Throwable e) {", level);
            this.punchLine(sb, "//  Do Something", level + 1);
            this.punchLine(sb, "}", level);
        }
        if (!this.fisThisMethod) {
            this.punchLine(sb, "}", CodeTemplateHelper.NORMAL_METHOD_CONTENT_LEVEL);
            this.punchLine(sb, "return " + this.fBeanName + ";", CodeTemplateHelper.NORMAL_METHOD_CONTENT_LEVEL);
        }
        this.punchLine(sb, "}", CodeTemplateHelper.NORMAL_METHOD_DEF_LEVEL);
        return sb.toString();
    }
}

