/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.util;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ve.internal.java.codegen.util.AbstractClassGenerator;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;

public class DefaultClassGenerator
extends AbstractClassGenerator {
    String ftmplDir;
    String ftmplName;
    String fpluginName;

    public DefaultClassGenerator(String className, String pkgName, String pluginName, String tmplDirectory, String tmplName) {
        super(className, pkgName);
        this.ftmplName = tmplName;
        this.ftmplDir = tmplDirectory;
        this.fpluginName = pluginName;
    }

    protected AbstractClassGenerator.IClassTemplate getClassTemplate() {
        return this.getClassTemplate(String.valueOf(this.ftmplName) + ".javajet", this.ftmplName);
    }

    protected AbstractClassGenerator.ClassInfo getTemplateInfo() {
        return new AbstractClassGenerator.ClassInfo();
    }

    protected String getBasePlugin() {
        return this.fpluginName;
    }

    protected String getTemplateDirPath() {
        return this.ftmplDir;
    }

    public String getTemplteContent() {
        return this.getClassTemplate().generateClassContent(this.getTemplateInfo());
    }

    public static String format(String src, int kind, Map options, String lineSeperator) {
        CodeFormatter formatter = ToolFactory.createCodeFormatter((Map)options);
        TextEdit te = formatter.format(kind, src, 0, src.length(), 0, lineSeperator);
        Document d = new Document(src);
        try {
            te.apply((IDocument)d);
        }
        catch (MalformedTreeException malformedTreeException) {
        }
        catch (BadLocationException badLocationException) {}
        return d.get();
    }

    public void generateClass(IProgressMonitor monitor) throws CodeGenException {
        block7: {
            if (this.fProject == null) {
                throw new CodeGenException("Project is not set");
            }
            IPackageFragment pkg = this.generatePackageIfNeeded(monitor);
            try {
                ICompilationUnit cu = pkg.createCompilationUnit(String.valueOf(this.fClassName) + ".java", this.getTemplteContent(), true, monitor);
                if (!this.fFormatTemplate) break block7;
                ICompilationUnit wc = cu.getWorkingCopy(monitor);
                if (PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.javadoc")) {
                    try {
                        String comment = CodeGeneration.getTypeComment((ICompilationUnit)cu, (String)cu.getAllTypes()[0].getElementName(), (String)this.fNL);
                        if (wc.getPackageDeclarations().length > 0) {
                            ISourceRange sr = wc.getPackageDeclarations()[0].getSourceRange();
                            wc.getBuffer().replace(sr.getOffset(), sr.getLength(), "");
                        }
                        String content = CodeGeneration.getCompilationUnitContent((ICompilationUnit)wc, (String)comment, (String)wc.getSource(), (String)this.fNL);
                        wc.getBuffer().setContents(content);
                    }
                    catch (CoreException coreException) {}
                }
                String content = DefaultClassGenerator.format(wc.getSource(), 8, this.fProjectOptions, this.fNL);
                wc.getBuffer().setContents(content);
                wc.commitWorkingCopy(true, monitor);
            }
            catch (JavaModelException e) {
                throw new CodeGenException(e.getMessage());
            }
        }
    }
}

