/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.util;

import java.awt.Point;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.ve.internal.java.codegen.model.IScannerFactory;
import org.eclipse.ve.internal.java.codegen.util.AbstractAnnotationTemplate;

public class FreeFormAnnotationTemplate
extends AbstractAnnotationTemplate {
    public static final String VISUAL_CONTENT_TYPE = "visual-constraint";
    public static final String ANNOTATION_START = "//";
    public static final String ANNOTATION_PREFIX = "  //";
    String positionString = "";
    String parseString = "";

    public FreeFormAnnotationTemplate() {
        super("decl-index=0");
    }

    public FreeFormAnnotationTemplate(int x, int y) {
        super("decl-index=0");
        this.setPosition(new Point(x, y));
    }

    public void setPosition(Point point) {
        this.positionString = point == null ? "visual-constraint=\"\"" : "visual-constraint=\"" + Integer.toString(point.x) + "," + Integer.toString(point.y) + "\"";
    }

    protected static int getSigOnSameLine(int s, String src, String sig) {
        int start = src.indexOf(sig, s);
        if (start < 0) {
            return -1;
        }
        int nlIndex = src.indexOf(10);
        if (nlIndex >= 0 && nlIndex <= start) {
            return -1;
        }
        return start;
    }

    protected static int getSigOnSameLine(int s, String src, char sig) {
        int start = src.indexOf(sig, s);
        if (start < 0) {
            return -1;
        }
        int nlIndex = src.indexOf(10);
        if (nlIndex >= 0 && nlIndex <= start) {
            return -1;
        }
        return start;
    }

    public static int getAnnotationStart(String src) {
        int commentStart = FreeFormAnnotationTemplate.getSigOnSameLine(0, src, ANNOTATION_START);
        if (commentStart < 0) {
            return -1;
        }
        int annotationStart = FreeFormAnnotationTemplate.getSigOnSameLine(commentStart, src, "@jve:");
        if (annotationStart < 0) {
            return -1;
        }
        int lastCommentStart = src.lastIndexOf(ANNOTATION_START, annotationStart);
        return lastCommentStart;
    }

    public static int collectPrecedingSpaces(String src, int from) {
        if (from > 0) {
            char oneCharLeft = src.charAt(from - 1);
            while (oneCharLeft == ' ' || oneCharLeft == '\t') {
                if (--from <= 0) break;
                oneCharLeft = src.charAt(from - 1);
            }
        }
        return from;
    }

    public static int getEOL(String src, int offset) {
        if (src == null || offset < 0 || offset > src.length()) {
            return offset;
        }
        int eol1 = src.indexOf(13, offset);
        int eol2 = src.indexOf(10, offset);
        if (eol1 == -1 && eol2 == -1) {
            return offset;
        }
        if (eol1 == -1) {
            return eol2;
        }
        if (eol2 == -1) {
            return eol1;
        }
        return Math.min(eol1, eol2);
    }

    public static int getAnnotationArgStart(String src, int start) {
        try {
            start = src.indexOf("@jve:", start);
            if (start < 0) {
                return -1;
            }
            int end = src.indexOf(VISUAL_CONTENT_TYPE, start);
            if (end < 0) {
                return -1;
            }
            if ((end = src.indexOf(34, end)) < 0) {
                return -1;
            }
            return end + 1;
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public static int[] getAnnotationArgs(String src, int start) {
        int s = FreeFormAnnotationTemplate.getAnnotationArgStart(src, start);
        if (s < 0) {
            return null;
        }
        if (start < 0) {
            return null;
        }
        int sep = FreeFormAnnotationTemplate.getSigOnSameLine(s, src, ',');
        if (sep < 0) {
            return null;
        }
        int end = src.indexOf(34, sep);
        int[] result = new int[]{Integer.parseInt(src.substring(s, sep)), Integer.parseInt(src.substring(sep + 1, end))};
        return result;
    }

    protected static int getCommentLineEnd(String src, int start, IScannerFactory scannerFactory) {
        int endOfCommentLine;
        block9: {
            endOfCommentLine = -1;
            try {
                int wc;
                char[] whitespaceChars;
                int jveAnnotationStart = FreeFormAnnotationTemplate.getSigOnSameLine(start, src, "@jve:");
                if (jveAnnotationStart <= -1) break block9;
                IScanner scanner = scannerFactory.getScanner(true, true, true);
                scanner.setSource(src.substring(jveAnnotationStart).toCharArray());
                int token = scanner.getNextToken();
                boolean endFound = false;
                while (!endFound && token != 158 && token != 1001 && token != 1002 && token != 1003) {
                    if (token == 1000) {
                        whitespaceChars = scanner.getCurrentTokenSource();
                        wc = 0;
                        while (wc < whitespaceChars.length) {
                            if (whitespaceChars[wc] == '\r' || whitespaceChars[wc] == '\n') {
                                endFound = true;
                                break;
                            }
                            ++wc;
                        }
                    }
                    if (endFound) continue;
                    token = scanner.getNextToken();
                }
                if (token == 1000) {
                    whitespaceChars = scanner.getCurrentTokenSource();
                    wc = 0;
                    while (wc < whitespaceChars.length) {
                        if (whitespaceChars[wc] == '\r' || whitespaceChars[wc] == '\n') {
                            endOfCommentLine = wc + scanner.getCurrentTokenStartPosition() + jveAnnotationStart - 1;
                            break block9;
                        }
                        ++wc;
                    }
                    break block9;
                }
                endOfCommentLine = scanner.getCurrentTokenStartPosition() + jveAnnotationStart - 1;
            }
            catch (InvalidInputException invalidInputException) {
                endOfCommentLine = -1;
            }
        }
        return endOfCommentLine;
    }

    public static int getAnnotationEnd(String src, int start, IScannerFactory scannerFactory) {
        try {
            int endOfCommentLine = FreeFormAnnotationTemplate.getCommentLineEnd(src, start, scannerFactory);
            return endOfCommentLine;
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public static String getCurrentAnnotation(String src, IScannerFactory scannerFactory) {
        int start = FreeFormAnnotationTemplate.getAnnotationStart(src);
        if (start < 0) {
            return null;
        }
        int end = FreeFormAnnotationTemplate.getAnnotationEnd(src, start, scannerFactory);
        if (end < 0) {
            end = src.lastIndexOf(":");
        }
        if (end < 0) {
            return null;
        }
        return src.substring(start, end + 1);
    }

    public static String getAnnotationPrefix() {
        return ANNOTATION_PREFIX;
    }

    protected String determineContent() {
        String content = this.parseString;
        if (content != null && content.length() > 0 && this.positionString != null && this.positionString.length() > 0) {
            content = String.valueOf(content) + ",";
        }
        content = String.valueOf(content) + this.positionString;
        return content;
    }
}

