/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.internal.instantiation.PTArrayAccess;
import org.eclipse.jem.internal.instantiation.PTArrayCreation;
import org.eclipse.jem.internal.instantiation.PTArrayInitializer;
import org.eclipse.jem.internal.instantiation.PTBooleanLiteral;
import org.eclipse.jem.internal.instantiation.PTCastExpression;
import org.eclipse.jem.internal.instantiation.PTCharacterLiteral;
import org.eclipse.jem.internal.instantiation.PTClassInstanceCreation;
import org.eclipse.jem.internal.instantiation.PTConditionalExpression;
import org.eclipse.jem.internal.instantiation.PTExpression;
import org.eclipse.jem.internal.instantiation.PTFieldAccess;
import org.eclipse.jem.internal.instantiation.PTInfixExpression;
import org.eclipse.jem.internal.instantiation.PTInfixOperator;
import org.eclipse.jem.internal.instantiation.PTInstanceReference;
import org.eclipse.jem.internal.instantiation.PTInstanceof;
import org.eclipse.jem.internal.instantiation.PTInvalidExpression;
import org.eclipse.jem.internal.instantiation.PTMethodInvocation;
import org.eclipse.jem.internal.instantiation.PTName;
import org.eclipse.jem.internal.instantiation.PTNullLiteral;
import org.eclipse.jem.internal.instantiation.PTNumberLiteral;
import org.eclipse.jem.internal.instantiation.PTParenthesizedExpression;
import org.eclipse.jem.internal.instantiation.PTPrefixExpression;
import org.eclipse.jem.internal.instantiation.PTPrefixOperator;
import org.eclipse.jem.internal.instantiation.PTStringLiteral;
import org.eclipse.jem.internal.instantiation.PTThisLiteral;
import org.eclipse.jem.internal.instantiation.PTTypeLiteral;
import org.eclipse.jem.internal.instantiation.ParseVisitor;

public class PTExpressionComparator
extends ParseVisitor {
    private boolean equal = true;
    protected Stack otherPTExpressionStack = new Stack();

    public PTExpressionComparator(PTExpression otherExpression) {
        this.otherPTExpressionStack.push(otherExpression);
    }

    public boolean isEqual() {
        return this.equal;
    }

    protected void notEqual() throws ParseVisitor.StopVisiting {
        this.equal = false;
        throw new ParseVisitor.StopVisiting();
    }

    protected void pushInReverse(List list) {
        if (list != null) {
            int i = list.size() - 1;
            while (i >= 0) {
                this.otherPTExpressionStack.push(list.get(i));
                --i;
            }
        }
    }

    protected void push(Object object) {
        this.otherPTExpressionStack.push(object);
    }

    protected Object pop() {
        return this.otherPTExpressionStack.pop();
    }

    public boolean visit(PTArrayAccess node) {
        Object ast = this.pop();
        if (ast instanceof PTArrayAccess) {
            PTArrayAccess otherArrayAccess = (PTArrayAccess)ast;
            EList otherIndexes = otherArrayAccess.getIndexes();
            EList nodeIndexes = node.getIndexes();
            if (otherIndexes == null && nodeIndexes == null) {
                this.push(otherArrayAccess.getArray());
                return super.visit(node);
            }
            if (otherIndexes != null && nodeIndexes != null && otherIndexes.size() == nodeIndexes.size()) {
                this.pushInReverse((List)otherIndexes);
                this.push(otherArrayAccess.getArray());
                return super.visit(node);
            }
        }
        this.notEqual();
        return false;
    }

    public boolean visit(PTArrayCreation node) {
        Object ast = this.pop();
        if (ast instanceof PTArrayCreation) {
            PTArrayCreation otherArrayCreation = (PTArrayCreation)ast;
            if (node.getType().equals(otherArrayCreation.getType())) {
                this.push(otherArrayCreation.getInitializer());
                EList otherArrayDimentions = otherArrayCreation.getDimensions();
                EList nodeDimensions = node.getDimensions();
                if (otherArrayDimentions == null && nodeDimensions == null) {
                    return super.visit(node);
                }
                if (otherArrayDimentions != null && nodeDimensions != null && otherArrayDimentions.size() == nodeDimensions.size()) {
                    this.pushInReverse((List)otherArrayDimentions);
                    return super.visit(node);
                }
            }
        }
        this.notEqual();
        return false;
    }

    public boolean visit(PTArrayInitializer node) {
        Object ast = this.pop();
        if (ast instanceof PTArrayInitializer) {
            PTArrayInitializer otherArrayInitializer = (PTArrayInitializer)ast;
            EList otherExpressions = otherArrayInitializer.getExpressions();
            EList nodeExpressions = node.getExpressions();
            if (otherExpressions == null && nodeExpressions == null) {
                return super.visit(node);
            }
            if (otherExpressions != null && nodeExpressions != null && otherExpressions.size() == nodeExpressions.size()) {
                this.pushInReverse((List)otherExpressions);
                return super.visit(node);
            }
        }
        this.notEqual();
        return false;
    }

    public boolean visit(PTBooleanLiteral node) {
        Object ast = this.pop();
        if (ast instanceof PTBooleanLiteral) {
            PTBooleanLiteral otherBooleanLiteral = (PTBooleanLiteral)ast;
            if (node.isBooleanValue() == otherBooleanLiteral.isBooleanValue()) {
                return super.visit(node);
            }
        }
        this.notEqual();
        return false;
    }

    public boolean visit(PTCastExpression node) {
        Object ast = this.pop();
        if (ast instanceof PTCastExpression) {
            PTCastExpression otherCastExpression = (PTCastExpression)ast;
            if (node.getType().equals(otherCastExpression.getType())) {
                this.push(otherCastExpression.getExpression());
                return super.visit(node);
            }
        }
        this.notEqual();
        return false;
    }

    public boolean visit(PTCharacterLiteral node) {
        Object ast = this.pop();
        if (ast instanceof PTCharacterLiteral) {
            PTCharacterLiteral otherCharacterLiteral = (PTCharacterLiteral)ast;
            if (node.getEscapedValue().equals(otherCharacterLiteral.getEscapedValue())) {
                return super.visit(node);
            }
        }
        this.notEqual();
        return false;
    }

    public boolean visit(PTClassInstanceCreation node) {
        Object otherAST = this.pop();
        if (otherAST instanceof PTClassInstanceCreation) {
            PTClassInstanceCreation otherClassInstanceCreation = (PTClassInstanceCreation)otherAST;
            if (node.getType().equals(otherClassInstanceCreation.getType())) {
                EList otherArguments = otherClassInstanceCreation.getArguments();
                EList nodeArguments = node.getArguments();
                if (nodeArguments == null && otherArguments == null) {
                    return super.visit(node);
                }
                if (nodeArguments != null && otherArguments != null && nodeArguments.size() == otherArguments.size()) {
                    this.pushInReverse((List)otherArguments);
                    return super.visit(node);
                }
            }
        }
        this.notEqual();
        return false;
    }

    public boolean visit(PTConditionalExpression node) {
        Object otherAST = this.pop();
        if (otherAST instanceof PTConditionalExpression) {
            PTConditionalExpression otherConditionalExpression = (PTConditionalExpression)otherAST;
            this.push(otherConditionalExpression.getFalse());
            this.push(otherConditionalExpression.getTrue());
            this.push(otherConditionalExpression.getCondition());
            return super.visit(node);
        }
        this.notEqual();
        return false;
    }

    public boolean visit(PTFieldAccess node) {
        Object otherAST = this.pop();
        if (otherAST instanceof PTFieldAccess) {
            PTFieldAccess otherFieldAccess = (PTFieldAccess)otherAST;
            if (node.getField().equals(otherFieldAccess.getField())) {
                this.push(otherFieldAccess.getReceiver());
                return super.visit(node);
            }
        }
        this.notEqual();
        return false;
    }

    public boolean visit(PTInfixExpression node) {
        Object otherAST = this.pop();
        if (otherAST instanceof PTInfixExpression) {
            String otherOperatorString;
            PTInfixExpression otherInfixExpression = (PTInfixExpression)otherAST;
            PTInfixOperator nodeOperator = node.getOperator();
            PTInfixOperator otherOperator = otherInfixExpression.getOperator();
            String nodeOperatorString = nodeOperator == null ? null : nodeOperator.getOperator();
            String string = otherOperatorString = otherOperator == null ? null : otherOperator.getOperator();
            if (nodeOperatorString != null && otherOperatorString != null && nodeOperatorString.equals(otherOperatorString)) {
                EList otherExtendedOperands = otherInfixExpression.getExtendedOperands();
                EList nodeExtendedOperands = node.getExtendedOperands();
                if (otherExtendedOperands == null && nodeExtendedOperands == null) {
                    this.push(otherInfixExpression.getLeftOperand());
                    this.push(otherInfixExpression.getRightOperand());
                    return super.visit(node);
                }
                if (otherExtendedOperands != null && nodeExtendedOperands != null && otherExtendedOperands.size() == nodeExtendedOperands.size()) {
                    this.pushInReverse((List)otherExtendedOperands);
                    this.push(otherInfixExpression.getLeftOperand());
                    this.push(otherInfixExpression.getRightOperand());
                    return super.visit(node);
                }
            }
        }
        this.notEqual();
        return false;
    }

    public boolean visit(PTInstanceof node) {
        Object otherAST = this.pop();
        if (otherAST instanceof PTInstanceof) {
            PTInstanceof otherInstanceof = (PTInstanceof)otherAST;
            if (node.getType().equals(otherInstanceof.getType())) {
                this.push(otherInstanceof.getOperand());
                return super.visit(node);
            }
        }
        this.notEqual();
        return false;
    }

    public boolean visit(PTInstanceReference node) {
        Object otherAST = this.pop();
        if (otherAST instanceof PTInstanceReference) {
            PTInstanceReference otherInstanceReference = (PTInstanceReference)otherAST;
            if (node.getObject() != null && otherInstanceReference.getObject() != null && node.getObject().equals(otherInstanceReference.getObject())) {
                return super.visit(node);
            }
        }
        this.notEqual();
        return false;
    }

    public boolean visit(PTInvalidExpression node) {
        Object otherAST = this.pop();
        if (otherAST instanceof PTInvalidExpression) {
            PTInvalidExpression otherInvalidExpression = (PTInvalidExpression)otherAST;
            if (node.getMessage().equals(otherInvalidExpression.getMessage())) {
                return super.visit(node);
            }
        }
        this.notEqual();
        return false;
    }

    public boolean visit(PTMethodInvocation node) {
        Object otherAST = this.pop();
        if (otherAST instanceof PTMethodInvocation) {
            PTMethodInvocation otherMethodInvocation = (PTMethodInvocation)otherAST;
            if (node.getName().equals(otherMethodInvocation.getName())) {
                EList otherArguments = otherMethodInvocation.getArguments();
                EList nodeArguments = node.getArguments();
                if (nodeArguments == null && otherArguments == null) {
                    this.push(otherMethodInvocation.getReceiver());
                    return super.visit(node);
                }
                if (nodeArguments != null && otherArguments != null && otherArguments.size() == nodeArguments.size()) {
                    this.pushInReverse((List)otherArguments);
                    this.push(otherMethodInvocation.getReceiver());
                    return super.visit(node);
                }
            }
        }
        this.notEqual();
        return false;
    }

    public boolean visit(PTName node) {
        Object otherAST = this.pop();
        if (otherAST instanceof PTName) {
            PTName otherName = (PTName)otherAST;
            if (node.getName().equals(otherName.getName())) {
                return super.visit(node);
            }
        }
        this.notEqual();
        return false;
    }

    public boolean visit(PTNullLiteral node) {
        Object otherAST = this.pop();
        if (otherAST instanceof PTNullLiteral) {
            return super.visit(node);
        }
        this.notEqual();
        return false;
    }

    public boolean visit(PTNumberLiteral node) {
        Object otherAST = this.pop();
        if (otherAST instanceof PTNumberLiteral) {
            PTNumberLiteral otherNumLiteral = (PTNumberLiteral)otherAST;
            if (node.getToken().equals(otherNumLiteral.getToken())) {
                return super.visit(node);
            }
        }
        this.notEqual();
        return false;
    }

    public boolean visit(PTParenthesizedExpression node) {
        Object otherAST = this.pop();
        if (otherAST instanceof PTParenthesizedExpression) {
            PTParenthesizedExpression otherParenthesizedExpression = (PTParenthesizedExpression)otherAST;
            this.push(otherParenthesizedExpression.getExpression());
            return super.visit(node);
        }
        this.notEqual();
        return false;
    }

    public boolean visit(PTPrefixExpression node) {
        Object otherAST = this.pop();
        if (otherAST instanceof PTPrefixExpression) {
            String otherOperatorString;
            PTPrefixExpression otherPrefixExpression = (PTPrefixExpression)otherAST;
            PTPrefixOperator nodeOperator = node.getOperator();
            PTPrefixOperator otherOperator = otherPrefixExpression.getOperator();
            String nodeOperatorString = nodeOperator == null ? null : nodeOperator.getOperator();
            String string = otherOperatorString = otherOperator == null ? null : otherOperator.getOperator();
            if (nodeOperatorString != null && otherOperatorString != null && nodeOperatorString.equals(otherOperatorString)) {
                this.push(otherPrefixExpression.getExpression());
                return super.visit(node);
            }
        }
        this.notEqual();
        return false;
    }

    public boolean visit(PTStringLiteral node) {
        Object otherAST = this.pop();
        if (otherAST instanceof PTStringLiteral) {
            PTStringLiteral otherStringLiteral = (PTStringLiteral)otherAST;
            if (node.getEscapedValue().equals(otherStringLiteral.getEscapedValue())) {
                return super.visit(node);
            }
        }
        this.notEqual();
        return false;
    }

    public boolean visit(PTThisLiteral node) {
        Object otherAST = this.pop();
        if (otherAST instanceof PTThisLiteral) {
            return super.visit(node);
        }
        this.notEqual();
        return false;
    }

    public boolean visit(PTTypeLiteral node) {
        Object otherAST = this.pop();
        if (otherAST instanceof PTTypeLiteral) {
            PTTypeLiteral otherTypeLiteral = (PTTypeLiteral)otherAST;
            if (node.getType().equals(otherTypeLiteral.getType())) {
                return super.visit(node);
            }
        }
        this.notEqual();
        return false;
    }

    private static class Stack {
        private List list = new ArrayList();

        Stack() {
        }

        public void push(Object o) {
            this.list.add(o);
        }

        public Object pop() {
            return this.list.remove(this.list.size() - 1);
        }
    }
}

