/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jem.internal.proxy.common.ICallbackRunnable;
import org.eclipse.ve.internal.java.codegen.util.Messages;

public abstract class ReverseParserJob
extends Job {
    public static String REVERSE_PARSE_JOB_NAME = Messages.ReverseParserJob_0;
    public static int DEFAULT_PRIORITY = 2;
    private Object family;
    protected ICallbackRunnable callback;

    public ReverseParserJob(IFile file) {
        this(file, REVERSE_PARSE_JOB_NAME);
    }

    public static Object getJobFamily(IFile file) {
        return file.isAccessible() ? (String.valueOf(REVERSE_PARSE_JOB_NAME) + ":" + file.getLocation().toString()).intern() : null;
    }

    public ReverseParserJob(IFile file, String name) {
        super(name);
        this.family = ReverseParserJob.getJobFamily(file);
        this.setPriority(50);
    }

    protected IStatus run(IProgressMonitor monitor) {
        Thread myThread = this.getThread();
        int prevPriority = myThread.getPriority();
        try {
            myThread.setPriority(DEFAULT_PRIORITY);
            IStatus iStatus = this.doRun(monitor);
            Object var4_5 = null;
            myThread.setPriority(prevPriority);
            return iStatus;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            myThread.setPriority(prevPriority);
            throw throwable;
        }
    }

    protected abstract IStatus doRun(IProgressMonitor var1);

    public boolean belongsTo(Object family) {
        return family == this.family;
    }

    public static Job[] getReverseParserJobs(IFile file) {
        Object family = ReverseParserJob.getJobFamily(file);
        return family != null ? Platform.getJobManager().find(ReverseParserJob.getJobFamily(file)) : new Job[]{};
    }

    public static void cancelJobs(IFile file) {
        Job[] jobs = ReverseParserJob.getReverseParserJobs(file);
        int i = 0;
        while (i < jobs.length) {
            jobs[i].cancel();
            ++i;
        }
    }

    public static void join(IFile file, IProgressMonitor monitor) throws OperationCanceledException, InterruptedException {
        Object family = ReverseParserJob.getJobFamily(file);
        if (family != null) {
            Platform.getJobManager().join(ReverseParserJob.getJobFamily(file), monitor);
        }
    }
}

