/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.wizards;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ve.internal.java.codegen.core.CodegenMessages;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.codegen.util.DefaultClassGenerator;
import org.eclipse.ve.internal.java.codegen.wizards.IVisualClassCreationSourceContributor;
import org.eclipse.ve.internal.java.codegen.wizards.IVisualClassCreationSourceGenerator;
import org.eclipse.ve.internal.java.codegen.wizards.NewVisualClassWizardPage;
import org.eclipse.ve.internal.java.codegen.wizards.VisualElementModel;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.vce.templates.TemplateObjectFactory;
import org.eclipse.ve.internal.java.vce.templates.TemplateUtil;
import org.eclipse.ve.internal.java.vce.templates.TemplatesException;

public class NewVisualClassCreationWizard
extends NewElementWizard
implements IExecutableExtension {
    private NewVisualClassWizardPage fPage;
    private String superClassName = null;
    private IVisualClassCreationSourceContributor contributor = null;
    private String contributorBundleName = null;
    public static final String VISUAL_CLASS_WIZARD_SELECTED_ELEMENT_KEY = "VISUAL_CLASS_WIZARD_SELECTED_ELEMENT_KEY";
    public static String NEWLINE = System.getProperty("line.separator");

    public NewVisualClassCreationWizard() {
        this.setDefaultPageImageDescriptor(JavaVEPlugin.getWizardTitleImageDescriptor());
        this.setDialogSettings(JavaVEPlugin.getPlugin().getDialogSettings());
        this.setWindowTitle(CodegenMessages.NewVisualClassCreationWizard_title);
    }

    protected void updateContributor(VisualElementModel elementModel) {
        IConfigurationElement celm;
        if (elementModel != null && elementModel.getConfigElement() != null && ((celm = elementModel.getConfigElement()).getAttribute("contributor") != null || celm.getChildren("contributor").length != 0)) {
            try {
                this.contributor = (IVisualClassCreationSourceContributor)celm.createExecutableExtension("contributor");
                if (this.contributor != null) {
                    this.contributorBundleName = elementModel.getContributorBundleName();
                }
            }
            catch (CoreException e) {
                JavaVEPlugin.log((Throwable)e, (Level)Level.FINEST);
            }
        }
    }

    private IVisualClassCreationSourceGenerator getGeneratorInstance(URL templateLocation) {
        List jdtClassPath = TemplateUtil.getPluginAndPreReqJarPath((String)JavaVEPlugin.getPlugin().getBundle().getSymbolicName());
        try {
            jdtClassPath.addAll(TemplateUtil.getPlatformJREPath());
        }
        catch (TemplatesException e) {
            JavaVEPlugin.log((Throwable)e, (Level)Level.FINE);
        }
        List contributorsPaths = TemplateUtil.getPluginAndPreReqJarPath((String)this.contributorBundleName);
        int i = 0;
        while (i < contributorsPaths.size()) {
            if (!jdtClassPath.contains(contributorsPaths.get(i))) {
                jdtClassPath.add(contributorsPaths.get(i));
            }
            ++i;
        }
        String[] jdtClassPaths = new String[jdtClassPath.size()];
        int i2 = 0;
        while (i2 < jdtClassPath.size()) {
            jdtClassPaths[i2] = (String)jdtClassPath.get(i2);
            ++i2;
        }
        String templatePath = null;
        try {
            templatePath = Platform.asLocalURL((URL)templateLocation).getPath();
            templatePath = templatePath.substring(0, templatePath.lastIndexOf(47));
        }
        catch (IOException e1) {
            JavaVEPlugin.log((Throwable)e1, (Level)Level.WARNING);
        }
        String[] templatePaths = new String[]{templatePath};
        try {
            return (IVisualClassCreationSourceGenerator)TemplateObjectFactory.getClassInstance((String[])jdtClassPaths, (String[])templatePaths, (String)templateLocation.getPath().substring(templateLocation.getPath().lastIndexOf(47) + 1), (ClassLoader)this.contributor.getClass().getClassLoader(), null, null);
        }
        catch (TemplatesException e) {
            JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
            return null;
        }
    }

    protected String removeWhiteSpaces(String input) {
        char[] chars = input.toCharArray();
        char[] noSpaces = new char[chars.length];
        int count = 0;
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (!Character.isWhitespace(c)) {
                noSpaces[count] = c;
                ++count;
            }
            ++i;
        }
        return new String(noSpaces, 0, count);
    }

    protected void merge(IMethod to, IMethod from, CodeFormatter formatter, IProgressMonitor monitor) {
        try {
            StringBuffer finalSource = new StringBuffer();
            String toCUSource = to.getCompilationUnit().getSource();
            String fromCUSource = from.getCompilationUnit().getSource();
            int toStart = to.getSourceRange().getOffset();
            int toEnd = to.getSourceRange().getOffset() + to.getSourceRange().getLength();
            toStart = toCUSource.lastIndexOf(10, toStart) + 1;
            toEnd = toCUSource.indexOf(10, toEnd);
            int fromStart = from.getSourceRange().getOffset();
            int fromEnd = from.getSourceRange().getOffset() + from.getSourceRange().getLength();
            fromStart = fromCUSource.lastIndexOf(10, fromStart) + 1;
            fromEnd = fromCUSource.indexOf(10, fromEnd);
            int fromNameOffset = from.getNameRange().getOffset();
            int toNameOffset = to.getNameRange().getOffset();
            int fromBodyStart = fromCUSource.indexOf(123, fromNameOffset) + 1;
            int fromBodyEnd = fromCUSource.lastIndexOf(125, fromEnd) - 1;
            int toBodyStart = toCUSource.indexOf(123, toNameOffset) + 1;
            int toBodyEnd = toCUSource.lastIndexOf(125, toEnd) - 1;
            StringTokenizer toNLs = new StringTokenizer(toCUSource.substring(toBodyStart, toBodyEnd), "\r\n", false);
            StringTokenizer fromNLs = new StringTokenizer(fromCUSource.substring(fromBodyStart, fromBodyEnd), "\r\n", false);
            ArrayList<String> toLines = new ArrayList<String>();
            ArrayList<String> fromLines = new ArrayList<String>();
            int bestToLineIndex = 0;
            while (toNLs.hasMoreTokens()) {
                String token = toNLs.nextToken();
                toLines.add(token);
                if (token.indexOf("return") > -1) break;
                ++bestToLineIndex;
            }
            while (fromNLs.hasMoreTokens()) {
                fromLines.add(fromNLs.nextToken());
            }
            int fc = 0;
            while (fc < fromLines.size()) {
                String fromLine = (String)fromLines.get(fc);
                String fromLineNoSpaces = this.removeWhiteSpaces(fromLine);
                boolean foundInToLines = false;
                boolean fromLineIsSuperConstructorCall = from.isConstructor() && fromLineNoSpaces.indexOf("super(") > -1;
                int tc = 0;
                while (tc < toLines.size()) {
                    boolean toLineIsSuperConstructorCall;
                    String toLine = (String)toLines.get(tc);
                    String toLineNoSpaces = this.removeWhiteSpaces(toLine);
                    boolean bl = toLineIsSuperConstructorCall = to.isConstructor() && toLineNoSpaces.indexOf("super(") > -1;
                    if (toLineNoSpaces.equals(fromLineNoSpaces) || toLineIsSuperConstructorCall && fromLineIsSuperConstructorCall) {
                        foundInToLines = true;
                        break;
                    }
                    ++tc;
                }
                if (!foundInToLines) {
                    toLines.add(bestToLineIndex, fromLine);
                    ++bestToLineIndex;
                }
                ++fc;
            }
            finalSource.append(String.valueOf(toCUSource.substring(toStart, toBodyStart)) + NEWLINE);
            int i = 0;
            while (i < toLines.size()) {
                finalSource.append(toLines.get(i) + NEWLINE);
                ++i;
            }
            finalSource.append(toCUSource.substring(toBodyEnd, toEnd));
            IType declaringType = to.getDeclaringType();
            IJavaElement sibling = null;
            int i2 = 0;
            while (i2 < declaringType.getChildren().length) {
                if (declaringType.getChildren()[i2].equals(to) && i2 < declaringType.getChildren().length - 1) {
                    sibling = declaringType.getChildren()[i2 + 1];
                    break;
                }
                ++i2;
            }
            to.delete(true, monitor);
            String source = finalSource.toString();
            declaringType.createMethod(String.valueOf(NEWLINE) + source + NEWLINE, sibling, true, monitor);
        }
        catch (JavaModelException e) {
            JavaVEPlugin.log((Throwable)e, (Level)Level.FINE);
        }
    }

    protected String getCompleteSource(ICompilationUnit cu, ISourceReference srcRef) {
        try {
            String cuSource = cu.getSource();
            int from = srcRef.getSourceRange().getOffset();
            int to = from + srcRef.getSourceRange().getLength();
            int fromNL = cuSource.lastIndexOf(10, from);
            int toNL = cuSource.indexOf(10, to);
            if (fromNL > -1 && fromNL < cuSource.length()) {
                from = fromNL + 1;
            }
            if (toNL > -1 && toNL < cuSource.length()) {
                to = toNL + 1;
            }
            return cuSource.substring(from, to);
        }
        catch (JavaModelException e) {
            JavaVEPlugin.log((Throwable)e, (Level)Level.FINE);
            return null;
        }
    }

    protected void merge(ICompilationUnit to, ICompilationUnit from, CodeFormatter formatter, IProgressMonitor monitor) {
        try {
            IImportDeclaration[] fromImports = from.getImports();
            int i = 0;
            while (fromImports != null && i < fromImports.length) {
                IImportContainer importContainer = to.getImportContainer();
                if (importContainer == null || !importContainer.exists() || !importContainer.hasChildren()) {
                    to.createImport(fromImports[i].getElementName(), null, monitor);
                } else {
                    IJavaElement[] javaElements = importContainer.getChildren();
                    to.createImport(fromImports[i].getElementName(), javaElements[0], monitor);
                }
                ++i;
            }
            IType toType = CodeGenUtil.getMainType(to);
            IType fromType = CodeGenUtil.getMainType(from);
            this.merge(toType, fromType, formatter, monitor);
        }
        catch (JavaModelException e) {
            JavaVEPlugin.log((Throwable)e, (Level)Level.FINE);
        }
    }

    protected void merge(IType toType, IType fromType, CodeFormatter formatter, IProgressMonitor monitor) throws JavaModelException {
        int i = 0;
        while (i < fromType.getChildren().length) {
            String source;
            IJavaElement child = fromType.getChildren()[i];
            if (child instanceof IField) {
                IField field = (IField)child;
                source = this.getCompleteSource(field.getCompilationUnit(), (ISourceReference)field);
                toType.createField(source, null, true, monitor);
            }
            if (child instanceof IMethod) {
                IMethod method = (IMethod)child;
                IMethod[] targetMethods = null;
                if (method.isConstructor()) {
                    ArrayList<IMethod> constructors = new ArrayList<IMethod>();
                    IMethod[] allMethods = toType.getMethods();
                    int mc = 0;
                    while (mc < allMethods.length) {
                        if (allMethods[mc].isConstructor()) {
                            constructors.add(allMethods[mc]);
                        }
                        ++mc;
                    }
                    targetMethods = new IMethod[constructors.size()];
                    constructors.toArray(targetMethods);
                } else {
                    targetMethods = toType.findMethods(method);
                }
                if (targetMethods != null && targetMethods.length > 0) {
                    int tmc = 0;
                    while (tmc < targetMethods.length) {
                        this.merge(targetMethods[tmc], method, formatter, monitor);
                        ++tmc;
                    }
                } else {
                    String source2 = this.getCompleteSource(method.getCompilationUnit(), (ISourceReference)method);
                    toType.createMethod(source2, null, true, monitor);
                }
            }
            if (child instanceof IType) {
                IType type = (IType)child;
                source = this.getCompleteSource(type.getCompilationUnit(), (ISourceReference)type);
                toType.createType(source, null, true, monitor);
            }
            ++i;
        }
    }

    protected void applyContributor(IType type1, String superClassName, IProgressMonitor monitor) {
        IVisualClassCreationSourceGenerator gen = this.getGeneratorInstance(this.contributor.getTemplateLocation());
        try {
            ICompilationUnit originalCU = type1.getCompilationUnit();
            HashMap argMatrix = this.fPage.getArgumentMatrix();
            if (argMatrix != null) {
                argMatrix.put("targetType", type1);
            }
            String src = gen.generateSource(CodeGenUtil.getMainType(originalCU).getElementName(), superClassName, argMatrix);
            ICompilationUnit workingCopy = originalCU.getWorkingCopy(null);
            workingCopy.getBuffer().setContents(src);
            workingCopy.reconcile(0, true, null, (IProgressMonitor)new NullProgressMonitor());
            CodeFormatter formatter = this.contributor.needsFormatting() ? ToolFactory.createCodeFormatter(null) : null;
            this.merge(originalCU, workingCopy, formatter, monitor);
            workingCopy.discardWorkingCopy();
            String content = originalCU.getSource();
            content = DefaultClassGenerator.format(content, 8, originalCU.getJavaProject().getOptions(true), System.getProperties().getProperty("line.separator"));
            originalCU.getBuffer().setContents(content);
            originalCU.getBuffer().save(monitor, true);
        }
        catch (JavaModelException e) {
            JavaVEPlugin.log((Throwable)e, (Level)Level.FINE);
        }
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (this.fPage.getSelectedElement() != null) {
            JavaVEPlugin.getPlugin().getPluginPreferences().setValue(VISUAL_CLASS_WIZARD_SELECTED_ELEMENT_KEY, this.getSelectedElementStringValue(this.fPage.getSelectedElement()));
        } else {
            JavaVEPlugin.getPlugin().getPluginPreferences().setValue(VISUAL_CLASS_WIZARD_SELECTED_ELEMENT_KEY, "");
        }
        monitor.beginTask("", 300);
        if (this.fPage.getSelectedElement() != null && (this.fPage.getSelectedElement().getContainer() != null || this.fPage.getSelectedElement().getPluginId() != null)) {
            this.verifyProjectClassPath(this.fPage.getSelectedElement(), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        } else {
            monitor.worked(100);
        }
        this.fPage.createType((IProgressMonitor)new SubProgressMonitor(monitor, 100));
        this.updateContributor(this.fPage.getSelectedElement());
        if (this.contributor != null) {
            this.applyContributor(this.fPage.getCreatedType(), this.fPage.getSuperClass(), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        } else {
            monitor.worked(100);
        }
        monitor.done();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void verifyProjectClassPath(VisualElementModel elementModel, IProgressMonitor monitor) {
        block5: {
            block4: {
                monitor.beginTask("", 100);
                try {
                    if (elementModel == null) {
                        Object var6_3 = null;
                        break block4;
                    }
                    String pluginId = elementModel.getPluginId();
                    String container = elementModel.getContainer();
                    IJavaProject project = this.fPage.getPackageFragment().getJavaProject();
                    NewVisualClassCreationWizard.updateProjectClassPath(pluginId, container, project, monitor);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var6_4 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return;
        }
        Object var6_5 = null;
        monitor.done();
    }

    public static void updateProjectClassPath(String pluginId, String container, IJavaProject project, IProgressMonitor monitor) {
        if (project != null) {
            try {
                if (!ProxyPlugin.isPDEProject((IJavaProject)project)) {
                    HashMap containers = new HashMap();
                    HashMap plugins = new HashMap();
                    ProxyPlugin.getPlugin().getIDsFound(project, containers, new HashMap(), plugins, new HashMap());
                    if ((container == null || containers.get(container) != Boolean.TRUE) && container != null && plugins.isEmpty()) {
                        IClasspathEntry[] cp = project.getRawClasspath();
                        IClasspathEntry[] newcp = new IClasspathEntry[cp.length + 1];
                        System.arraycopy(cp, 0, newcp, 0, cp.length);
                        newcp[cp.length] = JavaCore.newContainerEntry((IPath)new Path(container));
                        project.setRawClasspath(newcp, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    }
                }
            }
            catch (JavaModelException javaModelException) {
            }
            catch (CoreException coreException) {}
        }
    }

    public void addPages() {
        this.fPage = new NewVisualClassWizardPage();
        this.addPage((IWizardPage)this.fPage);
        this.fPage.init(this.getSelection());
        if (this.superClassName != null) {
            this.fPage.setSuperClass(this.superClassName);
        }
    }

    protected void openResource(IResource resource) {
        NewVisualClassCreationWizard.openResourceJVE(resource);
    }

    public static void openResourceJVE(final IResource resource) {
        IWorkbenchPage activePage;
        IWorkbenchWindow window;
        if (resource.getType() == 1 && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (activePage = window.getActivePage()) != null) {
            window.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        String editorID = "org.eclipse.ve.internal.java.codegen.editorpart.JavaVisualEditor";
                        activePage.openEditor((IEditorInput)new FileEditorInput((IFile)resource), editorID);
                        IDE.setDefaultEditor((IFile)((IFile)resource), (String)editorID);
                    }
                    catch (PartInitException e) {
                        JavaVEPlugin.log((Throwable)e);
                    }
                }
            });
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            this.superClassName = (String)data;
        }
    }

    public boolean performFinish() {
        boolean res = super.performFinish();
        if (res) {
            ICompilationUnit cu = this.fPage.getCreatedType().getCompilationUnit();
            if (cu.isWorkingCopy()) {
                cu = (ICompilationUnit)cu.getPrimaryElement();
            }
            if (cu != null) {
                IResource resource = cu.getResource();
                this.selectAndReveal(resource);
                this.openResource(resource);
            }
        }
        return res;
    }

    protected String getSelectedElementStringValue(VisualElementModel vem) {
        if (vem != null) {
            return String.valueOf(vem.getCategory()) + "-" + vem.getName() + "-" + this.fPage.getSuperClass();
        }
        return "";
    }

    public IJavaElement getCreatedElement() {
        return this.fPage.getCreatedType();
    }
}

