/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.wizards;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.ui.ISharedImages;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.java.codegen.wizards.CategoryModel;
import org.eclipse.ve.internal.java.codegen.wizards.CodegenWizardsMessages;
import org.eclipse.ve.internal.java.codegen.wizards.VisualElementModel;
import org.osgi.framework.Bundle;

public class StyleTreeLabelProvider
extends LabelProvider {
    private Map imageCache = new HashMap(11);

    public Image getImage(Object element) {
        if (element instanceof CategoryModel) {
            org.eclipse.ui.ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            return images.getImage("IMG_OBJ_FOLDER");
        }
        VisualElementModel visualElementModel = (VisualElementModel)element;
        String imagename = visualElementModel.getIconFile();
        String imageId = null;
        String bundlename = null;
        if (imagename == null) {
            ISharedImages uiImages = JavaUI.getSharedImages();
            return uiImages.getImage("org.eclipse.jdt.ui.class_obj.gif");
        }
        bundlename = visualElementModel.getContributorBundleName();
        imageId = String.valueOf(bundlename) + "/" + imagename;
        Image image = (Image)this.imageCache.get(imageId);
        if (image == null) {
            image = CDEPlugin.getImageFromBundle((Bundle)Platform.getBundle((String)bundlename), (String)imagename);
            this.imageCache.put(imageId, image);
        }
        return image;
    }

    public String getText(Object element) {
        if (element instanceof CategoryModel) {
            if (((CategoryModel)element).getName() == null) {
                return CodegenWizardsMessages.StyleTreeLabelProvider_StyleNameError_ERROR_;
            }
            return ((CategoryModel)element).getName();
        }
        if (element instanceof VisualElementModel) {
            if (((VisualElementModel)element).getName() == null) {
                return CodegenWizardsMessages.StyleTreeLabelProvider_ElementNameError_ERROR_;
            }
            return ((VisualElementModel)element).getName();
        }
        return null;
    }

    public void dispose() {
        Iterator i = this.imageCache.values().iterator();
        while (i.hasNext()) {
            ((Image)i.next()).dispose();
        }
    }
}

