/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.wizards;

import java.util.logging.Level;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ve.internal.java.codegen.wizards.CategoryModel;
import org.eclipse.ve.internal.java.codegen.wizards.IVisualClassCreationSourceContributor;
import org.eclipse.ve.internal.java.codegen.wizards.StatusInfo;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class VisualElementModel {
    public CategoryModel parent;
    private IConfigurationElement configElement;
    private IVisualClassCreationSourceContributor contributor;

    public IConfigurationElement getConfigElement() {
        return this.configElement;
    }

    public VisualElementModel(IConfigurationElement configElement) {
        this.configElement = configElement;
    }

    public String getName() {
        if (this.configElement != null) {
            return this.configElement.getAttribute("name");
        }
        return null;
    }

    public String getSuperClass() {
        if (this.configElement != null) {
            return this.configElement.getAttributeAsIs("type");
        }
        return null;
    }

    public String getCategory() {
        if (this.configElement != null) {
            return this.configElement.getAttributeAsIs("category");
        }
        return null;
    }

    public String getContainer() {
        if (this.configElement != null) {
            return this.configElement.getAttributeAsIs("container");
        }
        return null;
    }

    public String getPluginId() {
        if (this.configElement != null) {
            return this.configElement.getAttributeAsIs("pluginId");
        }
        return null;
    }

    public Object getParent() {
        return this.parent;
    }

    public String getIconFile() {
        if (this.configElement != null) {
            return this.configElement.getAttributeAsIs("icon");
        }
        return null;
    }

    public String getContributorBundleName() {
        if (this.configElement != null) {
            return this.configElement.getDeclaringExtension().getNamespace();
        }
        return null;
    }

    public String toString() {
        return "category: " + this.getCategory() + ", name: " + this.getName() + ", type: " + this.getSuperClass();
    }

    public IStatus getStatus(IResource resource) {
        IStatus result;
        if (resource == null || this.configElement.getAttribute("contributor") == null) {
            return StatusInfo.OK_STATUS;
        }
        if (this.contributor == null) {
            try {
                this.contributor = (IVisualClassCreationSourceContributor)this.configElement.createExecutableExtension("contributor");
            }
            catch (CoreException e) {
                JavaVEPlugin.log((Throwable)e, (Level)Level.FINEST);
                return StatusInfo.OK_STATUS;
            }
        }
        return (result = this.contributor.getStatus(resource)) == null ? StatusInfo.OK_STATUS : result;
    }
}

