/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ve.internal.cde.core.ContentPaneFigure;
import org.eclipse.ve.internal.cde.core.GridController;
import org.eclipse.ve.internal.cde.core.ZoomController;

public class GridFigure
extends Figure {
    protected static Color GridColor = ColorConstants.black;
    protected ZoomController zoomController;
    protected GridController gridController;
    protected FigureListener figListener = new FigureListener(){

        public void figureMoved(IFigure source) {
            Rectangle rect = source.getBounds().getCopy();
            GridFigure.this.primSetBounds(rect);
        }
    };
    private GridData gridData = new GridData();
    private Rectangle clipRect = new Rectangle();

    public GridFigure(GridController gridController) {
        this.gridController = gridController;
    }

    public GridFigure(GridController gridController, ZoomController zoomController) {
        this(gridController);
        this.zoomController = zoomController;
    }

    public void addNotify() {
        super.addNotify();
        this.getParent().addFigureListener(this.figListener);
        this.figListener.figureMoved(this.getParent());
    }

    public void removeNotify() {
        super.removeNotify();
        this.getParent().removeFigureListener(this.figListener);
    }

    public void setBounds(Rectangle rect) {
    }

    protected void primSetBounds(Rectangle rect) {
        super.setBounds(rect);
    }

    public void paintFigure(Graphics g) {
        this.getGridData(this.gridData);
        if (this.gridData.gridWidth >= 2.0 && this.gridData.gridHeight >= 2.0) {
            Color oldForeground = g.getForegroundColor();
            g.setForegroundColor(GridColor);
            g.getClip(this.clipRect);
            Rectangle[] childRectanglesArray = this.getChildRectangles();
            double highestX = Math.min(this.gridData.gridBorder.x + this.gridData.gridBorder.width, this.clipRect.x + this.clipRect.width);
            double highestY = Math.min(this.gridData.gridBorder.y + this.gridData.gridBorder.height, this.clipRect.y + this.clipRect.height);
            double startY = this.gridData.gridBorder.y;
            if (this.gridData.gridBorder.y < this.clipRect.y) {
                int gridNum = (int)Math.round((double)(this.clipRect.y - this.gridData.gridBorder.y) / this.gridData.gridHeight);
                startY = (double)this.gridData.gridBorder.y + (double)gridNum * this.gridData.gridHeight;
            }
            double startX = this.gridData.gridBorder.x;
            if (this.gridData.gridBorder.x < this.clipRect.x) {
                int gridNum = (int)Math.round((double)(this.clipRect.x - this.gridData.gridBorder.x) / this.gridData.gridWidth);
                startX = (double)this.gridData.gridBorder.x + (double)gridNum * this.gridData.gridWidth;
            }
            double j = startY;
            while (j <= highestY) {
                int y = (int)Math.round(j);
                double i = startX;
                while (i <= highestX) {
                    block7: {
                        int x = (int)Math.round(i);
                        int n = 0;
                        while (n < childRectanglesArray.length) {
                            if (!childRectanglesArray[n].contains(x, y)) {
                                ++n;
                                continue;
                            }
                            break block7;
                        }
                        g.drawPoint(x, y);
                    }
                    i += this.gridData.gridWidth;
                }
                j += this.gridData.gridHeight;
            }
            g.setForegroundColor(oldForeground);
        }
    }

    protected Rectangle[] getChildRectangles() {
        ArrayList<Rectangle> childRectangles = new ArrayList<Rectangle>(10);
        IFigure parent = this.getParent();
        Iterator siblings = null;
        siblings = parent instanceof ContentPaneFigure ? ((ContentPaneFigure)parent).getContentPane().getChildren().iterator() : parent.getChildren().iterator();
        while (siblings.hasNext()) {
            Figure sibling = (Figure)siblings.next();
            if (sibling == this || !sibling.isVisible()) continue;
            childRectangles.add(sibling.getBounds());
        }
        Rectangle[] childRectanglesArray = new Rectangle[childRectangles.size()];
        childRectanglesArray = childRectangles.toArray(childRectanglesArray);
        return childRectanglesArray;
    }

    public void getGridData(GridData gd) {
        gd.gridWidth = this.gridController.getGridWidth();
        gd.gridHeight = this.gridController.getGridHeight();
        gd.gridMargin = this.gridController.getGridMargin();
        if (this.zoomController != null) {
            gd.gridWidth = this.zoomController.zoomCoordinateReal(this.gridController.getGridWidth());
            gd.gridHeight = this.zoomController.zoomCoordinateReal(this.gridController.getGridHeight());
            gd.gridMargin = this.zoomController.zoomCoordinate(gd.gridMargin);
        }
        gd.gridBorder = this.getParent().getClientArea();
        gd.gridBorder.shrink(gd.gridMargin, gd.gridMargin);
        gd.gridController = this.gridController;
    }

    public boolean containsPoint(int x, int y) {
        return false;
    }

    public static class GridData {
        Rectangle gridBorder;
        double gridWidth;
        double gridHeight;
        int gridMargin;
        GridController gridController;
    }
}

