/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.beaninfo;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import org.eclipse.ve.internal.jfc.beaninfo.AbstractBorderPropertyPage;
import org.eclipse.ve.internal.jfc.beaninfo.VisualBeanInfoMessages;

public class BevelBorderPropertyPage
extends AbstractBorderPropertyPage
implements ItemListener {
    private static final long serialVersionUID = 8205118731737645116L;
    private boolean built = false;
    private JRadioButton raisedButton = null;
    private JRadioButton loweredButton = null;
    private ButtonGroup buttonGroup = null;
    private int bevelType = 0;

    public BevelBorderPropertyPage() {
        this.initialize();
    }

    public String getDisplayName() {
        if (this.getBevelType() == 1) {
            return VisualBeanInfoMessages.getString("BevelBorder.Lowered.DisplayName");
        }
        return VisualBeanInfoMessages.getString("BevelBorder.Raised.DisplayName");
    }

    public int getBevelType() {
        return this.bevelType;
    }

    public JRadioButton getRaisedButton() {
        if (this.raisedButton == null) {
            try {
                this.raisedButton = new JRadioButton(VisualBeanInfoMessages.getString("BevelBorder.radio.Raised.Text"));
                this.raisedButton.setBackground(SystemColor.control);
                this.raisedButton.setName("Raised Bevel");
                this.raisedButton.addItemListener(this);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return this.raisedButton;
    }

    public JRadioButton getLoweredButton() {
        if (this.loweredButton == null) {
            try {
                this.loweredButton = new JRadioButton(VisualBeanInfoMessages.getString("BevelBorder.radio.Lowered.Text"));
                this.loweredButton.setBackground(SystemColor.control);
                this.loweredButton.setName("Lowered Bevel");
                this.loweredButton.addItemListener(this);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return this.loweredButton;
    }

    public ButtonGroup getButtonGroup() {
        if (this.buttonGroup == null) {
            try {
                this.buttonGroup = new ButtonGroup();
                this.buttonGroup.add(this.getRaisedButton());
                this.buttonGroup.add(this.getLoweredButton());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return this.buttonGroup;
    }

    public void initialize() {
        this.setName("BevelBorderPropertyPage");
    }

    public void buildPropertyPage() {
        if (!this.built) {
            this.setBackground(SystemColor.control);
            this.setLayout(new GridLayout(8, 1, 0, 0));
            this.getButtonGroup();
            this.add((Component)this.getRaisedButton(), this.getRaisedButton().getName());
            this.add((Component)this.getLoweredButton(), this.getLoweredButton().getName());
            if (this.getBevelType() == 0) {
                this.getRaisedButton().setSelected(true);
            } else if (this.getBevelType() == 1) {
                this.getLoweredButton().setSelected(true);
            }
            this.built = true;
        }
    }

    public Border getBorderValue() {
        Border aBorder = BorderFactory.createBevelBorder(this.getBevelType());
        return aBorder;
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.getRaisedButton()) {
            this.bevelType = 0;
        } else if (e.getSource() == this.getLoweredButton()) {
            this.bevelType = 1;
        }
        this.firePropertyChange("borderValueChanged", null, this.getBorderValue());
    }

    public String getJavaInitializationString() {
        if (this.getBevelType() == 1) {
            return "javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.LOWERED)";
        }
        return "javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED)";
    }

    public boolean okToSetBorder(Border aBorder) {
        if (aBorder instanceof BevelBorder) {
            BevelBorder bevelBorder = (BevelBorder)aBorder;
            this.bevelType = bevelBorder.getBevelType();
            return true;
        }
        return false;
    }
}

