/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.beaninfo;

import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.ve.internal.jfc.beaninfo.AbstractBorderPropertyPage;
import org.eclipse.ve.internal.jfc.beaninfo.VisualBeanInfoMessages;

public class EmptyBorderPropertyPage
extends AbstractBorderPropertyPage
implements DocumentListener {
    private static final long serialVersionUID = -6584341079896760410L;
    private boolean built = false;
    private JLabel topLabel = new JLabel(VisualBeanInfoMessages.getString("Top"));
    private JTextField topField = new JTextField();
    private JLabel leftLabel = new JLabel(VisualBeanInfoMessages.getString("Left"));
    private JTextField leftField = new JTextField();
    private JLabel bottomLabel = new JLabel(VisualBeanInfoMessages.getString("Bottom"));
    private JTextField bottomField = new JTextField();
    private JLabel rightLabel = new JLabel(VisualBeanInfoMessages.getString("Right"));
    private JTextField rightField = new JTextField();

    public EmptyBorderPropertyPage() {
        this.initialize();
    }

    public String getName() {
        return "EmptyBorderPropertyPage";
    }

    public void initialize() {
        this.setName("EmptyBorderPropertyPage");
    }

    public void buildPropertyPage() {
        if (!this.built) {
            this.setBackground(SystemColor.control);
            this.setLayout(new GridLayout(16, 1, 0, 0));
            this.add(this.topLabel);
            this.add(this.topField);
            this.topField.getDocument().addDocumentListener(this);
            this.add(this.leftLabel);
            this.add(this.leftField);
            this.leftField.getDocument().addDocumentListener(this);
            this.add(this.bottomLabel);
            this.add(this.bottomField);
            this.bottomField.getDocument().addDocumentListener(this);
            this.add(this.rightLabel);
            this.add(this.rightField);
            this.rightField.getDocument().addDocumentListener(this);
            this.built = true;
        }
    }

    protected int getIntValue(String aString) {
        try {
            return Integer.parseInt(aString);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int getTop() {
        return this.getIntValue(this.topField.getText());
    }

    public int getLeft() {
        return this.getIntValue(this.leftField.getText());
    }

    public int getBottom() {
        return this.getIntValue(this.bottomField.getText());
    }

    public int getRight() {
        return this.getIntValue(this.rightField.getText());
    }

    public Border getBorderValue() {
        Border aBorder = BorderFactory.createEmptyBorder(this.getTop(), this.getLeft(), this.getBottom(), this.getRight());
        return aBorder;
    }

    public void updateHandle(DocumentEvent e) {
        if (e.getDocument() == this.topField.getDocument() || e.getDocument() == this.leftField.getDocument() || e.getDocument() == this.bottomField.getDocument() || e.getDocument() == this.rightField.getDocument()) {
            this.firePropertyChange("borderValueChanged", null, this.getBorderValue());
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.updateHandle(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.updateHandle(e);
    }

    public void changedUpdate(DocumentEvent e) {
        this.updateHandle(e);
    }

    public String getDisplayName() {
        return MessageFormat.format(VisualBeanInfoMessages.getString("EmptyBorder.Empty(top,left,bottom,right)"), new Integer(this.getTop()), new Integer(this.getLeft()), new Integer(this.getBottom()), new Integer(this.getRight()));
    }

    public String getJavaInitializationString() {
        return "javax.swing.BorderFactory.createEmptyBorder(" + this.getTop() + "," + this.getLeft() + "," + this.getBottom() + "," + this.getRight() + ")";
    }

    public boolean okToSetBorder(Border aBorder) {
        if (aBorder instanceof EmptyBorder && !(aBorder instanceof MatteBorder)) {
            Insets fInsets = ((EmptyBorder)aBorder).getBorderInsets();
            this.topField.setText(String.valueOf(fInsets.top));
            this.leftField.setText(String.valueOf(fInsets.left));
            this.bottomField.setText(String.valueOf(fInsets.bottom));
            this.rightField.setText(String.valueOf(fInsets.right));
            return true;
        }
        return false;
    }
}

