/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.beaninfo;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.SoftBevelBorder;
import org.eclipse.ve.internal.jfc.beaninfo.AbstractBorderPropertyPage;
import org.eclipse.ve.internal.jfc.beaninfo.VisualBeanInfoMessages;

public class SoftBevelBorderPropertyPage
extends AbstractBorderPropertyPage
implements ItemListener {
    private static final long serialVersionUID = 5503741737244735137L;
    private boolean built = false;
    private JRadioButton raisedButton = null;
    private JRadioButton loweredButton = null;
    private ButtonGroup buttonGroup = null;
    private int bevelType = 0;

    public SoftBevelBorderPropertyPage() {
        this.initialize();
    }

    public int getBevelType() {
        return this.bevelType;
    }

    public JRadioButton getRaisedButton() {
        if (this.raisedButton == null) {
            try {
                this.raisedButton = new JRadioButton(VisualBeanInfoMessages.getString("SoftBevelBorder.radio.Raised.Text"));
                this.raisedButton.setBackground(SystemColor.control);
                this.raisedButton.setName("Raised Bevel");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return this.raisedButton;
    }

    public JRadioButton getLoweredButton() {
        if (this.loweredButton == null) {
            try {
                this.loweredButton = new JRadioButton(VisualBeanInfoMessages.getString("SoftBevelBorder.radio.Lowered.Text"));
                this.loweredButton.setBackground(SystemColor.control);
                this.loweredButton.setName("Lowered Bevel");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return this.loweredButton;
    }

    public ButtonGroup getButtonGroup() {
        if (this.buttonGroup == null) {
            try {
                this.buttonGroup = new ButtonGroup();
                this.buttonGroup.add(this.getRaisedButton());
                this.buttonGroup.add(this.getLoweredButton());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return this.buttonGroup;
    }

    public void initialize() {
        this.setName("SoftBevelBorderPropertyPage");
    }

    public void buildPropertyPage() {
        if (!this.built) {
            this.setBackground(SystemColor.control);
            this.setLayout(new GridLayout(8, 1, 0, 0));
            this.getButtonGroup();
            this.add((Component)this.getRaisedButton(), this.getRaisedButton().getName());
            this.add((Component)this.getLoweredButton(), this.getLoweredButton().getName());
            this.getRaisedButton().addItemListener(this);
            this.getLoweredButton().addItemListener(this);
            if (this.getBevelType() == 0) {
                this.getRaisedButton().setSelected(true);
            } else if (this.getBevelType() == 1) {
                this.getLoweredButton().setSelected(true);
            }
            this.built = true;
        }
    }

    public Border getBorderValue() {
        SoftBevelBorder aBorder = new SoftBevelBorder(this.bevelType);
        return aBorder;
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.getRaisedButton()) {
            this.bevelType = 0;
        } else if (e.getSource() == this.getLoweredButton()) {
            this.bevelType = 1;
        }
        this.firePropertyChange("borderValueChanged", null, this.getBorderValue());
    }

    public boolean okToSetBorder(Border aBorder) {
        if (aBorder instanceof SoftBevelBorder) {
            this.bevelType = ((SoftBevelBorder)aBorder).getBevelType();
            return true;
        }
        return false;
    }

    public String getDisplayName() {
        if (this.getBevelType() == 1) {
            return VisualBeanInfoMessages.getString("SoftBevelBorder.Lowered.DisplayName");
        }
        return VisualBeanInfoMessages.getString("SoftBevelBorder.Raised.DisplayName");
    }

    public String getJavaInitializationString() {
        if (this.getBevelType() == 1) {
            return "new javax.swing.border.SoftBevelBorder(javax.swing.border.SoftBevelBorder.LOWERED)";
        }
        return "new javax.swing.border.SoftBevelBorder(javax.swing.border.SoftBevelBorder.RAISED)";
    }
}

