/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.propertysheet;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetEntryListener;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ve.internal.propertysheet.IDescriptorPropertySheetEntry;
import org.eclipse.ve.internal.propertysheet.IEToolsPropertyDescriptor;
import org.eclipse.ve.internal.propertysheet.INeedData;
import org.eclipse.ve.internal.propertysheet.ISourced;
import org.eclipse.ve.internal.propertysheet.IWrapperedValidator;
import org.eclipse.ve.internal.propertysheet.NoNullsValidator;
import org.eclipse.ve.internal.propertysheet.PSheetPlugin;
import org.eclipse.ve.internal.propertysheet.PropertysheetMessages;

public abstract class AbstractPropertySheetEntry
implements IDescriptorPropertySheetEntry {
    protected Object[] values = new Object[0];
    protected IPropertySource[] propertySources = new IPropertySource[0];
    protected boolean fIsExpandable = true;
    private Object editValue;
    protected boolean entryStale = true;
    protected IDescriptorPropertySheetEntry parent;
    private IPropertySourceProvider propertySourceProvider;
    protected IPropertyDescriptor[] fDescriptors;
    private CellEditor editor;
    private String errorText;
    protected IDescriptorPropertySheetEntry[] childEntries = null;
    private ListenerList listeners;
    protected boolean fShowNulls = false;
    protected boolean fShowSet = false;
    protected boolean fShowReadOnly = false;
    private boolean fValueIsSet = false;
    private List fCachedMergedDescriptors = null;
    private boolean fRefreshQueued = false;
    private Object fData;
    private ICellEditorListener cellEditorListener = new ICellEditorListener(){

        public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            if (!newValidState) {
                AbstractPropertySheetEntry.this.setErrorText(AbstractPropertySheetEntry.this.editor.getErrorMessage());
            } else {
                AbstractPropertySheetEntry.this.setErrorText(null);
            }
        }

        public void cancelEditor() {
            AbstractPropertySheetEntry.this.setErrorText(null);
        }

        public void applyEditorValue() {
            AbstractPropertySheetEntry.this.applyEditorValue();
        }
    };
    static /* synthetic */ Class class$0;

    public AbstractPropertySheetEntry(IDescriptorPropertySheetEntry parent, IPropertySourceProvider provider) {
        this.parent = parent;
        this.propertySourceProvider = provider;
    }

    public void setData(Object data) {
        this.fData = data;
    }

    public void markStale() {
        if (this.parent != null) {
            this.entryStale = true;
        }
        if (this.childEntries != null) {
            int i = 0;
            while (i < this.childEntries.length) {
                this.childEntries[i].markStale();
                ++i;
            }
        }
    }

    public Object getData() {
        if (this.fData == null) {
            return this.parent != null ? this.parent.getData() : null;
        }
        return this.fData;
    }

    public void addPropertySheetEntryListener(IPropertySheetEntryListener listener) {
        if (this.listeners == null) {
            this.listeners = new ListenerList(1);
        }
        this.listeners.add((Object)listener);
    }

    public final void applyEditorValue() {
        if (this.editor == null || !this.isEditorActivated()) {
            return;
        }
        if (!this.editor.isValueValid()) {
            this.setErrorText(this.editor.getErrorMessage());
            return;
        }
        this.setErrorText(null);
        Object newValue = this.editor.getValue();
        this.applyNewValue(newValue);
    }

    protected final void applyNewValue(Object newValue) {
        try {
            boolean changed = false;
            if (this.editValue == null) {
                if (newValue != null) {
                    changed = true;
                }
            } else if (!this.editValue.equals(newValue)) {
                changed = true;
            }
            if (changed) {
                this.fillValues(newValue, this.values);
                this.primApplyValues();
                this.refreshFromRoot();
            }
        }
        catch (RuntimeException e) {
            PSheetPlugin.getPlugin().getLog().log((IStatus)new Status(2, PSheetPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
        }
    }

    protected List computeMergedPropertyDescriptors() {
        if (this.values.length == 0) {
            return Collections.EMPTY_LIST;
        }
        Map[] propertyDescriptorMaps = new Map[this.values.length];
        IPropertySource[] sources = this.getPropertySources();
        int i = 0;
        while (i < sources.length) {
            IPropertySource source = sources[i];
            if (source == null) {
                return Collections.EMPTY_LIST;
            }
            propertyDescriptorMaps[i] = this.computePropertyDescriptorsFor(source);
            ++i;
        }
        HashMap<Object, Object> intersection = new HashMap<Object, Object>(propertyDescriptorMaps[0].size());
        Iterator v0Itr = propertyDescriptorMaps[0].values().iterator();
        IPropertyDescriptor[] work = new IPropertyDescriptor[this.values.length];
        block1: while (v0Itr.hasNext()) {
            IPropertyDescriptor v0desc;
            work[0] = v0desc = (IPropertyDescriptor)v0Itr.next();
            Object v0Id = v0desc.getId();
            int i2 = 1;
            while (i2 < propertyDescriptorMaps.length) {
                IPropertyDescriptor desc = (IPropertyDescriptor)propertyDescriptorMaps[i2].get(v0Id);
                if (desc == null || !v0desc.isCompatibleWith(desc)) continue block1;
                work[i2] = desc;
                ++i2;
            }
            intersection.put(v0Id, work.clone());
        }
        ArrayList descriptors = new ArrayList(intersection.values());
        Collections.sort(descriptors, new Comparator(){
            Collator coll = Collator.getInstance(Locale.getDefault());

            public int compare(Object a, Object b) {
                IPropertyDescriptor d1 = ((IPropertyDescriptor[])a)[0];
                String dname1 = d1.getDisplayName();
                IPropertyDescriptor d2 = ((IPropertyDescriptor[])b)[0];
                String dname2 = d2.getDisplayName();
                return this.coll.compare(dname1, dname2);
            }
        });
        return descriptors;
    }

    protected Map computePropertyDescriptorsFor(IPropertySource source) {
        IPropertyDescriptor[] descriptors = source.getPropertyDescriptors();
        HashMap<Object, IPropertyDescriptor> result = new HashMap<Object, IPropertyDescriptor>(descriptors.length * 2 + 1);
        int i = 0;
        while (i < descriptors.length) {
            result.put(descriptors[i].getId(), descriptors[i]);
            ++i;
        }
        return result;
    }

    protected abstract IDescriptorPropertySheetEntry createPropertySheetEntry(IPropertySourceProvider var1);

    protected IDescriptorPropertySheetEntry[] createChildEntries() {
        List descriptors = this.fCachedMergedDescriptors == null ? this.computeMergedPropertyDescriptors() : this.fCachedMergedDescriptors;
        this.fCachedMergedDescriptors = null;
        IDescriptorPropertySheetEntry[] entries = null;
        ArrayList<IDescriptorPropertySheetEntry> newChildren = new ArrayList<IDescriptorPropertySheetEntry>(descriptors.size());
        Iterator itr = descriptors.iterator();
        int i = 0;
        while (itr.hasNext()) {
            IEToolsPropertyDescriptor desc;
            IPropertyDescriptor[] ds = (IPropertyDescriptor[])itr.next();
            if (this.fShowReadOnly || !(ds[0] instanceof IEToolsPropertyDescriptor) || !(desc = (IEToolsPropertyDescriptor)ds[0]).isReadOnly()) {
                IDescriptorPropertySheetEntry entry = this.createPropertySheetEntry(this.propertySourceProvider);
                entry.setDescriptors(ds);
                entry.refreshValues();
                entry.setShowNulls(this.fShowNulls);
                entry.setShowSetValues(this.fShowSet);
                entry.setShowReadOnly(this.fShowReadOnly);
                newChildren.add(entry);
            }
            ++i;
        }
        entries = new IDescriptorPropertySheetEntry[newChildren.size()];
        entries = newChildren.toArray(entries);
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        AbstractPropertySheetEntry abstractPropertySheetEntry = this;
        synchronized (abstractPropertySheetEntry) {
            this.fRefreshQueued = false;
        }
        if (this.editor != null) {
            this.editor.dispose();
            this.editor = null;
        }
        if (this.childEntries != null) {
            int i = 0;
            while (i < this.childEntries.length) {
                this.childEntries[i].dispose();
                ++i;
            }
        }
        this.listeners = null;
    }

    protected void fireChildEntriesChanged() {
        if (this.listeners == null) {
            return;
        }
        Object[] array = this.listeners.getListeners();
        int i = 0;
        while (i < array.length) {
            IPropertySheetEntryListener listener = (IPropertySheetEntryListener)array[i];
            listener.childEntriesChanged((IPropertySheetEntry)this);
            ++i;
        }
    }

    private void fireErrorMessageChanged() {
        if (this.listeners == null) {
            return;
        }
        Object[] array = this.listeners.getListeners();
        int i = 0;
        while (i < array.length) {
            IPropertySheetEntryListener listener = (IPropertySheetEntryListener)array[i];
            listener.errorMessageChanged((IPropertySheetEntry)this);
            ++i;
        }
    }

    private void fireValueChanged() {
        if (this.listeners == null) {
            return;
        }
        Object[] array = this.listeners.getListeners();
        int i = 0;
        while (i < array.length) {
            IPropertySheetEntryListener listener = (IPropertySheetEntryListener)array[i];
            listener.valueChanged((IPropertySheetEntry)this);
            ++i;
        }
    }

    public String getCategory() {
        return !this.isStale() ? this.fDescriptors[0].getCategory() : null;
    }

    public IPropertySheetEntry[] getChildEntries() {
        if (this.childEntries == null) {
            this.childEntries = this.createChildEntries();
        }
        return this.childEntries;
    }

    public String getDescription() {
        return !this.isStale() ? this.fDescriptors[0].getDescription() : null;
    }

    public String getDisplayName() {
        if (this.entryStale) {
            return PropertysheetMessages.AbstractPropertySheetEntry_DisplayName_StaleEntry;
        }
        try {
            String name = this.fDescriptors[0].getDisplayName();
            if (this.fShowSet && this.fValueIsSet) {
                name = String.valueOf('>') + name;
            }
            return name;
        }
        catch (RuntimeException e) {
            PSheetPlugin.getPlugin().getLog().log((IStatus)new Status(2, PSheetPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
            return PropertysheetMessages.AbstractPropertySheetEntry_DisplayName_Error;
        }
    }

    public String getSortDisplayName() {
        if (this.entryStale) {
            return PropertysheetMessages.AbstractPropertySheetEntry_DisplayName_StaleEntry;
        }
        try {
            String name = this.fDescriptors[0].getDisplayName();
            return name;
        }
        catch (RuntimeException e) {
            PSheetPlugin.getPlugin().getLog().log((IStatus)new Status(2, PSheetPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
            return PropertysheetMessages.AbstractPropertySheetEntry_DisplayName_Error;
        }
    }

    public CellEditor getEditor(Composite parent) {
        if (this.editor == null) {
            this.editor = this.fDescriptors[0].createPropertyEditor(parent);
            this.processEditorValidator(this.editor);
            if (this.editor != null) {
                this.editor.addListener(this.cellEditorListener);
            }
        }
        this.setupEditor();
        return this.editor;
    }

    protected void processEditorValidator(CellEditor cellEditor) {
        if (cellEditor != null && this.areNullsInvalid()) {
            cellEditor.setValidator((ICellEditorValidator)new NoNullsValidator(cellEditor.getValidator()));
        }
    }

    public final boolean areNullsInvalid() {
        if (this.isStale()) {
            return false;
        }
        int i = 0;
        while (i < this.fDescriptors.length) {
            if (!(this.fDescriptors[i] instanceof IEToolsPropertyDescriptor) || ((IEToolsPropertyDescriptor)this.fDescriptors[i]).areNullsInvalid()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void setupEditor() {
        if (this.editor != null) {
            try {
                ICellEditorValidator validator = this.editor.getValidator();
                if (this.editor instanceof INeedData || this.anyNeedDataValidators(validator)) {
                    Object data = this.getData();
                    if (this.editor instanceof INeedData) {
                        ((INeedData)this.editor).setData(data);
                    }
                    this.applyDataToValidators(validator, data);
                }
                if (this.editor instanceof ISourced || this.anySourcedValidators(validator)) {
                    IPropertySource[] pos = this.parent.getPropertySources();
                    Object[] sources = new Object[pos.length];
                    int i = 0;
                    while (i < pos.length) {
                        sources[i] = pos[i].getEditableValue();
                        ++i;
                    }
                    if (this.editor instanceof ISourced) {
                        ((ISourced)this.editor).setSources(sources, pos, this.fDescriptors);
                    }
                    this.applySourcesToValidators(validator, sources, pos, this.fDescriptors);
                }
                this.editor.setValue(this.editValue);
                this.setErrorText(this.editor.getErrorMessage());
            }
            catch (Exception exception) {}
        }
    }

    private boolean anySourcedValidators(ICellEditorValidator validator) {
        ICellEditorValidator[] validators;
        if (validator instanceof ISourced) {
            return true;
        }
        if (validator instanceof IWrapperedValidator && (validators = ((IWrapperedValidator)validator).getValidators()) != null) {
            int i = 0;
            while (i < validators.length) {
                if (this.anySourcedValidators(validators[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean anyNeedDataValidators(ICellEditorValidator validator) {
        ICellEditorValidator[] validators;
        if (validator instanceof INeedData) {
            return true;
        }
        if (validator instanceof IWrapperedValidator && (validators = ((IWrapperedValidator)validator).getValidators()) != null) {
            int i = 0;
            while (i < validators.length) {
                if (this.anyNeedDataValidators(validators[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void applySourcesToValidators(ICellEditorValidator validator, Object[] sources, IPropertySource[] propertySources, IPropertyDescriptor[] descriptors) {
        ICellEditorValidator[] validators;
        if (validator instanceof ISourced) {
            ((ISourced)validator).setSources(sources, propertySources, descriptors);
        }
        if (validator instanceof IWrapperedValidator && (validators = ((IWrapperedValidator)validator).getValidators()) != null) {
            int i = 0;
            while (i < validators.length) {
                this.applySourcesToValidators(validators[i], sources, propertySources, descriptors);
                ++i;
            }
        }
    }

    private void applyDataToValidators(ICellEditorValidator validator, Object data) {
        ICellEditorValidator[] validators;
        if (validator instanceof INeedData) {
            ((INeedData)validator).setData(data);
        }
        if (validator instanceof IWrapperedValidator && (validators = ((IWrapperedValidator)validator).getValidators()) != null) {
            int i = 0;
            while (i < validators.length) {
                this.applyDataToValidators(validators[i], data);
                ++i;
            }
        }
    }

    public Object getEditValue() {
        return this.editValue;
    }

    protected Object getEditValue(int index) {
        Object value = this.values[index];
        IPropertySource[] sources = this.getPropertySources();
        if (sources[index] != null) {
            value = sources[index].getEditableValue();
        }
        return value;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public String[] getFilters() {
        return !this.isStale() ? this.fDescriptors[0].getFilterFlags() : null;
    }

    public Object getHelpContextIds() {
        return !this.isStale() ? this.fDescriptors[0].getHelpContextIds() : null;
    }

    public Object getId() {
        return this.fDescriptors[0].getId();
    }

    public Image getImage() {
        if (this.entryStale) {
            return null;
        }
        try {
            ILabelProvider provider = this.fDescriptors[0].getLabelProvider();
            if (provider == null) {
                return null;
            }
            if (provider instanceof INeedData) {
                ((INeedData)provider).setData(this.getData());
            }
            return provider.getImage(this.editValue);
        }
        catch (RuntimeException e) {
            PSheetPlugin.getPlugin().getLog().log((IStatus)new Status(2, PSheetPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
            return null;
        }
    }

    protected IPropertySource getPropertySource(Object object) {
        IPropertySource result = null;
        if (this.propertySourceProvider != null) {
            result = this.propertySourceProvider.getPropertySource(object);
        } else if (object instanceof IPropertySource) {
            result = (IPropertySource)object;
        } else if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            result = (IPropertySource)iAdaptable.getAdapter((Class)clazz);
        }
        return result;
    }

    public IPropertySource[] getPropertySources() {
        if (this.propertySources == null) {
            this.propertySources = new IPropertySource[this.values.length];
            int i = 0;
            while (i < this.values.length) {
                this.propertySources[i] = this.getPropertySource(this.values[i]);
                ++i;
            }
        }
        return this.propertySources;
    }

    public Object[] getValues() {
        return this.values;
    }

    public String getValueAsString() {
        if (this.entryStale) {
            return PropertysheetMessages.AbstractPropertySheetEntry_ValueAsString_StaleEntry;
        }
        try {
            if (this.editValue == null) {
                return this.fShowNulls ? PropertysheetMessages.display_null : "";
            }
            ILabelProvider provider = this.fDescriptors[0].getLabelProvider();
            if (provider == null) {
                return this.editValue.toString();
            }
            if (provider instanceof INeedData) {
                ((INeedData)provider).setData(this.getData());
            }
            if (provider instanceof ISourced) {
                IPropertySource[] pos = this.parent.getPropertySources();
                Object[] sources = new Object[pos.length];
                int i = 0;
                while (i < pos.length) {
                    sources[i] = pos[i].getEditableValue();
                    ++i;
                }
                ((ISourced)provider).setSources(sources, pos, this.fDescriptors);
            }
            return provider.getText(this.editValue);
        }
        catch (RuntimeException e) {
            PSheetPlugin.getPlugin().getLog().log((IStatus)new Status(2, PSheetPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
            return PropertysheetMessages.AbstractPropertySheetEntry_ValueAsString_Error;
        }
    }

    public boolean hasChildEntries() {
        if (this.childEntries != null && this.childEntries.length > 0) {
            return true;
        }
        if (this.fIsExpandable) {
            this.fCachedMergedDescriptors = this.computeMergedPropertyDescriptors();
            int numberOfChilden = this.fCachedMergedDescriptors.size();
            if (!this.fShowReadOnly && this.fCachedMergedDescriptors.size() > 0) {
                int i = 0;
                while (i < this.fCachedMergedDescriptors.size()) {
                    IEToolsPropertyDescriptor desc;
                    IPropertyDescriptor[] ds = (IPropertyDescriptor[])this.fCachedMergedDescriptors.get(i);
                    if (ds[0] instanceof IEToolsPropertyDescriptor && (desc = (IEToolsPropertyDescriptor)ds[0]).isReadOnly()) {
                        --numberOfChilden;
                    }
                    ++i;
                }
            }
            return numberOfChilden > 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshChildEntries() {
        AbstractPropertySheetEntry abstractPropertySheetEntry = this;
        synchronized (abstractPropertySheetEntry) {
            this.fRefreshQueued = false;
        }
        if (this.childEntries == null) {
            return;
        }
        List descriptors = this.fCachedMergedDescriptors == null ? this.computeMergedPropertyDescriptors() : this.fCachedMergedDescriptors;
        this.fCachedMergedDescriptors = null;
        ArrayList<IDescriptorPropertySheetEntry> newChildren = new ArrayList<IDescriptorPropertySheetEntry>(descriptors.size());
        ArrayList<IDescriptorPropertySheetEntry> entriesToDispose = new ArrayList<IDescriptorPropertySheetEntry>(2);
        boolean entriesAdded = false;
        int nextEntry = 0;
        int i = 0;
        while (i < descriptors.size()) {
            IEToolsPropertyDescriptor desc;
            IPropertyDescriptor[] ds = (IPropertyDescriptor[])descriptors.get(i);
            if (this.fShowReadOnly || !(ds[0] instanceof IEToolsPropertyDescriptor) || !(desc = (IEToolsPropertyDescriptor)ds[0]).isReadOnly()) {
                boolean oldHasImage = false;
                IDescriptorPropertySheetEntry entry = null;
                if (nextEntry < this.childEntries.length) {
                    oldHasImage = (entry = this.childEntries[nextEntry++]).getImage() != null;
                } else {
                    entry = this.createPropertySheetEntry(this.propertySourceProvider);
                    entry.setShowNulls(this.fShowNulls);
                    entry.setShowSetValues(this.fShowSet);
                    entry.setShowReadOnly(this.fShowReadOnly);
                    entriesAdded = true;
                }
                entry.setDescriptors(ds);
                entry.refreshValues();
                if (oldHasImage && entry.getImage() == null) {
                    entriesToDispose.add(entry);
                    entry = this.createPropertySheetEntry(this.propertySourceProvider);
                    entry.setShowNulls(this.fShowNulls);
                    entry.setShowSetValues(this.fShowSet);
                    entry.setShowReadOnly(this.fShowReadOnly);
                    entriesAdded = true;
                    entry.setDescriptors(ds);
                    entry.refreshValues();
                }
                newChildren.add(entry);
            }
            ++i;
        }
        IDescriptorPropertySheetEntry[] oldEntries = this.childEntries;
        this.childEntries = new IDescriptorPropertySheetEntry[newChildren.size()];
        this.childEntries = newChildren.toArray(this.childEntries);
        if (entriesAdded || !entriesToDispose.isEmpty() || this.childEntries.length != oldEntries.length) {
            this.fireChildEntriesChanged();
        }
        int i2 = newChildren.size();
        while (i2 < oldEntries.length) {
            oldEntries[i2].dispose();
            ++i2;
        }
        i2 = 0;
        while (i2 < entriesToDispose.size()) {
            ((IDescriptorPropertySheetEntry)entriesToDispose.get(i2)).dispose();
            ++i2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshFromRoot() {
        if (this.parent == null) {
            AbstractPropertySheetEntry abstractPropertySheetEntry = this;
            synchronized (abstractPropertySheetEntry) {
                this.fRefreshQueued = true;
                this.markStale();
            }
            Display d = Display.getCurrent();
            if (d == null) {
                d = Display.getDefault();
            }
            d.asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    boolean refresh;
                    AbstractPropertySheetEntry abstractPropertySheetEntry = AbstractPropertySheetEntry.this;
                    synchronized (abstractPropertySheetEntry) {
                        refresh = AbstractPropertySheetEntry.this.fRefreshQueued;
                        AbstractPropertySheetEntry.this.fRefreshQueued = false;
                    }
                    if (refresh) {
                        AbstractPropertySheetEntry.this.refreshChildEntries();
                    }
                }
            });
        } else {
            this.parent.refreshFromRoot();
        }
    }

    public final void refreshValues() {
        this.setValues(this.primGetValues());
    }

    protected abstract Object[] primGetValues();

    public void removePropertySheetEntryListener(IPropertySheetEntryListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove((Object)listener);
    }

    public final void resetPropertyValue() {
        if (this.parent == null) {
            return;
        }
        if (this.primResetPropertyValues()) {
            this.refreshFromRoot();
        }
    }

    protected abstract boolean primResetPropertyValues();

    protected abstract boolean isPropertySet();

    public void setDescriptors(IPropertyDescriptor[] newDescriptors) {
        if (this.editor != null && !Arrays.equals(this.fDescriptors, newDescriptors)) {
            this.editor.dispose();
            this.editor = null;
        }
        this.fDescriptors = newDescriptors;
        this.fIsExpandable = !(this.fDescriptors[0] instanceof IEToolsPropertyDescriptor) || ((IEToolsPropertyDescriptor)this.fDescriptors[0]).isExpandable();
    }

    private void setErrorText(String newErrorText) {
        this.errorText = newErrorText;
        this.fireErrorMessageChanged();
    }

    public void setPropertySourceProvider(IPropertySourceProvider provider) {
        this.propertySourceProvider = provider;
    }

    protected final void fillValues(Object newEditValue, Object[] valuesArray) {
        this.primFillValues(newEditValue, valuesArray);
        this.propertySources = null;
    }

    protected abstract void primFillValues(Object var1, Object[] var2);

    protected abstract void primApplyValues();

    public void setValues(Object[] objects) {
        this.values = objects;
        this.propertySources = null;
        this.fCachedMergedDescriptors = null;
        this.entryStale = false;
        if (this.values.length == 0) {
            this.editValue = null;
            this.fValueIsSet = false;
        } else {
            Object newValue = this.values[this.values.length - 1];
            IPropertySource source = this.getPropertySource(newValue);
            if (source != null) {
                newValue = source.getEditableValue();
            }
            this.editValue = newValue;
            this.fValueIsSet = this.isPropertySet();
        }
        if (this.isEditorActivated()) {
            this.setupEditor();
        }
        this.refreshChildEntries();
        this.fireValueChanged();
    }

    public void setToNull() {
        if (this.editValue == null && !this.isPropertySet()) {
            this.editValue = Void.TYPE;
            this.applyNewValue(null);
            if (this.editValue == Void.TYPE) {
                this.editValue = null;
            }
        } else {
            this.applyNewValue(null);
        }
    }

    public void setShowNulls(boolean showNulls) {
        this.fShowNulls = showNulls;
        if (this.childEntries != null) {
            int i = 0;
            while (i < this.childEntries.length) {
                this.childEntries[i].setShowNulls(showNulls);
                ++i;
            }
        }
    }

    public void setShowReadOnly(boolean showReadOnly) {
        this.fShowReadOnly = showReadOnly;
        if (this.childEntries != null) {
            int i = 0;
            while (i < this.childEntries.length) {
                this.childEntries[i].setShowReadOnly(showReadOnly);
                ++i;
            }
        }
    }

    public void setShowSetValues(boolean showSet) {
        this.fShowSet = showSet;
        if (this.childEntries != null) {
            int i = 0;
            while (i < this.childEntries.length) {
                this.childEntries[i].setShowSetValues(showSet);
                ++i;
            }
        }
    }

    public final boolean isEditorActivated() {
        return this.editor != null && this.editor.isActivated();
    }

    public boolean isStale() {
        return this.entryStale;
    }

    public IDescriptorPropertySheetEntry getParent() {
        return this.parent;
    }
}

