/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.propertysheet.command;

import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ve.internal.propertysheet.common.commands.AbstractCommand;

public class RestoreDefaultPropertyValueCommand
extends AbstractCommand {
    protected Object propertyId;
    protected Object undoValue;
    protected boolean setOnUndo;
    protected IPropertySource target;

    public RestoreDefaultPropertyValueCommand() {
    }

    public RestoreDefaultPropertyValueCommand(String label) {
        super(label);
    }

    public boolean canExecute() {
        return true;
    }

    public void execute() {
        this.setOnUndo = this.getTarget().isPropertySet(this.propertyId);
        if (this.setOnUndo) {
            this.undoValue = this.getTarget().getPropertyValue(this.propertyId);
            if (this.undoValue instanceof IPropertySource) {
                this.undoValue = ((IPropertySource)this.undoValue).getEditableValue();
            }
            this.getTarget().resetPropertyValue(this.propertyId);
        } else {
            this.undoValue = null;
        }
    }

    public IPropertySource getTarget() {
        return this.target;
    }

    public void setTarget(IPropertySource aTarget) {
        this.target = aTarget;
    }

    public void redo() {
        this.execute();
    }

    public void setPropertyId(Object pId) {
        this.propertyId = pId;
    }

    public void undo() {
        if (this.setOnUndo) {
            this.getTarget().setPropertyValue(this.propertyId, this.undoValue);
        } else {
            this.getTarget().resetPropertyValue(this.propertyId);
        }
    }
}

