/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jface.codegen.wizards.contributors;

import java.net.URL;
import java.text.MessageFormat;
import java.util.logging.Level;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.ve.internal.java.codegen.wizards.IVisualClassCreationSourceContributor;
import org.eclipse.ve.internal.java.codegen.wizards.StatusInfo;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.jface.JFaceMessages;

public abstract class AbstractRCPClassCreationSourceContributor
implements IVisualClassCreationSourceContributor {
    public boolean needsFormatting() {
        return true;
    }

    public abstract URL getTemplateLocation();

    public IStatus getStatus(IResource resource) {
        IProject project = resource.getProject();
        boolean isError = false;
        if (project == null) {
            isError = true;
        } else {
            try {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                isError = !javaProject.exists() ? true : !ProxyPlugin.isPDEProject((IJavaProject)javaProject);
            }
            catch (CoreException e) {
                JavaVEPlugin.log((Throwable)e, (Level)Level.FINEST);
                return new StatusInfo(4, e.getMessage(), "org.eclipse.ve.swt");
            }
        }
        if (isError) {
            return new StatusInfo(4, MessageFormat.format(JFaceMessages.RCPViewCreation_RCP_Project_ERROR_, project == null ? null : project.getName()), "org.eclipse.ve.swt");
        }
        return StatusInfo.OK_STATUS;
    }
}

