/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.choosebean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jem.internal.beaninfo.core.Utilities;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ve.internal.cde.core.AnnotationLinkagePolicy;
import org.eclipse.ve.internal.cde.core.AnnotationPolicy;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.decorators.ClassDescriptorDecorator;
import org.eclipse.ve.internal.cde.emf.ClassDecoratorFeatureAccess;
import org.eclipse.ve.internal.cdm.Annotation;
import org.eclipse.ve.internal.cdm.DiagramData;
import org.eclipse.ve.internal.java.choosebean.ChooseBeanMessages;
import org.eclipse.ve.internal.java.choosebean.IChooseBeanContributor;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.rules.IBeanNameProposalRule;

public class ChooseBeanDialogUtilities {
    public static final String PI_CONTAINER = "container";
    public static final String PI_PLUGIN = "plugin";
    public static final IChooseBeanContributor[] NO_CONTRIBS = new IChooseBeanContributor[0];
    private static HashMap contributorNameImageMap = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static IChooseBeanContributor[] determineContributors(IJavaProject project) {
        HashMap containerIDs = new HashMap();
        HashMap pluginsIDs = new HashMap();
        try {
            ProxyPlugin.getPlugin().getIDsFound(project, containerIDs, new HashMap(), pluginsIDs, new HashMap());
            ArrayList<IChooseBeanContributor> contributorList = new ArrayList<IChooseBeanContributor>();
            IExtensionPoint exp = Platform.getExtensionRegistry().getExtensionPoint(JavaVEPlugin.getPlugin().getBundle().getSymbolicName(), "choosebean");
            IExtension[] extensions = exp.getExtensions();
            if (extensions.length > 0) {
                IExtension[] orderedExtensions = new IExtension[extensions.length];
                int index = 0;
                String veBaseBundleName = JavaVEPlugin.getPlugin().getBundle().getSymbolicName();
                int i = 0;
                while (i < extensions.length) {
                    if (extensions[i].getNamespace().equals(veBaseBundleName)) {
                        orderedExtensions[index++] = extensions[i];
                    }
                    ++i;
                }
                i = 0;
                while (i < extensions.length) {
                    if (!extensions[i].getNamespace().equals(veBaseBundleName)) {
                        orderedExtensions[index++] = extensions[i];
                    }
                    ++i;
                }
                int ec = 0;
                while (ec < orderedExtensions.length) {
                    IConfigurationElement[] configElms = orderedExtensions[ec].getConfigurationElements();
                    int cc = 0;
                    while (cc < configElms.length) {
                        IConfigurationElement celm = configElms[cc];
                        if (containerIDs.get(celm.getAttributeAsIs(PI_CONTAINER)) == Boolean.TRUE || pluginsIDs.get(celm.getAttributeAsIs(PI_PLUGIN)) == Boolean.TRUE) {
                            try {
                                IChooseBeanContributor contributor = (IChooseBeanContributor)celm.createExecutableExtension("class");
                                contributorList.add(contributor);
                            }
                            catch (CoreException e) {
                                JavaVEPlugin.log(e, Level.FINE);
                            }
                            catch (ClassCastException e) {
                                JavaVEPlugin.log(e, Level.FINE);
                            }
                        }
                        ++cc;
                    }
                    ++ec;
                }
            }
            return !contributorList.isEmpty() ? contributorList.toArray(new IChooseBeanContributor[contributorList.size()]) : NO_CONTRIBS;
        }
        catch (JavaModelException e) {
            JavaVEPlugin.log(e, Level.FINE);
            return NO_CONTRIBS;
        }
    }

    public static Image getContributorImage(IChooseBeanContributor contrib) {
        Image image = null;
        if (contrib != null) {
            String contribName = contrib.getName();
            if (contribName == null) {
                contribName = contrib.getClass().getName();
            }
            if (contributorNameImageMap.containsKey(contribName)) {
                image = (Image)contributorNameImageMap.get(contribName);
            } else {
                image = contrib.getImage();
                contributorNameImageMap.put(contribName, image);
            }
        }
        return image;
    }

    public static IStatus getClassStatus(Object selected, String packageName, ResourceSet resourceSet, IJavaSearchScope javaSearchScope) {
        JavaModelException t = null;
        String message = new String();
        boolean isInstantiable = true;
        if (selected == null) {
            isInstantiable = false;
            message = ChooseBeanMessages.SelectionAreaHelper_SecondaryMsg_NoSelectionMade;
        } else {
            try {
                boolean constructorError;
                TypeInfo ti = (TypeInfo)selected;
                boolean isDefaultConstructorSearchRequired = true;
                if (resourceSet != null) {
                    ClassDescriptorDecorator decorator;
                    JavaClass selectedEMFClass = Utilities.getJavaClass((String)ti.getFullyQualifiedName(), (ResourceSet)resourceSet);
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.ve.internal.cde.decorators.ClassDescriptorDecorator");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((decorator = (ClassDescriptorDecorator)ClassDecoratorFeatureAccess.getDecoratorWithKeyedFeature((EClassifier)selectedEMFClass, (Class)clazz, (String)"org.eclipse.ve.internal.prototypefactory")) != null) {
                        isDefaultConstructorSearchRequired = false;
                    }
                }
                IType type = ti.resolveType(javaSearchScope);
                boolean isTypePublic = Flags.isPublic((int)type.getFlags());
                boolean isTypeAbstract = Flags.isAbstract((int)type.getFlags());
                boolean isInPresentPackage = type.getPackageFragment().getElementName().equals(packageName);
                boolean isTypeStatic = Flags.isStatic((int)type.getFlags());
                boolean isTypeInner = type.getDeclaringType() != null;
                boolean isPublicNullConstructorPresent = false;
                boolean isAnyConstructorPresent = false;
                if (isDefaultConstructorSearchRequired) {
                    IMethod[] methods = type.getMethods();
                    int m = 0;
                    while (m < methods.length) {
                        if (methods[m].isConstructor() && methods[m].getParameterTypes().length < 1 && Flags.isPublic((int)methods[m].getFlags())) {
                            isPublicNullConstructorPresent = true;
                        }
                        if (methods[m].isConstructor()) {
                            isAnyConstructorPresent = true;
                        }
                        ++m;
                    }
                }
                boolean bl = constructorError = isDefaultConstructorSearchRequired && !isPublicNullConstructorPresent && isAnyConstructorPresent;
                if (constructorError) {
                    if (message.length() > 0) {
                        message = message.concat(" : ");
                    }
                    message = message.concat(ChooseBeanMessages.SelectionAreaHelper_SecondaryMsg_NoPublicNullConstructor);
                }
                if (!isTypePublic) {
                    if (message.length() > 0) {
                        message = message.concat(" : ");
                    }
                    message = message.concat(ChooseBeanMessages.SelectionAreaHelper_SecondaryMsg_TypeNonPublic);
                }
                if (isTypeAbstract) {
                    if (message.length() > 0) {
                        message = message.concat(" : ");
                    }
                    message = message.concat(ChooseBeanMessages.ChooseBeanDialog_Message_AbstractType);
                }
                if (isTypeInner && !isTypeStatic) {
                    if (message.length() > 0) {
                        message = message.concat(" : ");
                    }
                    message = message.concat(ChooseBeanMessages.ChooseBeanDialog_Message_NonStaticType);
                }
                boolean bl2 = isInstantiable = !constructorError && (isTypePublic || isInPresentPackage) && !isTypeAbstract && (!isTypeInner || isTypeInner && isTypeStatic);
                if (isInstantiable) {
                    message = new String();
                }
            }
            catch (JavaModelException e) {
                t = e;
                isInstantiable = false;
                if (message.length() > 0) {
                    message = message.concat(" : ");
                }
                message = ChooseBeanMessages.SelectionAreaHelper_SecondaryMsg_Unknown_ERROR_;
            }
        }
        Status status = new Status(isInstantiable ? 0 : 4, JavaVEPlugin.getPlugin().getBundle().getSymbolicName(), isInstantiable ? 0 : 4, message, (Throwable)t);
        return status;
    }

    public static void setBeanName(EObject obj, String name, EditDomain ed) {
        if (obj != null) {
            AnnotationLinkagePolicy policy = ed.getAnnotationLinkagePolicy();
            Annotation annotation = policy.getAnnotation((Object)obj);
            if (annotation == null) {
                annotation = AnnotationPolicy.createAnnotation((Object)obj);
            }
            EStringToStringMapEntryImpl sentry = (EStringToStringMapEntryImpl)EcoreFactory.eINSTANCE.create(EcorePackage.eINSTANCE.getEStringToStringMapEntry());
            sentry.setKey((Object)"org.eclipse.ve.internal.cde.core.nameincomposition");
            sentry.setValue((Object)name);
            annotation.getKeyedValues().add((Object)sentry);
            policy.setModelOnAnnotation((Object)obj, annotation);
        }
    }

    public static String getFieldProposal(String className, EditDomain ed, ResourceSet rs) {
        String proposal = new String();
        if (ed != null && rs != null) {
            IBeanNameProposalRule pp;
            String result;
            DiagramData o = ed.getDiagramData();
            IType javaElement = null;
            Iterator iter = o.eAdapters().iterator();
            while (iter.hasNext()) {
                Object je;
                Object a = iter.next();
                if (!(a instanceof IAdaptable)) continue;
                IAdaptable iAdaptable = (IAdaptable)a;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.jdt.core.IJavaElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!((je = iAdaptable.getAdapter((Class)clazz)) instanceof IType)) continue;
                javaElement = (IType)je;
                break;
            }
            if (javaElement != null && (result = (pp = (IBeanNameProposalRule)ed.getRuleRegistry().getRule("ruleBeanNameProposal")).getProspectInstanceVariableName(className, new Object[]{javaElement}, rs)) != null) {
                proposal = result;
            }
        }
        return proposal;
    }
}

