/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.choosebean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.ve.internal.java.choosebean.ChooseBeanMessages;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class YesNoFilter
implements IFilter {
    private String[] yesTypes = null;
    private String[] noTypes = null;
    private List yesTypeFQNs = null;
    private List noTypeFQNs = null;
    private IPackageFragment pkg = null;
    private IProgressMonitor monitor = null;

    public YesNoFilter(String[] yesTypes, String[] noTypes, IPackageFragment pkg, IProgressMonitor monitor) {
        this.yesTypes = yesTypes;
        this.noTypes = noTypes;
        this.pkg = pkg;
        this.monitor = monitor;
        int num = (yesTypes == null ? 0 : yesTypes.length / 2) + (noTypes == null ? 0 : noTypes.length / 2);
        this.getMonitor().beginTask(ChooseBeanMessages.YesNoFilter_DependenciesMonitor_Message, num);
        this.getYesTypeFQNs();
        this.getNoTypeFQNs();
        this.getMonitor().worked(num);
    }

    public boolean select(Object toTest) {
        TypeInfo type = (TypeInfo)toTest;
        String fqn = type.getFullyQualifiedName();
        return !this.getNoTypeFQNs().contains(fqn) && this.getYesTypeFQNs().contains(fqn);
    }

    public List getNoTypeFQNs() {
        if (this.noTypeFQNs == null) {
            this.noTypeFQNs = this.getSubTypes(this.noTypes);
        }
        return this.noTypeFQNs;
    }

    public void setNoFQNs(List noTypeFQNs) {
        this.noTypeFQNs = noTypeFQNs;
    }

    protected List getSubTypes(String[] types) {
        if (types == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> subTypesList = new ArrayList<String>();
        int c = 0;
        while (c < types.length) {
            try {
                IType baseClass = this.getJavaProject().findType(types[c], types[c + 1]);
                this.getMonitor().subTask(baseClass.getFullyQualifiedName());
                this.getMonitor().worked(1);
                if (baseClass != null) {
                    int stc;
                    ITypeHierarchy th = baseClass.newTypeHierarchy(this.getJavaProject(), (IProgressMonitor)new NullProgressMonitor());
                    IType[] subTypes = null;
                    if (baseClass.isClass()) {
                        subTypes = th.getAllSubtypes(baseClass);
                    } else if (baseClass.isInterface()) {
                        subTypes = th.getAllSubtypes(baseClass);
                        stc = 0;
                        while (stc < subTypes.length) {
                            subTypesList.add(subTypes[stc].getFullyQualifiedName());
                            ++stc;
                        }
                        int i = 0;
                        while (i < subTypes.length) {
                            IType[] implementors = th.getAllSubtypes(subTypes[i]);
                            int stc2 = 0;
                            while (stc2 < implementors.length) {
                                subTypesList.add(implementors[stc2].getFullyQualifiedName());
                                ++stc2;
                            }
                            ++i;
                        }
                    }
                    subTypesList.add(baseClass.getFullyQualifiedName());
                    stc = 0;
                    while (stc < subTypes.length) {
                        subTypesList.add(subTypes[stc].getFullyQualifiedName());
                        ++stc;
                    }
                }
            }
            catch (JavaModelException e) {
                JavaVEPlugin.log(e, Level.WARNING);
            }
            c += 2;
        }
        return subTypesList;
    }

    protected IJavaProject getJavaProject() {
        return this.pkg.getJavaProject();
    }

    protected IProgressMonitor getMonitor() {
        if (this.monitor == null) {
            this.monitor = new NullProgressMonitor();
        }
        return this.monitor;
    }

    public List getYesTypeFQNs() {
        if (this.yesTypeFQNs == null) {
            this.yesTypeFQNs = this.getSubTypes(this.yesTypes);
        }
        return this.yesTypeFQNs;
    }

    public void setYesTypeFQNs(List yesTypeFQNs) {
        this.yesTypeFQNs = yesTypeFQNs;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }
}

