/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.ClassDescriptorDecoratorPolicy;
import org.eclipse.ve.internal.java.core.JavaMessages;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.vce.VCEPreferences;

public abstract class AbstractRenameInstanceDialog
extends TitleAreaDialog {
    protected String[] originalNames = null;
    protected String[] newNames = null;
    protected Text[] nameTexts = null;
    protected Label[] nameStatuses = null;
    protected EObject[] annotates = null;
    protected EditDomain domain = null;
    protected ILabelProvider labelProvider = null;
    protected boolean forceChange = false;
    protected boolean enableDontShowOption = false;
    protected Image titleImage = null;
    protected Image errorImage = null;

    public AbstractRenameInstanceDialog(Shell parentShell, String[] names, EObject[] annotates, EditDomain domain, boolean forceChange, boolean enableDontShowOption) {
        super(parentShell);
        this.originalNames = names;
        this.annotates = annotates;
        this.domain = domain;
        this.forceChange = forceChange;
        this.enableDontShowOption = enableDontShowOption;
        this.nameTexts = new Text[names.length];
        this.nameStatuses = new Label[names.length];
        this.newNames = new String[names.length];
        int i = 0;
        while (i < this.originalNames.length) {
            this.newNames[i] = this.originalNames[i];
            ++i;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite contents = this.createComposite(parentComposite);
        AbstractRenameInstanceDialog.applyDialogFont((Control)parent);
        return contents;
    }

    protected Composite createComposite(Composite parentComposite) {
        Composite mainContainer = new Composite(parentComposite, 0);
        mainContainer.setLayout((Layout)new GridLayout(2, false));
        mainContainer.setLayoutData((Object)new GridData(1808));
        Composite beanNamesContainer = new Composite(mainContainer, 0);
        beanNamesContainer.setLayout((Layout)new GridLayout(4, false));
        beanNamesContainer.setFont(parentComposite.getFont());
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        beanNamesContainer.setLayoutData((Object)data);
        int nameCount = 0;
        while (nameCount < this.newNames.length) {
            Image image = JavaVEPlugin.getJavaBeanImage();
            this.nameStatuses[nameCount] = new Label(beanNamesContainer, 0);
            this.nameStatuses[nameCount].setImage(image);
            String name = this.newNames[nameCount];
            if (this.annotates[nameCount] != null) {
                this.labelProvider = ClassDescriptorDecoratorPolicy.getPolicy((EditDomain)this.domain).getLabelProvider((EClassifier)this.annotates[nameCount].eClass());
                if (this.labelProvider != null) {
                    name = this.labelProvider.getText((Object)this.annotates[nameCount]);
                    image = this.labelProvider.getImage((Object)this.annotates[nameCount]);
                }
            }
            Label imageLabel = new Label(beanNamesContainer, 0);
            imageLabel.setImage(image);
            Label nameLabel = new Label(beanNamesContainer, 0);
            nameLabel.setText(name);
            this.nameTexts[nameCount] = new Text(beanNamesContainer, 2048);
            this.nameTexts[nameCount].setText(this.newNames[nameCount]);
            this.nameTexts[nameCount].setLayoutData((Object)new GridData(768));
            this.nameTexts[nameCount].addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AbstractRenameInstanceDialog.this.updateStatus();
                }
            });
            ++nameCount;
        }
        if (this.enableDontShowOption) {
            Link preferencesLink = new Link(mainContainer, 0);
            data = new GridData(768);
            data.horizontalAlignment = 1;
            preferencesLink.setLayoutData((Object)data);
            preferencesLink.setText(MessageFormat.format("<a>{0}</a>", JavaMessages.AbstractRenameInstanceDialog_Preferences));
            preferencesLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Link link = (Link)e.getSource();
                    String prefID = "org.eclipse.ve.internal.java.vce.VCEPreferencePage";
                    PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)prefID, (String[])new String[]{prefID}, null).open();
                }
            });
            Button checkbox = new Button(mainContainer, 32);
            checkbox.setText(JavaMessages.AbstractRenameInstanceDialog_Checkbox_DontAsk);
            checkbox.setLayoutData((Object)new GridData());
            checkbox.setSelection(!VCEPreferences.askForRename());
            checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button cb = (Button)e.getSource();
                    JavaVEPlugin.getPlugin().getPluginPreferences().setValue("RENAME_INSTANCE_ASK_KEY", !cb.getSelection());
                }
            });
        }
        this.titleImage = JavaPluginImages.DESC_WIZBAN_REFACTOR_TYPE.createImage((Device)parentComposite.getDisplay());
        this.errorImage = JavaPluginImages.DESC_OBJS_REFACTORING_ERROR.createImage((Device)parentComposite.getDisplay());
        this.setTitleImage(this.titleImage);
        return beanNamesContainer;
    }

    protected abstract String getValidInstanceVariableName(EObject var1, String var2, List var3);

    protected void updateStatus() {
        this.setErrorMessage(null);
        boolean allNamesValid = true;
        boolean anyChanged = false;
        String errorMessage = null;
        this.setErrorMessage(null);
        int nameCount = 0;
        while (nameCount < this.newNames.length) {
            this.newNames[nameCount] = this.nameTexts[nameCount].getText();
            IStatus validation = JavaConventions.validateFieldName((String)this.newNames[nameCount]);
            if (!this.originalNames[nameCount].equals(this.newNames[nameCount])) {
                anyChanged = true;
                if (validation.isOK()) {
                    ArrayList<String> currentNames = new ArrayList<String>(this.newNames.length);
                    int count = 0;
                    while (count < this.newNames.length) {
                        if (count != nameCount) {
                            currentNames.add(this.nameTexts[count].getText());
                        }
                        ++count;
                    }
                    String newNameSuggestion = this.getValidInstanceVariableName(this.annotates[nameCount], this.newNames[nameCount], currentNames);
                    if (!this.newNames[nameCount].equals(newNameSuggestion)) {
                        errorMessage = MessageFormat.format(JavaMessages.AbstractRenameInstanceDialog_ErrorMsg_NotUnique, this.newNames[nameCount], newNameSuggestion);
                        allNamesValid = false;
                        this.nameStatuses[nameCount].setImage(this.errorImage);
                        this.nameStatuses[nameCount].setToolTipText(errorMessage);
                    } else {
                        this.nameStatuses[nameCount].setImage(JavaVEPlugin.getJavaBeanImage());
                        this.nameStatuses[nameCount].setToolTipText(null);
                    }
                } else {
                    errorMessage = validation.getMessage();
                    allNamesValid = false;
                    this.nameStatuses[nameCount].setImage(this.errorImage);
                    this.nameStatuses[nameCount].setToolTipText(errorMessage);
                }
            } else {
                this.nameStatuses[nameCount].setImage(JavaVEPlugin.getJavaBeanImage());
                this.nameStatuses[nameCount].setToolTipText(null);
            }
            ++nameCount;
        }
        if (!allNamesValid) {
            this.setErrorMessage(errorMessage);
            this.getButton(0).setEnabled(false);
        } else if (this.forceChange && !anyChanged) {
            this.getButton(0).setEnabled(false);
        } else {
            this.getButton(0).setEnabled(true);
        }
    }

    public String[] getFinalNames() {
        return this.newNames;
    }

    public boolean close() {
        if (this.titleImage != null) {
            this.titleImage.dispose();
        }
        if (this.errorImage != null) {
            this.errorImage.dispose();
        }
        return super.close();
    }

    public void create() {
        super.create();
        if (this.forceChange) {
            this.getButton(0).setEnabled(false);
        }
    }
}

