/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import java.text.MessageFormat;
import java.util.logging.Level;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jem.internal.instantiation.ImplicitAllocation;
import org.eclipse.jem.internal.instantiation.InitStringAllocation;
import org.eclipse.jem.internal.instantiation.InstantiationPackage;
import org.eclipse.jem.internal.instantiation.JavaAllocation;
import org.eclipse.jem.internal.instantiation.PTExpression;
import org.eclipse.jem.internal.instantiation.PTInstanceReference;
import org.eclipse.jem.internal.instantiation.PTMethodInvocation;
import org.eclipse.jem.internal.instantiation.PTThisLiteral;
import org.eclipse.jem.internal.instantiation.ParseTreeAllocation;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.ParseTreeAllocationInstantiationVisitor;
import org.eclipse.jem.internal.proxy.core.Expression;
import org.eclipse.jem.internal.proxy.core.ExpressionProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IExpression;
import org.eclipse.jem.internal.proxy.core.IProxy;
import org.eclipse.jem.internal.proxy.core.IProxyBeanType;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.initParser.tree.ForExpression;
import org.eclipse.jem.internal.proxy.initParser.tree.NoExpressionValueException;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.IAllocationProcesser;
import org.eclipse.ve.internal.java.core.IBeanProxyDomain;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.java.core.IInternalBeanProxyHost;
import org.eclipse.ve.internal.java.core.JavaMessages;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class BasicAllocationProcesser
implements IAllocationProcesser {
    protected IBeanProxyDomain domain;

    public IBeanProxy allocate(JavaAllocation allocation) throws IAllocationProcesser.AllocationException {
        EClass allocClass = allocation.eClass();
        if (allocClass == InstantiationPackage.eINSTANCE.getParseTreeAllocation()) {
            return this.allocate((ParseTreeAllocation)allocation);
        }
        if (allocClass == InstantiationPackage.eINSTANCE.getInitStringAllocation()) {
            return this.allocate((InitStringAllocation)allocation);
        }
        if (allocClass == InstantiationPackage.eINSTANCE.getImplicitAllocation()) {
            return this.allocate((ImplicitAllocation)allocation);
        }
        throw new IAllocationProcesser.AllocationException(new IllegalArgumentException(MessageFormat.format(JavaMessages.BasicAllocationProcesser_InvalidAllocationClass_EXC_, allocClass.toString())));
    }

    protected IBeanProxy allocate(ParseTreeAllocation allocation) throws IAllocationProcesser.AllocationException {
        return BasicAllocationProcesser.instantiateWithExpression(allocation.getExpression(), this.domain);
    }

    protected ExpressionProxy allocate(ParseTreeAllocation allocation, IExpression expression) throws IAllocationProcesser.AllocationException {
        ParseAllocation allocator = new ParseAllocation(this.domain.getThisType());
        try {
            return allocator.getProxy(allocation.getExpression(), expression);
        }
        catch (ParseTreeAllocationInstantiationVisitor.ProcessingException e) {
            throw new IAllocationProcesser.AllocationException(e.getCause());
        }
        catch (RuntimeException e) {
            throw new IAllocationProcesser.AllocationException(e);
        }
    }

    protected ExpressionProxy allocate(InitStringAllocation initString, IExpression expression) throws IAllocationProcesser.AllocationException {
        String qualifiedClassName = ((IJavaInstance)initString.eContainer()).getJavaType().getQualifiedNameForReflection();
        String initializationString = initString.getInitString();
        IProxyBeanType targetClass = expression.getRegistry().getBeanTypeProxyFactory().getBeanTypeProxy(expression, qualifiedClassName);
        if (targetClass == null || targetClass.isBeanProxy() && ((IBeanTypeProxy)targetClass).getInitializationError() != null) {
            ExceptionInInitializerError exc = new ExceptionInInitializerError(targetClass != null ? ((IBeanTypeProxy)targetClass).getInitializationError() : MessageFormat.format(JavaMessages.Proxy_Class_has_Errors_ERROR_, JavaMessages.BasicAllocationProcesser_unknown_ERROR_));
            if (JavaVEPlugin.isLoggingLevel(Level.WARNING)) {
                JavaVEPlugin.log("Could not instantiate " + (targetClass != null ? targetClass.getTypeName() : "unknown") + " with initialization string=" + initializationString, Level.WARNING);
                JavaVEPlugin.log(exc, Level.WARNING);
            }
            throw new IAllocationProcesser.AllocationException(exc);
        }
        return BasicAllocationProcesser.instantiateWithString(initializationString, targetClass, expression);
    }

    protected IProxy allocate(ImplicitAllocation implicit, IExpression expression) {
        EObject source = implicit.getParent();
        IBeanProxyHost proxyhost = (IBeanProxyHost)EcoreUtil.getExistingAdapter((Notifier)source, (Object)IBeanProxyHost.BEAN_PROXY_TYPE);
        return ((IInternalBeanProxyHost)proxyhost).getBeanPropertyProxyValue(implicit.getFeature(), expression, ForExpression.ROOTEXPRESSION);
    }

    protected IBeanProxy allocate(InitStringAllocation initString) throws IAllocationProcesser.AllocationException {
        String qualifiedClassName = ((IJavaInstance)initString.eContainer()).getJavaType().getQualifiedNameForReflection();
        return BasicAllocationProcesser.instantiateWithString(initString.getInitString(), this.domain.getProxyFactoryRegistry().getBeanTypeProxyFactory().getBeanTypeProxy(qualifiedClassName));
    }

    protected IBeanProxy allocate(ImplicitAllocation implicit) {
        EObject source = implicit.getParent();
        IBeanProxyHost proxyhost = (IBeanProxyHost)EcoreUtil.getExistingAdapter((Notifier)source, (Object)IBeanProxyHost.BEAN_PROXY_TYPE);
        return proxyhost.getBeanPropertyProxyValue(implicit.getFeature());
    }

    public static IBeanProxy instantiateWithExpression(PTExpression expression, IBeanProxyDomain domain) throws IAllocationProcesser.AllocationException {
        ParseAllocation allocator = new ParseAllocation(domain.getThisType());
        try {
            return allocator.getBeanProxy(expression, domain.getProxyFactoryRegistry());
        }
        catch (ParseTreeAllocationInstantiationVisitor.ProcessingException e) {
            throw new IAllocationProcesser.AllocationException(e.getCause());
        }
        catch (ThrowableProxy e) {
            throw new IAllocationProcesser.AllocationException(e);
        }
        catch (NoExpressionValueException e) {
            throw new IAllocationProcesser.AllocationException(e);
        }
        catch (RuntimeException e) {
            throw new IAllocationProcesser.AllocationException(e);
        }
    }

    public IProxy allocate(PTExpression parseTreeExpression, IExpression expression) throws IAllocationProcesser.AllocationException {
        ParseAllocation allocator = new ParseAllocation(this.domain.getThisType());
        try {
            return allocator.getProxy(parseTreeExpression, expression);
        }
        catch (ParseTreeAllocationInstantiationVisitor.ProcessingException e) {
            throw new IAllocationProcesser.AllocationException(e.getCause());
        }
        catch (RuntimeException e) {
            throw new IAllocationProcesser.AllocationException(e);
        }
    }

    public static IBeanProxy instantiateWithString(String initializationString, IBeanTypeProxy targetClass) throws IAllocationProcesser.AllocationException {
        if (targetClass == null || targetClass.getInitializationError() != null) {
            ExceptionInInitializerError exc = new ExceptionInInitializerError(targetClass != null ? targetClass.getInitializationError() : MessageFormat.format(JavaMessages.Proxy_Class_has_Errors_ERROR_, JavaMessages.BasicAllocationProcesser_unknown_ERROR_));
            if (JavaVEPlugin.isLoggingLevel(Level.WARNING)) {
                JavaVEPlugin.log("Could not instantiate " + (targetClass != null ? targetClass.getTypeName() : "unknown") + " with initialization string=" + initializationString, Level.WARNING);
                JavaVEPlugin.log(exc, Level.WARNING);
            }
            throw new IAllocationProcesser.AllocationException(exc);
        }
        try {
            return initializationString != null ? targetClass.newInstance(initializationString) : targetClass.newInstance();
        }
        catch (ThrowableProxy exc) {
            if (JavaVEPlugin.isLoggingLevel(Level.WARNING)) {
                JavaVEPlugin.log("Could not instantiate " + targetClass.getTypeName() + " with initialization string=" + initializationString, Level.WARNING);
                JavaVEPlugin.log(exc, Level.WARNING);
            }
            throw new IAllocationProcesser.AllocationException(exc);
        }
        catch (InstantiationException exc) {
            if (JavaVEPlugin.isLoggingLevel(Level.WARNING)) {
                JavaVEPlugin.log("Could not instantiate " + targetClass.getTypeName() + " with initialization string=" + initializationString, Level.WARNING);
                JavaVEPlugin.log(exc, Level.WARNING);
            }
            throw new IAllocationProcesser.AllocationException(exc);
        }
        catch (ClassCastException exc) {
            if (JavaVEPlugin.isLoggingLevel(Level.WARNING)) {
                JavaVEPlugin.log("Could not instantiate " + targetClass.getTypeName() + " with initialization string=" + initializationString, Level.WARNING);
                JavaVEPlugin.log(exc, Level.WARNING);
            }
            throw new IAllocationProcesser.AllocationException(exc);
        }
    }

    public static ExpressionProxy instantiateWithString(String initString, IProxyBeanType beanType, IExpression expression) {
        if (initString == null) {
            ExpressionProxy result = expression.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
            expression.createClassInstanceCreation(ForExpression.ASSIGNMENT_RIGHT, beanType, 0);
            return result;
        }
        ExpressionProxy result = expression.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
        ((Expression)expression).createNewInstance(ForExpression.ASSIGNMENT_RIGHT, initString, beanType);
        return result;
    }

    public IProxy allocate(JavaAllocation allocation, IExpression expression) throws IAllocationProcesser.AllocationException {
        EClass allocClass;
        block7: {
            int mark;
            block6: {
                block5: {
                    ExpressionProxy expressionProxy;
                    mark = expression.mark();
                    try {
                        allocClass = allocation.eClass();
                        if (allocClass != InstantiationPackage.eINSTANCE.getParseTreeAllocation()) break block5;
                        expressionProxy = this.allocate((ParseTreeAllocation)allocation, expression);
                        Object var5_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_11 = null;
                        expression.endMark(mark);
                        throw throwable;
                    }
                    expression.endMark(mark);
                    return expressionProxy;
                }
                if (allocClass != InstantiationPackage.eINSTANCE.getInitStringAllocation()) break block6;
                ExpressionProxy expressionProxy = this.allocate((InitStringAllocation)allocation, expression);
                Object var5_9 = null;
                expression.endMark(mark);
                return expressionProxy;
            }
            if (allocClass != InstantiationPackage.eINSTANCE.getImplicitAllocation()) break block7;
            IProxy iProxy = this.allocate((ImplicitAllocation)allocation, expression);
            Object var5_10 = null;
            expression.endMark(mark);
            return iProxy;
        }
        throw new IAllocationProcesser.AllocationException(new IllegalArgumentException(MessageFormat.format(JavaMessages.BasicAllocationProcesser_InvalidAllocationClass_EXC_, allocClass.toString())));
    }

    public void setBeanProxyDomain(IBeanProxyDomain domain) {
        this.domain = domain;
    }

    private static class ParseAllocation
    extends ParseTreeAllocationInstantiationVisitor {
        private IBeanTypeProxy thisType;

        public ParseAllocation(IBeanTypeProxy thisType) {
            this.thisType = thisType;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean visit(PTInstanceReference node) {
            IExpression exp;
            IInternalBeanProxyHost proxyHost;
            block7: {
                proxyHost = (IInternalBeanProxyHost)BeanProxyUtilities.getBeanProxyHost((IJavaInstance)node.getObject());
                exp = this.getExpression();
                if (!proxyHost.isBeanProxyInstantiated() && !proxyHost.inInstantiation()) {
                    exp.createSubexpression();
                    try {
                        proxyHost.instantiateBeanProxy(exp);
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        if (exp.isValid()) {
                            exp.createSubexpressionEnd();
                        }
                        throw throwable;
                    }
                    {
                        Object var4_6 = null;
                        if (exp.isValid()) {
                            exp.createSubexpressionEnd();
                        }
                        break block7;
                    }
                }
                if (proxyHost.inInstantiation() && proxyHost.getProxy() == null) {
                    throw new ParseTreeAllocationInstantiationVisitor.ProcessingException((Throwable)new IllegalStateException(JavaMessages.BasicAllocationProcesser_BeanRecurrsionError));
                }
            }
            exp.createProxyExpression(this.getNextExpression(), proxyHost.getProxy());
            return false;
        }

        public boolean visit(PTMethodInvocation node) {
            if ("getClass".equals(node.getName()) && (node.getReceiver() == null || node.getReceiver() instanceof PTThisLiteral)) {
                if (this.thisType == null) {
                    throw new IllegalArgumentException(JavaMessages.BasicAllocationProcesser_ThisTypeNotFoundOrInvalid_EXC_);
                }
                try {
                    this.getExpression().createProxyExpression(this.getNextExpression(), (IProxy)this.thisType);
                }
                catch (IllegalStateException e) {
                    throw new ParseTreeAllocationInstantiationVisitor.ProcessingException((Throwable)e);
                }
                return false;
            }
            return super.visit(node);
        }
    }
}

