/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import java.util.List;
import java.util.logging.Level;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.jem.internal.beaninfo.PropertyDecorator;
import org.eclipse.jem.internal.instantiation.InstantiationFactory;
import org.eclipse.jem.internal.instantiation.JavaAllocation;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.jem.internal.proxy.core.ICharacterBeanProxy;
import org.eclipse.jem.internal.proxy.core.IExpression;
import org.eclipse.jem.internal.proxy.core.IFieldProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.IInvokable;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.INumberBeanProxy;
import org.eclipse.jem.internal.proxy.core.IProxyField;
import org.eclipse.jem.internal.proxy.core.IProxyMethod;
import org.eclipse.jem.internal.proxy.core.IStandardBeanProxyFactory;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaDataType;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.java.TypeKind;
import org.eclipse.ve.internal.cde.core.CDEUtilities;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.core.IBeanProxyDomain;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.java.core.IInternalBeanProxyHost;
import org.eclipse.ve.internal.java.core.JavaEditDomainHelper;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class BeanProxyUtilities {
    public static IJavaInstance wrapperBeanProxy(IBeanProxy aBeanProxy, ResourceSet aResourceSet, String initString, boolean ownsProxy) {
        return BeanProxyUtilities.wrapperBeanProxy(aBeanProxy, aResourceSet, ownsProxy, initString != null ? InstantiationFactory.eINSTANCE.createInitStringAllocation(initString) : null);
    }

    public static IJavaInstance wrapperBeanProxy(IBeanProxy aBeanProxy, ResourceSet aResourceSet, boolean ownsProxy, JavaAllocation alloc) {
        JavaClass javaClass;
        if (aBeanProxy == null) {
            return null;
        }
        JavaHelpers javaType = BeanProxyUtilities.getJavaType(aBeanProxy, aResourceSet);
        if (!javaType.isPrimitive() && (javaClass = (JavaClass)javaType).getKind() == TypeKind.UNDEFINED_LITERAL) {
            return null;
        }
        IJavaInstance javaInstance = (IJavaInstance)javaType.getEPackage().getEFactoryInstance().create((EClass)javaType);
        javaInstance.setAllocation(alloc);
        IInternalBeanProxyHost beanProxyHost = (IInternalBeanProxyHost)BeanProxyUtilities.getBeanProxyHost(javaInstance, aResourceSet);
        beanProxyHost.setBeanProxy(aBeanProxy);
        beanProxyHost.setOwnsProxy(ownsProxy);
        return javaInstance;
    }

    public static IJavaInstance wrapperBeanProxy(IBeanProxy aBeanProxy, ResourceSet aResourceSet, boolean ownsProxy, JavaAllocation alloc, JavaHelpers javaType) {
        JavaClass javaClass;
        if (aBeanProxy == null) {
            return null;
        }
        if (!javaType.isPrimitive() && (javaClass = (JavaClass)javaType).getKind() == TypeKind.UNDEFINED_LITERAL) {
            return null;
        }
        IJavaInstance javaInstance = (IJavaInstance)javaType.getEPackage().getEFactoryInstance().create((EClass)javaType);
        javaInstance.setAllocation(alloc);
        IInternalBeanProxyHost beanProxyHost = (IInternalBeanProxyHost)BeanProxyUtilities.getBeanProxyHost(javaInstance, aResourceSet);
        beanProxyHost.setBeanProxy(aBeanProxy);
        beanProxyHost.setOwnsProxy(ownsProxy);
        return javaInstance;
    }

    public static JavaHelpers getJavaType(IBeanProxy aBeanProxy, ResourceSet aResourceSet) {
        String qualifiedClassName = aBeanProxy.getTypeProxy().getFormalTypeName();
        JavaHelpers javaType = JavaRefFactory.eINSTANCE.reflectType(qualifiedClassName, aResourceSet);
        return javaType;
    }

    public static IJavaInstance wrapperBeanProxyAsPrimitiveType(IBeanProxy aBeanProxy, JavaDataType aType, ResourceSet aResourceSet, String anInitializationString) {
        return BeanProxyUtilities.wrapperBeanProxyAsPrimitive(aBeanProxy, aType, aResourceSet, anInitializationString != null ? InstantiationFactory.eINSTANCE.createInitStringAllocation(anInitializationString) : null);
    }

    public static IJavaInstance wrapperBeanProxyAsPrimitive(IBeanProxy aBeanProxy, JavaDataType aType, ResourceSet aResourceSet, JavaAllocation alloc) {
        if (aBeanProxy == null) {
            return null;
        }
        IIntegerBeanProxy primitiveProxy = null;
        IStandardBeanProxyFactory proxyFactory = aBeanProxy.getProxyFactoryRegistry().getBeanProxyFactory();
        String typeName = aType.getQualifiedName();
        if (typeName.equals("int")) {
            primitiveProxy = proxyFactory.createBeanProxyWith(((INumberBeanProxy)aBeanProxy).intValue());
        } else if (typeName.equals("boolean")) {
            primitiveProxy = proxyFactory.createBeanProxyWith(((IBooleanBeanProxy)aBeanProxy).booleanValue());
        } else if (typeName.equals("short")) {
            primitiveProxy = proxyFactory.createBeanProxyWith(((INumberBeanProxy)aBeanProxy).shortValue());
        } else if (typeName.equals("long")) {
            primitiveProxy = proxyFactory.createBeanProxyWith(((INumberBeanProxy)aBeanProxy).longValue());
        } else if (typeName.equals("float")) {
            primitiveProxy = proxyFactory.createBeanProxyWith(((INumberBeanProxy)aBeanProxy).floatValue());
        } else if (typeName.equals("double")) {
            primitiveProxy = proxyFactory.createBeanProxyWith(((INumberBeanProxy)aBeanProxy).doubleValue());
        } else if (typeName.equals("char")) {
            primitiveProxy = proxyFactory.createBeanProxyWith(((ICharacterBeanProxy)aBeanProxy).charValue());
        } else if (typeName.equals("byte")) {
            primitiveProxy = proxyFactory.createBeanProxyWith(((INumberBeanProxy)aBeanProxy).byteValue());
        }
        IJavaInstance javaInstance = (IJavaInstance)aType.getEPackage().getEFactoryInstance().create((EClass)aType);
        javaInstance.setAllocation(alloc);
        IInternalBeanProxyHost beanProxyHost = (IInternalBeanProxyHost)BeanProxyUtilities.getBeanProxyHost(javaInstance, aResourceSet);
        beanProxyHost.setBeanProxy((IBeanProxy)primitiveProxy);
        beanProxyHost.setOwnsProxy(true);
        return javaInstance;
    }

    public static ProxyFactoryRegistry getProxyFactoryRegistry(EditPart anEditPart) {
        IBeanProxyDomain proxyDomain = JavaEditDomainHelper.getBeanProxyDomain(EditDomain.getEditDomain((EditPart)anEditPart));
        if (proxyDomain != null) {
            return proxyDomain.getProxyFactoryRegistry();
        }
        if (JavaVEPlugin.isLoggingLevel(Level.WARNING)) {
            JavaVEPlugin.log("Unable to find a proxy factory registry for " + anEditPart, Level.WARNING);
        }
        return null;
    }

    public static void writeBeanFeature(PropertyDecorator aPropertyDecorator, IBeanProxy aSource, IBeanProxy aValue) throws ThrowableProxy, NoSuchMethodException {
        if (aPropertyDecorator.getWriteMethod() != null) {
            Method method = aPropertyDecorator.getWriteMethod();
            ProxyFactoryRegistry registry = aSource.getProxyFactoryRegistry();
            IMethodProxy setFeatureMethodProxy = BeanProxyUtilities.getMethodProxy(method, registry);
            setFeatureMethodProxy.invoke(aSource, aValue);
        } else if (aPropertyDecorator.getField() != null) {
            BeanProxyUtilities.setBeanField(aPropertyDecorator.getField().getName(), aSource, aValue);
        }
    }

    public static void setBeanField(String fieldName, IBeanProxy aSource, IBeanProxy aValue) {
        IFieldProxy aField = aSource.getTypeProxy().getFieldProxy(fieldName);
        try {
            aField.set(aSource, aValue);
        }
        catch (ThrowableProxy e) {
            JavaVEPlugin.log(e, Level.WARNING);
        }
    }

    public static IBeanProxy getBeanField(String fieldName, IBeanProxy aSource) {
        IFieldProxy aField = aSource.getTypeProxy().getFieldProxy(fieldName);
        try {
            return aField.get(aSource);
        }
        catch (ThrowableProxy e) {
            JavaVEPlugin.log(e, Level.WARNING);
            return null;
        }
    }

    public static IBeanProxy readBeanFeature(PropertyDecorator aPropertyDecorator, IBeanProxy aSource) throws ThrowableProxy, NoSuchMethodException {
        if (!aSource.isValid()) {
            return null;
        }
        if (aPropertyDecorator.getReadMethod() != null) {
            Method method = aPropertyDecorator.getReadMethod();
            ProxyFactoryRegistry registry = aSource.getProxyFactoryRegistry();
            IMethodProxy getMethodProxy = BeanProxyUtilities.getMethodProxy(method, registry);
            return getMethodProxy.invoke(aSource);
        }
        if (aPropertyDecorator.getField() != null) {
            Field field = aPropertyDecorator.getField();
            IFieldProxy aField = aSource.getTypeProxy().getFieldProxy(field.getName());
            return aField.get(aSource);
        }
        return null;
    }

    public static IMethodProxy getMethodProxy(Method aMethod, ProxyFactoryRegistry aRegistry) throws NoSuchMethodException {
        String methodName = aMethod.getName();
        EList inputMethods = aMethod.getParameters();
        String[] methodParms = new String[inputMethods.size()];
        int i = 0;
        while (i < inputMethods.size()) {
            JavaParameter parm = (JavaParameter)inputMethods.get(i);
            JavaHelpers jh = parm.getJavaType();
            methodParms[i] = jh.getQualifiedNameForReflection();
            ++i;
        }
        String className = aMethod.getContainingJavaClass().getQualifiedNameForReflection();
        IMethodProxy result = aRegistry.getMethodProxyFactory().getMethodProxy(className, methodName, methodParms);
        if (result != null) {
            return result;
        }
        throw new NoSuchMethodException(String.valueOf(aMethod.getContainingJavaClass().getJavaName()) + '.' + aMethod.getMethodElementSignature());
    }

    public static IProxyMethod getMethodProxy(IExpression expression, Method aMethod) throws NoSuchMethodException {
        String[] methodParms;
        String methodName = aMethod.getName();
        EList inputMethods = aMethod.getParameters();
        if (inputMethods.isEmpty()) {
            methodParms = null;
        } else {
            methodParms = new String[inputMethods.size()];
            int i = 0;
            while (i < inputMethods.size()) {
                JavaParameter parm = (JavaParameter)inputMethods.get(i);
                JavaHelpers jh = parm.getJavaType();
                methodParms[i] = jh.getQualifiedNameForReflection();
                ++i;
            }
        }
        String className = aMethod.getContainingJavaClass().getQualifiedNameForReflection();
        ProxyFactoryRegistry registry = expression.getRegistry();
        IProxyMethod result = registry.getMethodProxyFactory().getMethodProxy(expression, className, methodName, methodParms);
        if (result != null) {
            return result;
        }
        throw new NoSuchMethodException(String.valueOf(aMethod.getContainingJavaClass().getJavaName()) + '.' + aMethod.getMethodElementSignature());
    }

    public static IFieldProxy getFieldProxy(Field aField, ProxyFactoryRegistry aRegistry) throws NoSuchFieldException {
        String fieldName = aField.getName();
        String className = aField.getContainingJavaClass().getQualifiedNameForReflection();
        IFieldProxy result = aRegistry.getBeanTypeProxyFactory().getBeanTypeProxy(className).getFieldProxy(fieldName);
        if (result != null) {
            return result;
        }
        throw new NoSuchFieldException(String.valueOf(aField.getContainingJavaClass().getJavaName()) + '.' + aField.getName());
    }

    public static IProxyField getFieldProxy(IExpression expression, Field aField) throws NoSuchFieldException {
        String fieldName = aField.getName();
        String className = aField.getContainingJavaClass().getQualifiedNameForReflection();
        ProxyFactoryRegistry registry = expression.getRegistry();
        IProxyField result = registry.getMethodProxyFactory().getFieldProxy(expression, className, fieldName);
        if (result != null) {
            return result;
        }
        throw new NoSuchFieldException(String.valueOf(aField.getContainingJavaClass().getJavaName()) + '.' + fieldName);
    }

    public static IInvokable getInvokable(Method aMethod, ProxyFactoryRegistry aRegistry) {
        String methodName = aMethod.getName();
        EList inputMethods = aMethod.getParameters();
        String[] methodParms = new String[inputMethods.size()];
        int i = 0;
        while (i < inputMethods.size()) {
            JavaParameter parm = (JavaParameter)inputMethods.get(i);
            JavaHelpers jh = parm.getJavaType();
            methodParms[i] = jh.getQualifiedNameForReflection();
            ++i;
        }
        String className = aMethod.getContainingJavaClass().getQualifiedNameForReflection();
        return aRegistry.getMethodProxyFactory().getInvokable(className, methodName, methodParms);
    }

    public static IBeanProxy getBeanProxy(IJavaInstance aBean) {
        return BeanProxyUtilities.getBeanProxy(aBean, false);
    }

    public static IBeanProxy getBeanProxy(IJavaInstance aBean, boolean noInstantiateOnError) {
        if (aBean == null) {
            return null;
        }
        IInternalBeanProxyHost aBeanProxyHost = (IInternalBeanProxyHost)BeanProxyUtilities.getBeanProxyHost(aBean);
        if (aBeanProxyHost.hasInstantiationErrors() && !noInstantiateOnError) {
            return null;
        }
        aBeanProxyHost.instantiateBeanProxy();
        return aBeanProxyHost.getBeanProxy();
    }

    public static IBeanProxy getBeanProxy(IJavaInstance aBean, ResourceSet aResourceSet) {
        if (aBean == null) {
            return null;
        }
        IInternalBeanProxyHost aBeanProxyHost = (IInternalBeanProxyHost)BeanProxyUtilities.getBeanProxyHost(aBean, aResourceSet);
        if (!aBeanProxyHost.hasInstantiationErrors()) {
            aBeanProxyHost.instantiateBeanProxy();
        }
        return aBeanProxyHost.getBeanProxy();
    }

    public static IBeanProxyHost getBeanProxyHost(IJavaInstance aBean) {
        if (aBean == null) {
            return null;
        }
        return (IBeanProxyHost)EcoreUtil.getRegisteredAdapter((EObject)aBean, (Object)IBeanProxyHost.BEAN_PROXY_TYPE);
    }

    public static IBeanProxyHost getBeanProxyHost(IJavaInstance aBean, ResourceSet aResourceSet) {
        if (aBean == null) {
            return null;
        }
        IBeanProxyHost existing = (IBeanProxyHost)EcoreUtil.getExistingAdapter((Notifier)aBean, (Object)IBeanProxyHost.BEAN_PROXY_TYPE);
        return existing != null ? existing : (IBeanProxyHost)EcoreUtil.getAdapterFactory((List)aResourceSet.getAdapterFactories(), (Object)IBeanProxyHost.BEAN_PROXY_TYPE).adaptNew((Notifier)aBean, (Object)IBeanProxyHost.BEAN_PROXY_TYPE);
    }

    public static IBeanProxyHost getBeanProxyHost(IJavaInstance aBean, EditDomain domain) {
        if (aBean != null) {
            IBeanProxyHost settingBean = (IBeanProxyHost)EcoreUtil.getRegisteredAdapter((EObject)aBean, (Object)IBeanProxyHost.BEAN_PROXY_TYPE);
            if (settingBean == null) {
                ResourceSet rset = JavaEditDomainHelper.getResourceSet((EditDomain)domain);
                AdapterFactory f = EcoreUtil.getAdapterFactory((List)rset.getAdapterFactories(), (Object)IBeanProxyHost.BEAN_PROXY_TYPE);
                settingBean = (IBeanProxyHost)f.adaptNew((Notifier)aBean, (Object)IBeanProxyHost.BEAN_PROXY_TYPE);
            }
            return settingBean;
        }
        return null;
    }

    public static String getUnqualifiedClassName(String aQualifiedClassName) {
        int positionOfLastPeriod = aQualifiedClassName.lastIndexOf(46);
        return aQualifiedClassName.substring(positionOfLastPeriod + 1, aQualifiedClassName.length());
    }

    public static IStringBeanProxy invoke_getMessage(IBeanProxy anExceptionProxy) {
        IMethodProxy getMessageMethodProxy = anExceptionProxy.getTypeProxy().getMethodProxy("getMessage");
        try {
            IStringBeanProxy messageProxy = (IStringBeanProxy)getMessageMethodProxy.invoke(anExceptionProxy);
            return messageProxy;
        }
        catch (ThrowableProxy throwableProxy) {
            return null;
        }
    }

    public static IBeanProxy invoke(IBeanProxy aReceiver, String aMessageName) {
        IMethodProxy aMethodProxy = aReceiver.getTypeProxy().getMethodProxy(aMessageName);
        try {
            return aMethodProxy.invoke(aReceiver);
        }
        catch (ThrowableProxy exc) {
            if (JavaVEPlugin.isLoggingLevel(Level.WARNING)) {
                JavaVEPlugin.log("Error invoking " + aMessageName, Level.WARNING);
                JavaVEPlugin.log(exc, Level.WARNING);
            }
            return null;
        }
    }

    public static class JavaSettingsEList
    extends CDEUtilities.ESettingsEList {
        public JavaSettingsEList(EObject eObject, boolean shared) {
            super(eObject, shared);
        }

        public JavaSettingsEList(EObject eObject, EStructuralFeature[] eStructuralFeatures, boolean shared) {
            super(eObject, eStructuralFeatures, shared);
        }

        public List basicList() {
            return new JavaSettingsEList(this, this.eObject, this.eStructuralFeatures, this.shared){
                final /* synthetic */ JavaSettingsEList this$1;
                {
                    this.this$1 = javaSettingsEList;
                }

                protected boolean resolve() {
                    return false;
                }
            };
        }

        protected boolean isIncluded(EStructuralFeature eStructuralFeature) {
            return eStructuralFeature.getEType() instanceof JavaHelpers && super.isIncluded(eStructuralFeature);
        }
    }
}

