/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.commands.Command;
import org.eclipse.jem.internal.instantiation.InstantiationFactory;
import org.eclipse.jem.internal.instantiation.JavaAllocation;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ve.internal.cde.core.AnnotationPolicy;
import org.eclipse.ve.internal.cde.core.CDEUtilities;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.VisualInfoPolicy;
import org.eclipse.ve.internal.cde.emf.ClassDescriptorDecoratorPolicy;
import org.eclipse.ve.internal.cde.emf.InverseMaintenanceAdapter;
import org.eclipse.ve.internal.cdm.Annotation;
import org.eclipse.ve.internal.cdm.AnnotationEMF;
import org.eclipse.ve.internal.cdm.CDMFactory;
import org.eclipse.ve.internal.cdm.CDMPackage;
import org.eclipse.ve.internal.cdm.Diagram;
import org.eclipse.ve.internal.cdm.DiagramData;
import org.eclipse.ve.internal.cdm.VisualInfo;
import org.eclipse.ve.internal.cdm.impl.KeyedBooleanImpl;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.jcm.BeanSubclassComposition;
import org.eclipse.ve.internal.jcm.JCMMethod;
import org.eclipse.ve.internal.jcm.JCMPackage;

public class BeanUtilities {
    private static final String lineSep = System.getProperties().getProperty("line.separator");
    private static final Pattern NEEDS_ESCAPES = Pattern.compile("(.*\b|\t|\r|\n|\"|'|\\\\)*.*", 32);

    public static IJavaInstance createJavaObject(String qualifiedClassName, ResourceSet aResourceSet, String initString) {
        return BeanUtilities.createJavaObject(JavaRefFactory.eINSTANCE.reflectType(qualifiedClassName, aResourceSet), aResourceSet, initString != null ? InstantiationFactory.eINSTANCE.createInitStringAllocation(initString) : null);
    }

    public static IJavaInstance createJavaObject(String qualifiedClassName, ResourceSet aResourceSet, JavaAllocation allocation) {
        return BeanUtilities.createJavaObject(JavaRefFactory.eINSTANCE.reflectType(qualifiedClassName, aResourceSet), aResourceSet, allocation);
    }

    public static IJavaInstance createJavaObject(JavaHelpers javaHelpers, ResourceSet aResourceSet, String initString) {
        return BeanUtilities.createJavaObject(javaHelpers, aResourceSet, initString != null ? InstantiationFactory.eINSTANCE.createInitStringAllocation(initString) : null);
    }

    public static IJavaInstance createJavaObject(JavaHelpers javaHelpers, ResourceSet aResourceSet, JavaAllocation allocation) {
        IJavaInstance result = null;
        result = (IJavaInstance)javaHelpers.getEPackage().getEFactoryInstance().create((EClass)javaHelpers);
        result.setAllocation(allocation);
        if (aResourceSet != null) {
            BeanProxyUtilities.getBeanProxyHost(result, aResourceSet);
        }
        return result;
    }

    public static IJavaObjectInstance createString(ResourceSet aResourceSet, String unquotedInitializationString) {
        return (IJavaObjectInstance)BeanUtilities.createJavaObject("java.lang.String", aResourceSet, BeanUtilities.createStringInitString(unquotedInitializationString));
    }

    public static String createStringInitString(String value) {
        return BeanUtilities.createQuotedInitString(value, true);
    }

    public static String createCharacterInitString(char value) {
        return BeanUtilities.createQuotedInitString(String.valueOf(value), false);
    }

    protected static String createQuotedInitString(String value, boolean isString) {
        StringBuffer sb = new StringBuffer(value.length() + 2);
        sb.append(isString ? (char)'\"' : '\'');
        int sl = value.length();
        int i = 0;
        while (i < sl) {
            block18: {
                char c;
                block16: {
                    block17: {
                        c = value.charAt(i);
                        if (c != lineSep.charAt(0)) break block16;
                        if (lineSep.length() <= 1) break block17;
                        if (i + 1 >= sl || lineSep.charAt(1) != value.charAt(i + 1)) break block16;
                        ++i;
                        sb.append("\\n");
                        break block18;
                    }
                    sb.append("\\n");
                    break block18;
                }
                block0 : switch (c) {
                    case '\b': {
                        sb.append("\\b");
                        break;
                    }
                    case '\t': {
                        sb.append("\\t");
                        break;
                    }
                    case '\n': {
                        sb.append("\\n");
                        break;
                    }
                    case '\r': {
                        sb.append("\\r");
                        break;
                    }
                    case '\"': {
                        if (isString) {
                            sb.append("\\\"");
                            break;
                        }
                        sb.append('\"');
                        break;
                    }
                    case '\'': {
                        if (!isString) {
                            sb.append("\\'");
                            break;
                        }
                        sb.append('\'');
                        break;
                    }
                    default: {
                        if (c == '\\') {
                            if (i + 1 < sl) {
                                char nextChar = value.charAt(i + 1);
                                switch (nextChar) {
                                    case '\"': 
                                    case '\'': 
                                    case '\\': 
                                    case 'b': 
                                    case 'n': 
                                    case 'r': 
                                    case 't': 
                                    case 'u': {
                                        sb.append('\\');
                                        sb.append(nextChar);
                                        ++i;
                                        break block0;
                                    }
                                }
                                sb.append("\\\\");
                                break;
                            }
                            sb.append('\\');
                        }
                        sb.append(c);
                    }
                }
            }
            ++i;
        }
        sb.append(isString ? (char)'\"' : '\'');
        return sb.toString();
    }

    public static String getEscapedString(String value) {
        if (value != null && NEEDS_ESCAPES.matcher(value).matches()) {
            StringBuffer sb = new StringBuffer(value.length());
            int sl = value.length();
            boolean multiCharSep = lineSep.length() > 1;
            int i = 0;
            while (i < sl) {
                char c = value.charAt(i);
                if (multiCharSep && c == lineSep.charAt(0) && i + 1 < sl && lineSep.charAt(1) == value.charAt(i + 1)) {
                    ++i;
                    sb.append("\\n");
                } else {
                    switch (c) {
                        case '\b': {
                            sb.append("\\b");
                            break;
                        }
                        case '\t': {
                            sb.append("\\t");
                            break;
                        }
                        case '\n': {
                            sb.append("\\n");
                            break;
                        }
                        case '\r': {
                            sb.append("\\r");
                            break;
                        }
                        case '\\': {
                            sb.append("\\\\");
                            break;
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                }
                ++i;
            }
            return sb.toString();
        }
        return value;
    }

    public static void setBeanName(IJavaInstance newJavaBean, String name) {
        CDMFactory fact = CDMFactory.eINSTANCE;
        AnnotationEMF an = fact.createAnnotationEMF();
        if (an != null) {
            EStringToStringMapEntryImpl sentry = (EStringToStringMapEntryImpl)EcoreFactory.eINSTANCE.create(EcorePackage.eINSTANCE.getEStringToStringMapEntry());
            sentry.setKey((Object)"org.eclipse.ve.internal.cde.core.nameincomposition");
            sentry.setValue((Object)name);
            CDEUtilities.putEMapEntry((EMap)an.getKeyedValues(), (Map.Entry)sentry);
            an.setAnnotates((EObject)newJavaBean);
        }
    }

    public static String getBeanName(IJavaInstance javaBean, EditDomain anEditDomain) {
        BasicEMap.Entry keyValue;
        Annotation annotation = anEditDomain.getAnnotationLinkagePolicy().getAnnotation((Object)javaBean);
        if (annotation != null && (keyValue = BeanUtilities.getMapEntry(annotation, "org.eclipse.ve.internal.cde.core.nameincomposition")) != null) {
            return (String)keyValue.getValue();
        }
        return null;
    }

    public static BasicEMap.Entry getMapEntry(Annotation annotation, Object key) {
        int keyPos = annotation.getKeyedValues().indexOfKey(key);
        return keyPos != -1 ? (BasicEMap.Entry)annotation.getKeyedValues().get(keyPos) : null;
    }

    public static Command getSetBeanNameCommand(IJavaInstance newJavaBean, String name, EditDomain domain) {
        BasicEMap.Entry oldkv;
        Annotation annotation = domain.getAnnotationLinkagePolicy().getAnnotation((Object)newJavaBean);
        if (annotation != null && (oldkv = BeanUtilities.getMapEntry(annotation, "org.eclipse.ve.internal.cde.core.nameincomposition")) != null && name.equals(oldkv.getValue())) {
            return null;
        }
        EStringToStringMapEntryImpl sentry = (EStringToStringMapEntryImpl)EcoreFactory.eINSTANCE.create(EcorePackage.eINSTANCE.getEStringToStringMapEntry());
        sentry.setKey((Object)"org.eclipse.ve.internal.cde.core.nameincomposition");
        sentry.setValue((Object)name);
        return AnnotationPolicy.applyAnnotationSetting((Object)newJavaBean, (BasicEMap.Entry)sentry, (EditDomain)domain);
    }

    public static void setEmptyVisualContraints(IJavaInstance newJavaBean, EditDomain ed, boolean hideFF) {
        AnnotationEMF an;
        CDMFactory fact = CDMFactory.eINSTANCE;
        AnnotationEMF.ParentAdapter a = (AnnotationEMF.ParentAdapter)EcoreUtil.getExistingAdapter((Notifier)newJavaBean, (Object)AnnotationEMF.ParentAdapter.PARENT_ANNOTATION_ADAPTER_KEY);
        AnnotationEMF annotationEMF = an = a != null ? (AnnotationEMF)a.getParentAnnotation() : null;
        if (an == null) {
            an = fact.createAnnotationEMF();
            an.setAnnotates((EObject)newJavaBean);
        }
        Diagram d = null;
        int i = 0;
        while (i < ed.getDiagramData().getDiagrams().size()) {
            Diagram di = (Diagram)ed.getDiagramData().getDiagrams().get(i);
            if ("org.eclipse.ve.internal.cdm.primarydiagram".equals(di.getId())) {
                d = di;
                break;
            }
            ++i;
        }
        KeyedBooleanImpl key = (KeyedBooleanImpl)CDMFactory.eINSTANCE.create(CDMPackage.eINSTANCE.getKeyedBoolean());
        if (hideFF) {
            key.setValue((Object)Boolean.TRUE);
        } else {
            key.setValue((Object)Boolean.FALSE);
        }
        key.setKey((Object)"org.eclipse.ve.internal.cdm.model.visualconstraintkey");
        VisualInfo vi = an.getVisualInfo(d);
        if (vi == null) {
            vi = CDMFactory.eINSTANCE.createVisualInfo();
            vi.setDiagram(d);
        }
        if (vi.getKeyedValues().containsKey((Object)"org.eclipse.ve.internal.cdm.model.visualconstraintkey")) {
            vi.getKeyedValues().removeKey((Object)"org.eclipse.ve.internal.cdm.model.visualconstraintkey");
        }
        vi.getKeyedValues().add((Object)key);
        an.getVisualInfos().add((Object)vi);
    }

    public static Command getSetEmptyVisualContraintsCommand(IJavaInstance newJavaBean, boolean hideFF, EditDomain domain) {
        KeyedBooleanImpl key = (KeyedBooleanImpl)CDMFactory.eINSTANCE.create(CDMPackage.eINSTANCE.getKeyedBoolean());
        key.setKey((Object)"org.eclipse.ve.internal.cdm.model.visualconstraintkey");
        if (hideFF) {
            key.setValue((Object)Boolean.TRUE);
        } else {
            key.setValue((Object)Boolean.FALSE);
        }
        Diagram d = null;
        int i = 0;
        while (i < domain.getDiagramData().getDiagrams().size()) {
            Diagram di = (Diagram)domain.getDiagramData().getDiagrams().get(i);
            if ("org.eclipse.ve.internal.cdm.primarydiagram".equals(di.getId())) {
                d = di;
                break;
            }
            ++i;
        }
        return VisualInfoPolicy.applyVisualInfoSetting((Object)newJavaBean, (Object)key, (EditDomain)domain, d);
    }

    public static boolean isThisPart(IJavaObjectInstance aBean) {
        EReference containerSF = aBean.eContainmentFeature();
        return containerSF.getName().equals("thisPart");
    }

    public static IJavaInstance getFeatureValue(IJavaInstance javaObject, String featureName) {
        EStructuralFeature feature = javaObject.eClass().getEStructuralFeature(featureName);
        if (feature == null) {
            return null;
        }
        return BeanUtilities.getFeatureValue(javaObject, feature);
    }

    public static IJavaInstance getFeatureValue(IJavaInstance javaObject, EStructuralFeature feature) {
        Object featureValue = javaObject.eGet(feature);
        if (featureValue != null) {
            return (IJavaInstance)featureValue;
        }
        IBeanProxyHost beanProxyHost = BeanProxyUtilities.getBeanProxyHost(javaObject);
        if (!beanProxyHost.isBeanProxyInstantiated()) {
            beanProxyHost.instantiateBeanProxy();
        }
        return beanProxyHost.getBeanPropertyValue(feature);
    }

    public static String getLabel(IJavaInstance component, EditDomain editDomain) {
        ILabelProvider labelProvider = ClassDescriptorDecoratorPolicy.getPolicy((EditDomain)editDomain).getLabelProvider((EClassifier)component.eClass());
        if (labelProvider != null) {
            return labelProvider.getText((Object)component);
        }
        return BeanProxyUtilities.getBeanProxy(component).toBeanString();
    }

    public static boolean isValidBeanLocation(EditDomain domain, EObject childComponent) {
        EObject cRef;
        BeanSubclassComposition beanComposition;
        DiagramData bcm = domain.getDiagramData();
        return bcm instanceof BeanSubclassComposition && (beanComposition = (BeanSubclassComposition)bcm).getMembers().indexOf((Object)childComponent) != -1 && (cRef = InverseMaintenanceAdapter.getFirstReferencedBy((Notifier)childComponent, (EReference)JCMPackage.eINSTANCE.getJCMMethod_Initializes())) != null && cRef instanceof JCMMethod && ((JCMMethod)cRef).getReturn() == childComponent;
    }
}

