/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.core.IJavaCellEditor;
import org.eclipse.ve.internal.java.core.JavaEditDomainHelper;
import org.eclipse.ve.internal.propertysheet.BooleanCellEditor;
import org.eclipse.ve.internal.propertysheet.INeedData;
import org.eclipse.ve.internal.propertysheet.PropertysheetMessages;

public class BooleanJavaCellEditor
extends BooleanCellEditor
implements IExecutableExtension,
INeedData,
IJavaCellEditor {
    protected EditDomain fEditDomain;
    protected boolean fIsBooleanClass;
    protected JavaHelpers fBooleanHelper;

    public BooleanJavaCellEditor(Composite parent) {
        super(parent);
    }

    public void setInitializationData(IConfigurationElement ce, String pName, Object initData) {
        this.fIsBooleanClass = initData instanceof String && "class".equalsIgnoreCase((String)initData);
    }

    public void setData(Object data) {
        this.fEditDomain = (EditDomain)data;
        this.fBooleanHelper = !this.fIsBooleanClass ? JavaRefFactory.eINSTANCE.reflectType("boolean", JavaEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain)) : JavaRefFactory.eINSTANCE.reflectType("java.lang.Boolean", JavaEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain));
    }

    protected String isCorrectObject(Object value) {
        if (value == null) {
            if (!this.fIsBooleanClass) {
                return PropertysheetMessages.null_invalid_WARN_;
            }
            return null;
        }
        if (this.fBooleanHelper.isInstance(value)) {
            return null;
        }
        return PropertysheetMessages.bad_bool_WARN_;
    }

    public String getJavaInitializationString() {
        return this.getJavaInitializationString(this.getSelectionIndex());
    }

    private String getJavaInitializationString(int index) {
        if (this.fIsBooleanClass) {
            if (index == 0) {
                return "Boolean.TRUE";
            }
            return "Boolean.FALSE";
        }
        if (index == 0) {
            return "true";
        }
        return "false";
    }

    protected int doGetIndex(Object value) {
        if (this.fBooleanHelper.isInstance(value)) {
            return ((IBooleanBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)value, JavaEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain))).booleanValue() ? 0 : 1;
        }
        return -1;
    }

    protected Object doGetObject(int index) {
        switch (index) {
            case -1: {
                return null;
            }
            case 0: 
            case 1: {
                return BeanUtilities.createJavaObject(this.fBooleanHelper, JavaEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain), this.getJavaInitializationString(index));
            }
        }
        return null;
    }
}

