/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ve.internal.cde.core.AnnotationLinkagePolicy;
import org.eclipse.ve.internal.cde.core.CDEMessages;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.properties.NameInCompositionPropertyDescriptor;
import org.eclipse.ve.internal.cdm.Annotation;
import org.eclipse.ve.internal.cdm.AnnotationEMF;
import org.eclipse.ve.internal.java.core.AbstractRenameInstanceDialog;
import org.eclipse.ve.internal.java.core.JavaMessages;
import org.eclipse.ve.internal.java.vce.VCEPreferences;
import org.eclipse.ve.internal.jcm.MemberContainer;

public class NameInMemberPropertyDescriptor
extends NameInCompositionPropertyDescriptor {
    public NameInMemberPropertyDescriptor() {
    }

    public NameInMemberPropertyDescriptor(String displayNameToUse) {
        super(displayNameToUse);
    }

    public NameInMemberPropertyDescriptor(String displayNameToUse, ICellEditorValidator additionalValidator) {
        super(displayNameToUse, additionalValidator);
    }

    protected NameInCompositionPropertyDescriptor.NameValidator getNameValidator() {
        return new MemberBasedNameValidator();
    }

    public static String getUniqueNameInMember(EditDomain domain, MemberContainer container, String name) {
        return NameInMemberPropertyDescriptor.getUniqueNameInMember(domain, container, name, null);
    }

    public static String getUniqueNameInMember(EditDomain domain, MemberContainer container, String name, Set otherNames) {
        AnnotationLinkagePolicy policy = domain.getAnnotationLinkagePolicy();
        String baseName = null;
        baseName = name != null ? name : CDEMessages.PropertyDescriptor_NameInComposition_Default;
        String componentName = baseName;
        int incr = 0;
        block0: while (true) {
            if (otherNames != null && otherNames.contains(componentName)) {
                componentName = String.valueOf(baseName) + ++incr;
                continue;
            }
            Iterator itr = container.getMembers().iterator();
            while (itr.hasNext()) {
                BasicEMap.Entry ks;
                Annotation an = policy.getAnnotation(itr.next());
                if (an == null || (ks = NameInMemberPropertyDescriptor.getMapEntry((Annotation)an, (Object)"org.eclipse.ve.internal.cde.core.nameincomposition")) == null || !componentName.equals(ks.getValue())) continue;
                componentName = String.valueOf(baseName) + ++incr;
                continue block0;
            }
            break;
        }
        return componentName;
    }

    public String[] getUniqueNamesInComposition(EditDomain domain, String[] names, Annotation[] annotations) {
        String[] uniques = super.getUniqueNamesInComposition(domain, names, annotations);
        if (VCEPreferences.askForRename()) {
            EObject[] annotates = new EObject[annotations.length];
            int i = 0;
            while (i < annotations.length) {
                if (annotations[i] instanceof AnnotationEMF) {
                    AnnotationEMF annotationEMF = (AnnotationEMF)annotations[i];
                    annotates[i] = annotationEMF.getAnnotates();
                } else {
                    annotates[i] = null;
                }
                ++i;
            }
            NameChangeDialog dialog = new NameChangeDialog(domain.getEditorPart().getSite().getShell(), uniques, annotates, domain, false, true);
            if (dialog.open() == 0) {
                uniques = dialog.getFinalNames();
            }
        }
        return uniques;
    }

    public class NameChangeDialog
    extends AbstractRenameInstanceDialog {
        public NameChangeDialog(Shell parentShell, String[] names, EObject[] annotates, EditDomain domain, boolean forceChange, boolean enableDontShowOption) {
            super(parentShell, names, annotates, domain, forceChange, enableDontShowOption);
        }

        protected String getValidInstanceVariableName(EObject instance, String name, List currentNames) {
            return NameInMemberPropertyDescriptor.getUniqueNameInComposition((EditDomain)this.domain, (String)name, new HashSet(currentNames));
        }

        protected Control createDialogArea(Composite parent) {
            this.setTitle(JavaMessages.NameInMemberPropertyDescriptor_NameChangeDialog_Dialog_Title);
            this.setMessage(JavaMessages.NameInMemberPropertyDescriptor_NameChangeDialog_Dialog_Message);
            return super.createDialogArea(parent);
        }

        protected void configureShell(Shell newShell) {
            newShell.setText(JavaMessages.NameInMemberPropertyDescriptor_NameChangeDialog_Shell_Title);
            super.configureShell(newShell);
        }
    }

    public static class MemberBasedNameValidator
    extends NameInCompositionPropertyDescriptor.NameValidator {
        protected String getSuggestedName(String name) {
            Object source = this.pos[0].getEditableValue();
            if (!(source instanceof EObject)) {
                return super.getSuggestedName(name);
            }
            EObject container = ((EObject)source).eContainer();
            if (!(container instanceof MemberContainer)) {
                return super.getSuggestedName(name);
            }
            return NameInMemberPropertyDescriptor.getUniqueNameInMember(this.domain, (MemberContainer)container, name);
        }
    }
}

