/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.proxy.core.INumberBeanProxy;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.core.IJavaCellEditor;
import org.eclipse.ve.internal.java.core.JavaEditDomainHelper;
import org.eclipse.ve.internal.propertysheet.INeedData;
import org.eclipse.ve.internal.propertysheet.NumberCellEditor;
import org.eclipse.ve.internal.propertysheet.PropertysheetMessages;

public class NumberJavaCellEditor
extends NumberCellEditor
implements INeedData,
IJavaCellEditor {
    protected JavaHelpers fNumberClassType;
    protected String fInitializationString;
    protected EditDomain fEditDomain;
    protected String fTypeName;

    public NumberJavaCellEditor(Composite aComposite) {
        super(aComposite);
    }

    public void setInitializationData(IConfigurationElement ce, String pName, Object initData) {
        this.fTypeName = initData instanceof String ? (String)initData : "void";
        if (this.fTypeName.equals("java.lang.Integer")) {
            this.fInitializationString = "new java.lang.Integer({0})";
            super.setInitializationData(null, null, (Object)"integer");
        } else if (this.fTypeName.equals("int")) {
            this.fInitializationString = "{0}";
            super.setInitializationData(null, null, (Object)"integer");
        } else if (this.fTypeName.equals("short")) {
            this.fInitializationString = "(short) {0}";
            super.setInitializationData(null, null, (Object)"short");
        } else if (this.fTypeName.equals("java.lang.Short")) {
            this.fInitializationString = "new Short((short) {0})";
            super.setInitializationData(null, null, (Object)"short");
        } else if (this.fTypeName.equals("long")) {
            this.fInitializationString = "{0}L";
            super.setInitializationData(null, null, (Object)"long");
        } else if (this.fTypeName.equals("java.lang.Long")) {
            this.fInitializationString = "new java.lang.Long({0}L)";
            super.setInitializationData(null, null, (Object)"long");
        } else if (this.fTypeName.equals("byte")) {
            this.fInitializationString = "(byte) {0}";
            super.setInitializationData(null, null, (Object)"byte");
        } else if (this.fTypeName.equals("java.lang.Byte")) {
            this.fInitializationString = "new Byte((byte) {0})";
            super.setInitializationData(null, null, (Object)"byte");
        } else if (this.fTypeName.equals("java.lang.Float")) {
            this.fInitializationString = "new java.lang.Float({0}F)";
            super.setInitializationData(null, null, (Object)"float");
        } else if (this.fTypeName.equals("float")) {
            this.fInitializationString = "{0}F";
            super.setInitializationData(null, null, (Object)"float");
        } else if (this.fTypeName.equals("double")) {
            this.fInitializationString = "{0}D";
            super.setInitializationData(null, null, (Object)"double");
        } else if (this.fTypeName.equals("java.lang.Double")) {
            this.fInitializationString = "new java.lang.Double({0}D)";
            super.setInitializationData(null, null, (Object)"double");
        }
    }

    public void setData(Object data) {
        this.fEditDomain = (EditDomain)data;
        this.fNumberClassType = JavaRefFactory.eINSTANCE.reflectType(this.fTypeName, JavaEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain));
    }

    protected Object doGetObject(String value) {
        Number newNumber = (Number)super.doGetObject(value);
        return newNumber != null ? BeanUtilities.createJavaObject(this.fNumberClassType, JavaEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain), this.getJavaInitializationString(newNumber)) : null;
    }

    protected String doGetString(Object value) {
        if (this.fNumberClassType.isInstance(value)) {
            return super.doGetString((Object)((INumberBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)value, JavaEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain))).numberValue());
        }
        return null;
    }

    protected String isCorrectObject(Object value) {
        if (value == null) {
            if (this.fNumberClassType.isPrimitive()) {
                return PropertysheetMessages.null_invalid_WARN_;
            }
            return super.isCorrectObject(null);
        }
        if (this.fNumberClassType.isInstance(value)) {
            return super.isCorrectObject((Object)((INumberBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)value, JavaEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain))).numberValue());
        }
        return this.fFormatter.isParseIntegerOnly() ? sNotIntegerError : sNotNumberError;
    }

    public String getJavaInitializationString() {
        if (this.isValueValid()) {
            Object value = this.getSetValue();
            return value != null ? this.getJavaInitializationString(((INumberBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)value, JavaEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain))).numberValue()) : null;
        }
        return null;
    }

    protected String getJavaInitializationString(Number aNumber) {
        if (this.fNumberClassType.isPrimitive()) {
            switch (this.fNumberType) {
                case 1: {
                    if (aNumber.byteValue() == -128) {
                        return "Byte.MIN_VALUE";
                    }
                    if (aNumber.byteValue() != 127) break;
                    return "Byte.MAX_VALUE";
                }
                case 2: {
                    if (aNumber.doubleValue() == Double.MIN_VALUE) {
                        return "Double.MIN_VALUE";
                    }
                    if (aNumber.doubleValue() != Double.MAX_VALUE) break;
                    return "Double.MAX_VALUE";
                }
                case 3: {
                    if (aNumber.floatValue() == Float.MIN_VALUE) {
                        return "Float.MIN_VALUE";
                    }
                    if (aNumber.floatValue() != Float.MAX_VALUE) break;
                    return "Float.MAX_VALUE";
                }
                case 4: {
                    if (aNumber.intValue() == Integer.MIN_VALUE) {
                        return "Integer.MIN_VALUE";
                    }
                    if (aNumber.intValue() != Integer.MAX_VALUE) break;
                    return "Integer.MAX_VALUE";
                }
                case 5: {
                    if (aNumber.longValue() == Long.MIN_VALUE) {
                        return "Long.MIN_VALUE";
                    }
                    if (aNumber.longValue() != Long.MAX_VALUE) break;
                    return "Long.MAX_VALUE";
                }
                case 6: {
                    if (aNumber.shortValue() == Short.MIN_VALUE) {
                        return "Short.MIN_VALUE";
                    }
                    if (aNumber.shortValue() != Short.MAX_VALUE) break;
                    return "Short.MAX_VALUE";
                }
            }
        }
        return MessageFormat.format(this.fInitializationString, aNumber.toString());
    }
}

