/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Text;

public class NumberTextVerifier
implements VerifyListener {
    private int newValue;
    private int defaultValue = 0;
    private int min = Integer.MIN_VALUE;
    private int max = Integer.MAX_VALUE;

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(int defaultValue) {
        if (defaultValue < this.min || defaultValue > this.max) {
            return;
        }
        this.defaultValue = defaultValue;
    }

    public int getNewValue() {
        return this.newValue;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
        if (this.defaultValue > max) {
            this.defaultValue = max;
        }
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
        if (this.defaultValue < min) {
            this.defaultValue = min;
        }
    }

    public void verifyText(VerifyEvent e) {
        if (e.widget instanceof Text) {
            StringBuffer textbuf = new StringBuffer(((Text)e.widget).getText());
            textbuf.replace(e.start, e.end, e.text);
            if (textbuf.length() == 0 || this.min < 0 && textbuf.toString().equals("-")) {
                this.newValue = this.defaultValue;
                return;
            }
            try {
                int value = Integer.parseInt(textbuf.toString());
                if (value < this.min || value > this.max) {
                    e.doit = false;
                }
                this.newValue = value;
            }
            catch (NumberFormatException numberFormatException) {
                e.doit = false;
            }
        }
    }
}

