/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.CreationTool;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.EMFPrototypeCreationFactory;
import org.eclipse.ve.internal.cdm.DiagramData;

public class PasteJavaBeanAction
extends SelectionAction {
    private CreationTool creationTool;
    private EditDomain editDomain;
    public boolean executeImmediately = false;

    public PasteJavaBeanAction(IWorkbenchPart part, EditDomain anEditDomain) {
        super(part);
        this.setId(ActionFactory.PASTE.getId());
        this.editDomain = anEditDomain;
    }

    protected boolean calculateEnabled() {
        if (this.executeImmediately) {
            if (this.getSelectedObjects().size() != 1) {
                return false;
            }
            CreationFactory factory = this.getFactory();
            if (factory != null) {
                CreateRequest request = new CreateRequest();
                request.setFactory(factory);
                request.setLocation(this.getPasteLocation());
                EditPart editPart = (EditPart)this.getSelectedObjects().get(0);
                Command command = editPart.getCommand((Request)request);
                return command != null && command.canExecute();
            }
            return false;
        }
        return this.getClipboardContents() != null;
    }

    private CreationFactory getFactory() {
        List selection = this.getSelectedObjects();
        if (selection == null || selection.size() != 1) {
            return null;
        }
        String template = this.getClipboardContents();
        if (template == null) {
            return null;
        }
        return this.getFactory(template);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CreationFactory getFactory(Object template) {
        EMFPrototypeCreationFactory eMFPrototypeCreationFactory;
        DiagramData root = this.editDomain.getDiagramData();
        ResourceSet targetResourceSet = root.eResource().getResourceSet();
        Resource clipboardResource = targetResourceSet.createResource(root.eResource().getURI().appendSegment(":" + System.currentTimeMillis()));
        ByteArrayInputStream is = new ByteArrayInputStream(this.getClipboardContents().getBytes());
        try {
            try {
                clipboardResource.load((InputStream)is, null);
                eMFPrototypeCreationFactory = new EMFPrototypeCreationFactory("/0", clipboardResource);
                Object var6_8 = null;
            }
            catch (Exception exception) {
                CreationFactory creationFactory = null;
                Object var6_9 = null;
                targetResourceSet.getResources().remove((Object)clipboardResource);
                return creationFactory;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            targetResourceSet.getResources().remove((Object)clipboardResource);
            throw throwable;
        }
        targetResourceSet.getResources().remove((Object)clipboardResource);
        return eMFPrototypeCreationFactory;
    }

    protected String getClipboardContents() {
        Object result = null;
        Clipboard cb = new Clipboard(Display.getDefault());
        TransferData[] transferTypes = cb.getAvailableTypes();
        int i = 0;
        while (i < transferTypes.length) {
            if (TextTransfer.getInstance().isSupportedType(transferTypes[i])) {
                result = cb.getContents((Transfer)TextTransfer.getInstance());
                break;
            }
            ++i;
        }
        cb.dispose();
        String clipboardContents = (String)result;
        if (clipboardContents != null && clipboardContents.startsWith("{ *** VE HEADER ***}")) {
            clipboardContents = clipboardContents.substring("{ *** VE HEADER ***}".length());
            return clipboardContents;
        }
        return null;
    }

    protected Point getPasteLocation() {
        return new Point(10, 10);
    }

    public void run() {
        this.creationTool = null;
        CreationFactory factory = this.getFactory();
        if (factory != null) {
            CreateRequest request = new CreateRequest();
            request.setFactory(factory);
            request.setLocation(this.getPasteLocation());
            if (this.executeImmediately) {
                EditPart editPart = (EditPart)this.getSelectedObjects().get(0);
                Command command = editPart.getCommand((Request)request);
                this.editDomain.getCommandStack().execute(command);
            } else {
                this.creationTool = new CreationTool(factory);
                this.editDomain.setActiveTool((Tool)this.creationTool);
            }
        }
    }
}

