/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.osgi.framework.Bundle;

class RegisteredClasspathContainer
implements IClasspathContainer {
    private IPath containerpath;
    private String description;
    private IClasspathEntry[] classpath;

    public RegisteredClasspathContainer(IPath containerpath) {
        this.containerpath = containerpath;
        String containerid = containerpath.segment(0);
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(JavaVEPlugin.getPlugin().getBundle().getSymbolicName(), "registrations");
        int i = 0;
        while (i < configs.length) {
            String ctrid = configs[i].getAttributeAsIs("container");
            if (containerid.equals(ctrid)) {
                this.description = configs[i].getAttribute("description");
                if (this.description == null) {
                    this.description = containerid;
                }
                IConfigurationElement[] libraries = configs[i].getChildren("library");
                ArrayList<IClasspathEntry> libs = new ArrayList<IClasspathEntry>(libraries.length);
                int j = 0;
                while (j < libraries.length) {
                    String lib = libraries[j].getAttributeAsIs("runtime");
                    IPath libpath = this.getPath(lib, libraries[j]);
                    if (libpath != null) {
                        String src = libraries[j].getAttributeAsIs("source");
                        IPath srcpath = this.getPath(src, libraries[j]);
                        String prefix = libraries[j].getAttributeAsIs("prefix");
                        Path srcattachpath = prefix != null ? new Path(prefix) : null;
                        libs.add(JavaCore.newLibraryEntry((IPath)libpath, (IPath)srcpath, (IPath)srcattachpath));
                    }
                    ++j;
                }
                this.classpath = libs.toArray(new IClasspathEntry[libs.size()]);
                break;
            }
            ++i;
        }
    }

    private IPath getPath(String lib, IConfigurationElement ce) {
        if (lib == null || lib.length() == 0) {
            return null;
        }
        Bundle bundle = null;
        Path libpath = null;
        if (lib.charAt(0) != '/') {
            bundle = Platform.getBundle((String)ce.getDeclaringExtension().getNamespace());
            libpath = new Path(lib);
        } else {
            int pathNdx = lib.indexOf(47, 1);
            if (pathNdx == -1 || pathNdx >= lib.length()) {
                return null;
            }
            bundle = Platform.getBundle((String)lib.substring(0, pathNdx));
            if (bundle == null) {
                return null;
            }
            libpath = new Path(lib.substring(pathNdx + 1));
        }
        URL url = ProxyPlugin.getPlugin().urlLocalizeFromBundleOnly(bundle, (IPath)libpath);
        if (url != null) {
            return new Path(url.getFile());
        }
        return null;
    }

    public IClasspathEntry[] getClasspathEntries() {
        return this.classpath;
    }

    public String getDescription() {
        return this.description;
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.containerpath;
    }
}

