/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import java.util.Iterator;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Panel;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ve.internal.cde.core.IErrorHolder;
import org.eclipse.ve.internal.cde.core.IErrorNotifier;
import org.eclipse.ve.internal.java.core.IJavaToolTipProposalAdapter;
import org.eclipse.ve.internal.java.core.JavaMessages;
import org.eclipse.ve.internal.java.core.ToolTipAssistFactory;

public class ToolTipAssistFactory {
    static final NullTTAdapter fNullTTAdapter = new NullTTAdapter();

    private static IJavaToolTipProposalAdapter getToolTipAdapter(IJavaInstance javaInstance) {
        return (IJavaToolTipProposalAdapter)EcoreUtil.getExistingAdapter((Notifier)javaInstance, (Object)IJavaToolTipProposalAdapter.JAVA_ToolTip_Proposal_TYPE);
    }

    public static TooltipDetails[] createToolTipProcessors(IJavaInstance javaInstance, IErrorNotifier errorNotifier) {
        ErrorProcessor errorProcessor = new ErrorProcessor(errorNotifier);
        DefaultInstanceProcessor instanceProcessor = new DefaultInstanceProcessor(javaInstance);
        DefaultMethodProcessor methodProcessor = new DefaultMethodProcessor(javaInstance);
        return new TooltipDetails[]{errorProcessor, methodProcessor, instanceProcessor};
    }

    public static class LineFigure
    extends Figure {
        public LineFigure() {
            this.setPreferredSize(100, 2);
        }

        protected void paintFigure(Graphics g) {
            g.setLineStyle(3);
            g.setXORMode(true);
            g.setForegroundColor(ColorConstants.darkGray);
            if (this.bounds.width > this.bounds.height) {
                g.drawLine(this.bounds.x, this.bounds.y, this.bounds.right(), this.bounds.y);
                g.drawLine(this.bounds.x + 2, this.bounds.y, this.bounds.right(), this.bounds.y);
            } else {
                g.drawLine(this.bounds.x, this.bounds.y, this.bounds.x, this.bounds.bottom());
                g.drawLine(this.bounds.x, this.bounds.y + 2, this.bounds.x, this.bounds.bottom());
            }
        }
    }

    public static interface TooltipDetails {
        public IFigure createFigure();

        public void activate();

        public void deactivate();
    }

    static class NullTTAdapter
    implements IJavaToolTipProposalAdapter {
        static final Label l = new Label(JavaMessages.ToolTipAssistFactory_ToolTip_not_available_1);
        static final Label l2 = new Label();

        NullTTAdapter() {
        }

        public String getInitMethodName() {
            return null;
        }

        public Label getInstanceDisplayInformation() {
            return l;
        }

        public String getInstanceName() {
            return null;
        }

        public Label getReturnMethodDisplayInformation() {
            return l2;
        }
    }

    static class DefaultInstanceProcessor
    implements TooltipDetails {
        IJavaInstance javaInstance;
        IJavaToolTipProposalAdapter fTTadapter = null;

        public DefaultInstanceProcessor(IJavaInstance aJavaInstance) {
            this.javaInstance = aJavaInstance;
        }

        IJavaToolTipProposalAdapter getTTAdapter() {
            if (this.fTTadapter == null) {
                this.fTTadapter = ToolTipAssistFactory.getToolTipAdapter(this.javaInstance);
            }
            return this.fTTadapter != null ? this.fTTadapter : fNullTTAdapter;
        }

        public IFigure createFigure() {
            return this.getTTAdapter().getInstanceDisplayInformation();
        }

        public void activate() {
        }

        public void deactivate() {
        }
    }

    static class DefaultMethodProcessor
    implements TooltipDetails {
        IJavaInstance javaInstance;
        IJavaToolTipProposalAdapter fTTadapter = null;

        public DefaultMethodProcessor(IJavaInstance aJavaInstance) {
            this.javaInstance = aJavaInstance;
        }

        private IJavaToolTipProposalAdapter getTTAdapter() {
            if (this.fTTadapter == null) {
                this.fTTadapter = ToolTipAssistFactory.getToolTipAdapter(this.javaInstance);
            }
            return this.fTTadapter != null ? this.fTTadapter : fNullTTAdapter;
        }

        public IFigure createFigure() {
            return this.getTTAdapter().getReturnMethodDisplayInformation();
        }

        public void activate() {
        }

        public void deactivate() {
        }
    }

    static class ErrorProcessor
    implements TooltipDetails {
        private Figure figure;
        private IErrorNotifier errNotifier;
        private Display display;
        private IErrorNotifier.ErrorListener errorListener = new IErrorNotifier.ErrorListenerAdapter(this){
            final /* synthetic */ ErrorProcessor this$1;
            {
                this.this$1 = errorProcessor;
            }

            public void errorStatusChanged() {
                ErrorProcessor.access$0(this.this$1).asyncExec(new Runnable(this){
                    final /* synthetic */ 1 this$2;
                    {
                        this.this$2 = var1_1;
                    }

                    public void run() {
                        ErrorProcessor.access$1(1.access$0(this.this$2));
                    }
                });
            }

            static /* synthetic */ ErrorProcessor access$0(1 var0) {
                return var0.this$1;
            }
        };

        public ErrorProcessor(IErrorNotifier notifier) {
            this.errNotifier = notifier;
        }

        public IFigure createFigure() {
            this.display = Display.getCurrent();
            this.figure = new Panel();
            FlowLayout layout = new FlowLayout(false);
            layout.setMajorSpacing(0);
            layout.setMinorSpacing(0);
            this.figure.setLayoutManager((LayoutManager)layout);
            this.updateFigure();
            this.errNotifier.addErrorListener(this.errorListener);
            return this.figure;
        }

        private void updateFigure() {
            Iterator errors = this.errNotifier.getErrors().iterator();
            this.figure.removeAll();
            while (errors.hasNext()) {
                IErrorHolder.ErrorType error = (IErrorHolder.ErrorType)errors.next();
                Label l = new Label();
                l.setIcon(error.getImage());
                l.setText(error.getMessage());
                this.figure.add((IFigure)l);
            }
        }

        public void activate() {
            if (this.figure != null) {
                this.updateFigure();
                this.errNotifier.addErrorListener(this.errorListener);
            }
        }

        public void deactivate() {
            this.errNotifier.removeErrorListener(this.errorListener);
        }

        static /* synthetic */ Display access$0(ErrorProcessor errorProcessor) {
            return errorProcessor.display;
        }

        static /* synthetic */ void access$1(ErrorProcessor errorProcessor) {
            errorProcessor.updateFigure();
        }
    }

    public static class GetMethodErrorProcessor
    implements TooltipDetails {
        private IBeanProxy beanProxy;
        private String methodName;
        private IMethodProxy methodProxy;

        public GetMethodErrorProcessor(IBeanProxy aBeanProxy, String aMethodName) {
            this.beanProxy = aBeanProxy;
            this.methodName = aMethodName;
        }

        public IFigure createFigure() {
            Label label = new Label();
            if (this.beanProxy == null || !this.beanProxy.isValid()) {
                return null;
            }
            if (this.methodProxy == null) {
                this.methodProxy = this.beanProxy.getTypeProxy().getMethodProxy(this.methodName);
            }
            String errorMessage = null;
            try {
                this.methodProxy.invoke(this.beanProxy);
            }
            catch (ThrowableProxy e) {
                errorMessage = e.toBeanString();
            }
            if (errorMessage != null) {
                label.setIcon(IErrorHolder.ErrorType.getWarningErrorImage());
                label.setText(errorMessage);
                return label;
            }
            return null;
        }

        public void activate() {
        }

        public void deactivate() {
        }
    }
}

