/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.ClassDescriptorDecoratorPolicy;
import org.eclipse.ve.internal.java.choosebean.ChooseBeanDialog;
import org.eclipse.ve.internal.java.choosebean.IChooseBeanContributor;
import org.eclipse.ve.internal.java.choosebean.NamedTypeChooseBeanContributor;
import org.eclipse.ve.internal.java.core.BaseJavaContainerPolicy;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.jcm.BeanComposition;
import org.eclipse.ve.internal.jcm.JCMFactory;
import org.eclipse.ve.internal.propertysheet.INeedData;

public class TypeReferenceCellEditor
extends DialogCellEditor
implements INeedData,
IExecutableExtension {
    CCombo combo;
    private EditDomain editDomain;
    private JavaClass javaClass;
    protected BeanComposition beanComposition;
    protected List javaObjects;
    protected List javaObjectLabels;
    protected int selection = -1;
    private String[] items;

    public TypeReferenceCellEditor(Composite parent) {
        super(parent);
    }

    public TypeReferenceCellEditor(JavaHelpers javaType, Composite parent) {
        this(parent);
        this.javaClass = (JavaClass)javaType;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        ChooseBeanDialog chooseBean = new ChooseBeanDialog(cellEditorWindow.getShell(), this.editDomain, new IChooseBeanContributor[]{new NamedTypeChooseBeanContributor(this.javaClass.getQualifiedName(), this.javaClass.getJavaPackage().getPackageName(), this.javaClass.getName())}, -1, false);
        chooseBean.setFilter("**");
        if (chooseBean.open() == 0) {
            Object[] results = chooseBean.getResult();
            IJavaObjectInstance newJavaInstance = (IJavaObjectInstance)results[0];
            BaseJavaContainerPolicy editPolicy = new BaseJavaContainerPolicy((EStructuralFeature)JCMFactory.eINSTANCE.getJCMPackage().getBeanComposition_Components(), this.editDomain);
            editPolicy.setContainer(this.beanComposition);
            CompoundCommand createAndSetVisualCommand = new CompoundCommand("Create instance and set visual command");
            Command createCommand = editPolicy.getCreateCommand(newJavaInstance, null);
            createAndSetVisualCommand.add(createCommand);
            Command visualInfoCommand = BeanUtilities.getSetEmptyVisualContraintsCommand((IJavaInstance)newJavaInstance, false, this.editDomain);
            createAndSetVisualCommand.add(visualInfoCommand);
            this.editDomain.getCommandStack().execute((Command)createAndSetVisualCommand);
            return newJavaInstance;
        }
        return null;
    }

    protected Control createContents(Composite cell) {
        this.combo = new CCombo(cell, 0);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int newSelection = TypeReferenceCellEditor.this.combo.getSelectionIndex();
                if (newSelection == TypeReferenceCellEditor.this.selection) {
                    return;
                }
                TypeReferenceCellEditor.this.selection = newSelection;
                Object newValue = TypeReferenceCellEditor.this.javaObjects.get(TypeReferenceCellEditor.this.selection);
                boolean oldValidState = TypeReferenceCellEditor.this.isValueValid();
                boolean newValidState = TypeReferenceCellEditor.this.isCorrect(newValue);
                if (!newValidState) {
                    TypeReferenceCellEditor.this.setErrorMessage(MessageFormat.format(TypeReferenceCellEditor.this.getErrorMessage(), TypeReferenceCellEditor.this.items[TypeReferenceCellEditor.this.selection]));
                }
                TypeReferenceCellEditor.this.valueChanged(oldValidState, newValidState, newValue);
                TypeReferenceCellEditor.this.fireApplyEditorValue();
            }
        });
        return this.combo;
    }

    public boolean isActivated() {
        return this.combo.isVisible();
    }

    protected void valueChanged(boolean oldValidState, boolean newValidState, Object newValue) {
        super.valueChanged(oldValidState, newValidState);
        if (newValidState) {
            this.doSetValue(newValue);
        }
    }

    protected void updateContents(Object value) {
        if (this.combo != null && this.javaObjects != null) {
            this.combo.select(this.javaObjects.indexOf(value));
        }
    }

    public void setData(Object anObject) {
        this.editDomain = (EditDomain)anObject;
        this.beanComposition = (BeanComposition)this.editDomain.getDiagramData();
        this.javaObjects = new ArrayList();
        this.javaObjectLabels = new ArrayList();
        Iterator components = this.beanComposition.getMembers().iterator();
        while (components.hasNext()) {
            IJavaObjectInstance javaComponent;
            JavaHelpers componentType;
            Object component = components.next();
            if (!(component instanceof IJavaObjectInstance) || !this.javaClass.isAssignableFrom((EClassifier)(componentType = (javaComponent = (IJavaObjectInstance)component).getJavaType()))) continue;
            this.javaObjects.add(component);
            ILabelProvider labelProvider = ClassDescriptorDecoratorPolicy.getPolicy((EditDomain)this.editDomain).getLabelProvider((EClassifier)componentType);
            if (labelProvider != null) {
                this.javaObjectLabels.add(labelProvider.getText(component));
                continue;
            }
            this.javaObjectLabels.add(BeanProxyUtilities.getBeanProxy((IJavaInstance)javaComponent).toBeanString());
        }
        this.items = new String[this.javaObjectLabels.size()];
        System.arraycopy(this.javaObjectLabels.toArray(), 0, this.items, 0, this.items.length);
        Arrays.sort(this.items);
        ArrayList a = new ArrayList();
        int i = 0;
        while (i < this.items.length) {
            int j = 0;
            while (j < this.javaObjectLabels.size()) {
                if (this.items[i].equals(this.javaObjectLabels.get(j))) {
                    a.add(this.javaObjects.get(j));
                    break;
                }
                ++j;
            }
            ++i;
        }
        this.javaObjects = a;
        this.combo.setItems(this.items);
    }

    public void setInitializationData(IConfigurationElement element, String data, Object object) {
        boolean cfr_ignored_0 = object instanceof String;
    }
}

