/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.vce;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PDEUtilities {
    private HashMap viewClasses = new HashMap();
    private IProject currentProject;
    private static String VIEW_PART_ICON_PATH;
    private static String EDITOR_PART_ICON_PATH;
    private long pluginTimeStamp;
    private long propertiesTimeStamp;
    static /* synthetic */ Class class$0;

    private PDEUtilities(EditDomain anEditDomain) {
        IFileEditorInput fileEditorInput = (IFileEditorInput)anEditDomain.getEditorPart().getEditorInput();
        IFile fileBeingEdited = fileEditorInput.getFile();
        this.currentProject = fileBeingEdited.getProject();
    }

    private PDEUtilities(IProject aProject) {
        this.currentProject = aProject;
    }

    public static PDEUtilities getUtilities(EditDomain anEditDomain) {
        PDEUtilities aPDEUtilities;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ve.internal.java.vce.PDEUtilities");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((aPDEUtilities = (PDEUtilities)anEditDomain.getData((Object)clazz)) == null) {
            aPDEUtilities = new PDEUtilities(anEditDomain);
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.ve.internal.java.vce.PDEUtilities");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            anEditDomain.setData((Object)clazz2, (Object)aPDEUtilities);
            aPDEUtilities.initialize();
        }
        return aPDEUtilities;
    }

    public static PDEUtilities getUtilities(IProject aProject) {
        PDEUtilities aPDEUtilities = new PDEUtilities(aProject);
        aPDEUtilities.initialize();
        return aPDEUtilities;
    }

    public String getViewName(String viewClassName) {
        this.checkCacheNotStale();
        String[] pluginData = (String[])this.viewClasses.get(viewClassName);
        if (pluginData != null) {
            String viewName = pluginData[0];
            if (viewName.startsWith("%")) {
                IFile propertiesFile = this.currentProject.getFile("plugin.properties");
                if (!propertiesFile.exists()) {
                    return viewName;
                }
                this.propertiesTimeStamp = propertiesFile.getLocalTimeStamp();
                IPath propertiesFileInSystem = this.currentProject.getLocation().append(propertiesFile.getProjectRelativePath());
                try {
                    String bundleValue;
                    FileInputStream inputStream = new FileInputStream(propertiesFileInSystem.toString());
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    String propertyKey = viewName.substring(1);
                    if (propertyKey.endsWith("%")) {
                        propertyKey = propertyKey.substring(0, propertyKey.length() - 1);
                    }
                    if ((bundleValue = properties.getProperty(propertyKey)) == null) {
                        return viewName;
                    }
                    pluginData[0] = bundleValue;
                    return bundleValue;
                }
                catch (IOException iOException) {
                    return viewName;
                }
            }
            return viewName;
        }
        return null;
    }

    private void checkCacheNotStale() {
        IFile pluginXMLFile = this.currentProject.getFile("plugin.xml");
        if (pluginXMLFile.exists() && pluginXMLFile.getLocalTimeStamp() != this.pluginTimeStamp) {
            this.initialize();
            return;
        }
        IFile propertiesXMLFile = this.currentProject.getFile("plugin.properties");
        if (propertiesXMLFile.exists() && this.propertiesTimeStamp != 0L && propertiesXMLFile.getLocalTimeStamp() != this.propertiesTimeStamp) {
            this.initialize();
        }
    }

    public String getIconPath(String viewClassName) {
        String iconLocationRelativeToProject;
        this.checkCacheNotStale();
        String[] pluginData = (String[])this.viewClasses.get(viewClassName);
        if (pluginData != null && (iconLocationRelativeToProject = pluginData[1]) != null) {
            IFile iconFile = this.currentProject.getFile(iconLocationRelativeToProject);
            IPath locationInSystem = this.currentProject.getLocation().append(iconFile.getProjectRelativePath());
            return locationInSystem.toString();
        }
        return null;
    }

    public String getViewPartIconPath() {
        if (VIEW_PART_ICON_PATH == null) {
            IFile gifFile = this.currentProject.getFile("icons/full/clcl16/rcp_app.gif");
            IPath gifLocation = this.currentProject.getLocation().append(gifFile.getProjectRelativePath());
            VIEW_PART_ICON_PATH = gifLocation.toString();
        }
        return VIEW_PART_ICON_PATH;
    }

    public String getEditorPartIconPath() {
        if (EDITOR_PART_ICON_PATH == null) {
            IFile gifFile = this.currentProject.getFile("icons/full/clcl16/rcp_editor.gif");
            IPath gifLocation = this.currentProject.getLocation().append(gifFile.getProjectRelativePath());
            EDITOR_PART_ICON_PATH = gifLocation.toString();
        }
        return EDITOR_PART_ICON_PATH;
    }

    private synchronized void initialize() {
        this.viewClasses = new HashMap();
        IFile pluginXMLFile = this.currentProject.getFile("plugin.xml");
        if (pluginXMLFile.exists()) {
            try {
                this.pluginTimeStamp = pluginXMLFile.getLocalTimeStamp();
                InputStream pluginXMLis = pluginXMLFile.getContents(true);
                DefaultHandler xmlHandler = new DefaultHandler(){
                    static final int VIEW = 1;
                    static final int EDITOR = 2;
                    static final int DEFAULT = 0;
                    private int processing = 0;

                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        String tag = qName.trim().toLowerCase(Locale.US);
                        if (tag.equals("extension")) {
                            String extensionPointName = attributes.getValue("point");
                            if (extensionPointName == null) {
                                return;
                            }
                            this.processing = extensionPointName.equalsIgnoreCase("org.eclipse.ui.views") ? 1 : (extensionPointName.equalsIgnoreCase("org.eclipse.ui.editors") ? 2 : 0);
                        }
                        if (tag.equalsIgnoreCase("view") && this.processing == 1) {
                            PDEUtilities.this.processView(attributes);
                        } else if (tag.equalsIgnoreCase("editor") && this.processing == 2) {
                            PDEUtilities.this.processView(attributes);
                        }
                    }
                };
                SAXParserFactory.newInstance().newSAXParser().parse(pluginXMLis, xmlHandler);
            }
            catch (IOException iOException) {
            }
            catch (SAXException sAXException) {
            }
            catch (ParserConfigurationException parserConfigurationException) {
            }
            catch (FactoryConfigurationError factoryConfigurationError) {
            }
            catch (CoreException coreException) {}
        }
    }

    private void processView(Attributes attributes) {
        String nameName = attributes.getValue("name");
        String iconName = attributes.getValue("icon");
        String className = attributes.getValue("class");
        this.viewClasses.put(className, new String[]{nameName, iconName});
    }
}

