/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.vce.launcher;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.vce.launcher.JavaBeanSearchEngine;
import org.eclipse.ve.internal.java.vce.launcher.VCELauncherMessages;

public class JavaBeanFinder {
    static /* synthetic */ Class class$0;

    private JavaBeanFinder() {
    }

    public static IType[] findTargets(IRunnableContext context, final Object[] elements) throws InvocationTargetException, InterruptedException {
        final HashSet result = new HashSet();
        if (elements.length > 0) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor pm) throws InterruptedException {
                    int nElements = elements.length;
                    pm.beginTask(VCELauncherMessages.JavaBeansFinder_SearchMessage, nElements);
                    try {
                        int i = 0;
                        while (i < nElements) {
                            try {
                                JavaBeanFinder.collectTypes(elements[i], (IProgressMonitor)new SubProgressMonitor(pm, 1), result);
                            }
                            catch (JavaModelException e) {
                                JavaVEPlugin.log(e, Level.WARNING);
                            }
                            if (pm.isCanceled()) {
                                throw new InterruptedException();
                            }
                            ++i;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        pm.done();
                        throw throwable;
                    }
                    {
                        Object var5_7 = null;
                    }
                    pm.done();
                }
            };
            context.run(true, true, runnable);
        }
        return result.toArray(new IType[result.size()]);
    }

    private static void collectTypes(Object element, IProgressMonitor monitor, Set result) throws JavaModelException {
        if (element instanceof IProcess) {
            element = ((IProcess)element).getLaunch();
        } else if (element instanceof IDebugTarget) {
            element = ((IDebugTarget)element).getLaunch();
        }
        if (element instanceof IAdaptable) {
            IJavaElement jelem;
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((jelem = (IJavaElement)iAdaptable.getAdapter((Class)clazz)) != null) {
                IType parentType = (IType)jelem.getAncestor(7);
                if (parentType != null && JavaBeanSearchEngine.typeIsABean(parentType)) {
                    result.add(parentType);
                    monitor.done();
                    return;
                }
                IJavaElement openable = (IJavaElement)jelem.getOpenable();
                if (openable != null) {
                    if (openable.getElementType() == 5) {
                        ICompilationUnit cu = (ICompilationUnit)openable;
                        IType mainType = cu.getType(Signature.getQualifier((String)cu.getElementName()));
                        if (mainType.exists() && JavaBeanSearchEngine.typeIsABean(mainType)) {
                            result.add(mainType);
                        }
                        monitor.done();
                        return;
                    }
                    if (openable.getElementType() == 6) {
                        IType mainType = ((IClassFile)openable).getType();
                        if (JavaBeanSearchEngine.typeIsABean(mainType)) {
                            result.add(mainType);
                        }
                        monitor.done();
                        return;
                    }
                }
                IType[] types = JavaBeanFinder.searchForBeans(jelem, monitor);
                int i = 0;
                while (i < types.length) {
                    result.add(types[i]);
                    ++i;
                }
            }
        }
    }

    private static IType[] searchForBeans(IJavaElement elem, IProgressMonitor monitor) throws JavaModelException {
        JavaBeanSearchEngine searchEngine = new JavaBeanSearchEngine();
        return searchEngine.searchJavaBeans(monitor, elem, 8);
    }
}

