/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.vce.launcher;

import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributionController;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributor;
import org.eclipse.jem.internal.proxy.core.ProxyLaunchSupport;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.remote.LocalFileConfigurationContributorController;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.vce.PDEUtilities;
import org.eclipse.ve.internal.java.vce.VCEPreferences;
import org.eclipse.ve.internal.java.vce.launcher.VCELauncherMessages;

public class JavaBeanLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    static String LAUNCHER_TYPE_NAME = "org.eclipse.ve.internal.java.vce.launcher.remotevm.JavaBeansLauncher";
    static String JFC_LAUNCHER_TYPE_NAME = "org.eclipse.ve.internal.java.vce.launcher.remotevm.JFCLauncher";
    static String SWT_LAUNCHER_TYPE_NAME = "org.eclipse.ve.internal.java.vce.launcher.remotevm.SWTLauncher";
    static String RCP_LAUNCHER_TYPE_NAME = "org.eclipse.ve.internal.java.vce.launcher.remotevm.RCPLauncher";
    static String PACK = " PACK";
    static String LOCALE = "LOCALE";
    static String APPLET_PARMS_NUMBER = "APPLET_PARMS_NUMBER";
    static String APPLET_PARM_NAME = "APPLET_PARM_NAME";
    static String APPLET_PARM_VALUE = "APPLET_PARM_VALUE";
    static String QUOTE_DELIM = "\"";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(VCELauncherMessages.LaunchConfigurationDelegate_Msg_Launching, -1);
        if (monitor.isCanceled()) {
            return;
        }
        String javaBeanName = this.verifyMainTypeName(configuration);
        IVMInstall vm = this.verifyVMInstall(configuration);
        IVMRunner runner = vm.getVMRunner(mode);
        if (runner == null) {
            this.abort(MessageFormat.format(VCELauncherMessages.Launcher_jreerror_msg_ERROR_, vm.getId()), null, 106);
        }
        File workingDir = this.verifyWorkingDirectory(configuration);
        String workingDirName = null;
        if (workingDir != null) {
            workingDirName = workingDir.getAbsolutePath();
        }
        String pgmArgs = this.getProgramArguments(configuration);
        String vmArgs = this.getVMArguments(configuration, javaBeanName);
        ExecutionArguments execArgs = new ExecutionArguments(vmArgs, pgmArgs);
        Map vmAttributesMap = this.getVMSpecificAttributesMap(configuration);
        String[] classpath = this.getClasspath(configuration);
        String[] remoteVMLocations = ProxyPlugin.getPlugin().localizeAllFromBundleAndFragments(JavaVEPlugin.getPlugin().getBundle(), "vm/vcelauncher.jar");
        String[] newClassPath = new String[classpath.length + remoteVMLocations.length];
        System.arraycopy(remoteVMLocations, 0, newClassPath, 0, remoteVMLocations.length);
        System.arraycopy(classpath, 0, newClassPath, remoteVMLocations.length, classpath.length);
        VMRunnerConfiguration runConfig = new VMRunnerConfiguration(LAUNCHER_TYPE_NAME, newClassPath);
        runConfig.setProgramArguments(execArgs.getProgramArgumentsArray());
        runConfig.setVMArguments(execArgs.getVMArgumentsArray());
        runConfig.setWorkingDirectory(workingDirName);
        runConfig.setVMSpecificAttributesMap(vmAttributesMap);
        String[] bootpath = this.getBootpath(configuration);
        runConfig.setBootClassPath(bootpath);
        if (monitor.isCanceled()) {
            return;
        }
        runner.run(runConfig, launch, monitor);
        if (monitor.isCanceled()) {
            return;
        }
        this.setDefaultSourceLocator(launch, configuration);
        monitor.done();
    }

    public String getVMArguments(ILaunchConfiguration configuration, String javaBeanName) throws CoreException {
        String numberOfAppletParmsString;
        boolean pack;
        String locale;
        StringBuffer args = new StringBuffer(super.getVMArguments(configuration));
        String launchersList = JFC_LAUNCHER_TYPE_NAME;
        IJavaProject project = this.verifyJavaProject(configuration);
        if (this.isJFaceProject(project)) {
            String iconPath;
            launchersList = String.valueOf(launchersList) + "," + RCP_LAUNCHER_TYPE_NAME;
            this.setupClasspath(configuration, args);
            int fTabPosition = WorkbenchPlugin.getDefault().getPreferenceStore().getInt("VIEW_TAB_POSITION");
            boolean fTraditionalTabs = PlatformUI.getPreferenceStore().getBoolean("SHOW_TRADITIONAL_STYLE_TABS");
            String activeLinkColor = JFaceResources.getColorRegistry().getRGB("ACTIVE_HYPERLINK_COLOR").toString();
            String errorColor = JFaceResources.getColorRegistry().getRGB("ERROR_COLOR").toString();
            String linkColor = JFaceResources.getColorRegistry().getRGB("HYPERLINK_COLOR").toString();
            String defaultFont = JFaceResources.getDefaultFont().getFontData()[0].toString();
            String dialogFont = JFaceResources.getDialogFont().getFontData()[0].toString();
            String bannerFont = JFaceResources.getBannerFont().getFontData()[0].toString();
            String headerFont = JFaceResources.getHeaderFont().getFontData()[0].toString();
            String textFont = JFaceResources.getTextFont().getFontData()[0].toString();
            args.append(" -Drcp.launcher.tabPosition=" + fTabPosition);
            args.append(" -Drcp.launcher.traditionalTabs=" + fTraditionalTabs);
            args.append(" -Drcp.launcher.activeLink=\"" + activeLinkColor + QUOTE_DELIM);
            args.append(" -Drcp.launcher.error=\"" + errorColor + QUOTE_DELIM);
            args.append(" -Drcp.launcher.link=\"" + linkColor + QUOTE_DELIM);
            args.append(" -Drcp.launcher.defaultFont=\"" + defaultFont + QUOTE_DELIM);
            args.append(" -Drcp.launcher.dialogFont=\"" + dialogFont + QUOTE_DELIM);
            args.append(" -Drcp.launcher.bannerFont=\"" + bannerFont + QUOTE_DELIM);
            args.append(" -Drcp.launcher.headerFont=\"" + headerFont + QUOTE_DELIM);
            args.append(" -Drcp.launcher.textFont=\"" + textFont + QUOTE_DELIM);
            PDEUtilities pdeUtilities = PDEUtilities.getUtilities(project.getProject());
            String viewName = pdeUtilities.getViewName(javaBeanName);
            if (viewName != null) {
                args.append(" -Drcp.launcher.viewName=\"" + viewName + QUOTE_DELIM);
            }
            if ((iconPath = pdeUtilities.getIconPath(javaBeanName)) != null) {
                args.append(" -Drcp.launcher.iconPath=\"" + iconPath + QUOTE_DELIM);
            }
        }
        if (configuration.getAttribute("isSWT", false)) {
            launchersList = String.valueOf(launchersList) + "," + SWT_LAUNCHER_TYPE_NAME;
        }
        args.append(" -Dvce.launchers=\"" + launchersList + "\"");
        args.append(" -Dvce.launcher.class=" + javaBeanName);
        String lookAndFeelClass = configuration.getAttribute("SWING_LOOKANDFEEL", "");
        if (lookAndFeelClass.equals("")) {
            lookAndFeelClass = VCEPreferences.getPlugin().getPluginPreferences().getString("SWING_LOOKANDFEEL");
        }
        if (!lookAndFeelClass.equals("")) {
            args.append(" -Dvce.launcher.lookandfeel=" + lookAndFeelClass);
        }
        if (!(locale = configuration.getAttribute(LOCALE, "")).equals("")) {
            args.append(" -Dlocale=" + locale);
        }
        if (pack = configuration.getAttribute(PACK, false)) {
            args.append(" -Dpack=true");
        }
        if (!(numberOfAppletParmsString = configuration.getAttribute(APPLET_PARMS_NUMBER, "")).equals("")) {
            int numberOfAppletParms = Integer.parseInt(numberOfAppletParmsString);
            args.append(" -Dappletparmsnumber=" + numberOfAppletParmsString);
            int i = 1;
            while (i <= numberOfAppletParms) {
                String name = configuration.getAttribute(String.valueOf(APPLET_PARM_NAME) + i, "");
                args.append(" -Dappletparmname" + i + "=\"" + name + "\"");
                String value = configuration.getAttribute(String.valueOf(APPLET_PARM_VALUE) + i, "");
                args.append(" -Dappletparmvalue" + i + "=\"" + value + "\"");
                ++i;
            }
        }
        return args.toString();
    }

    private boolean isJFaceProject(IJavaProject proj) {
        HashMap containers = new HashMap();
        HashMap plugins = new HashMap();
        try {
            ProxyPlugin.getPlugin().getIDsFound(proj, containers, new HashMap(), plugins, new HashMap());
            return plugins.get("org.eclipse.jface") != null ? (Boolean)plugins.get("org.eclipse.jface") : false;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    protected void setupClasspath(ILaunchConfiguration configuration, StringBuffer args) {
        try {
            URL[] classpath = ProxyLaunchSupport.convertStringPathsToURL((String[])this.getClasspath(configuration));
            URL[][] bootpathInfo = new URL[][]{};
            IConfigurationContributor[] emptyList = new IConfigurationContributor[]{};
            ProxyLaunchSupport.LaunchInfo launchInfo = new ProxyLaunchSupport.LaunchInfo();
            IConfigurationContributor[] contributors = ProxyLaunchSupport.fillInLaunchInfo((IConfigurationContributor[])emptyList, (ProxyLaunchSupport.LaunchInfo)launchInfo, (String)this.verifyJavaProject(configuration).getElementName());
            LocalFileConfigurationContributorController controller = new LocalFileConfigurationContributorController(classpath, bootpathInfo, launchInfo);
            if (contributors != null) {
                int i = 0;
                while (i < contributors.length) {
                    contributors[i].initialize(launchInfo.getConfigInfo());
                    contributors[i].contributeClasspaths((IConfigurationContributionController)controller);
                    ++i;
                }
            }
            Iterator libPaths = controller.getFinalJavaLibraryPath().iterator();
            StringBuffer javaPath = new StringBuffer("");
            while (libPaths.hasNext()) {
                String curLib = ((URL)libPaths.next()).getPath();
                if (curLib.startsWith("/") && Platform.getOS().equals("win32")) {
                    curLib = curLib.substring(1);
                }
                if (javaPath.length() > 0) {
                    javaPath.append(File.pathSeparatorChar);
                }
                javaPath.append(curLib);
            }
            if (!args.toString().matches(".*java.library.path=")) {
                args.append(" -Djava.library.path=\"" + javaPath + "\"");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

