/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.vce.launcher;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.vce.VCEPreferences;
import org.eclipse.ve.internal.java.vce.launcher.JavaBeanFinder;
import org.eclipse.ve.internal.java.vce.launcher.VCELauncherMessages;

public class JavaBeanShortcut
implements ILaunchShortcut {
    static /* synthetic */ Class class$0;

    public void searchAndLaunch(Object[] search, String mode) {
        IType[] types = null;
        if (search != null) {
            try {
                types = JavaBeanFinder.findTargets((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), search);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)VCELauncherMessages.Shortcut_ErrDlg_LaunchFailed_Title, (String)e.getMessage());
                return;
            }
            IType type = null;
            if (types.length == 0) {
                MessageDialog.openError((Shell)this.getShell(), (String)VCELauncherMessages.Shortcut_ErrDlg_LaunchFailed_Title, (String)VCELauncherMessages.Shortcut_ErrDlg_LaunchFailed_Msg_NoBeanFound_ERROR_);
            } else {
                type = types.length > 1 ? this.chooseType(types, mode) : types[0];
            }
            if (type != null) {
                this.launch(type, mode);
            }
        }
    }

    protected IType chooseType(IType[] types, String mode) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider());
        dialog.setElements((Object[])types);
        dialog.setTitle(VCELauncherMessages.Shortcut_TypeDlg_Title);
        if (mode.equals("debug")) {
            dialog.setMessage(VCELauncherMessages.Shortcut_TypeDlg_ChooseDebugType);
        } else {
            dialog.setMessage(VCELauncherMessages.Shortcut_TypeDlg_ChooseRunType);
        }
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    protected void launch(IType type, String mode) {
        block3: {
            try {
                ILaunchConfiguration config = this.findLaunchConfiguration(type, mode);
                if (config != null) {
                    DebugUITools.saveAndBuildBeforeLaunch();
                    config.launch(mode, null);
                }
            }
            catch (CoreException e) {
                Shell shell = this.getShell();
                if (shell == null) break block3;
                ErrorDialog.openError((Shell)shell, (String)VCELauncherMessages.ErrorDialog_Title, (String)VCELauncherMessages.Shortcut_ErrDlg_Msg_LaunchFailed_ERROR_, (IStatus)e.getStatus());
            }
        }
    }

    protected Shell getShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    protected ILaunchConfiguration findLaunchConfiguration(IType type, String mode) {
        ILaunchConfigurationType configType = this.getJavaLaunchConfigType();
        ArrayList<ILaunchConfiguration> candidateConfigs = Collections.EMPTY_LIST;
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                if (config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "").equals(type.getFullyQualifiedName()) && config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(type.getJavaProject().getElementName())) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JavaVEPlugin.log(e.getStatus(), Level.WARNING);
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            return this.createConfiguration(type);
        }
        if (candidateCount == 1) {
            return (ILaunchConfiguration)candidateConfigs.get(0);
        }
        ILaunchConfiguration config = this.chooseConfiguration(candidateConfigs, mode);
        if (config != null) {
            return config;
        }
        return null;
    }

    protected ILaunchConfiguration chooseConfiguration(List configList, String mode) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(VCELauncherMessages.Shortcut_ConfigDlg_Title);
        if (mode.equals("debug")) {
            dialog.setMessage(VCELauncherMessages.Shortcut_ConfigDlg_Msg_DebugConfiguration);
        } else {
            dialog.setMessage(VCELauncherMessages.Shortcut_ConfigDlg_Msg_RunConfiguration);
        }
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected ILaunchConfiguration createConfiguration(IType type) {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = this.getJavaLaunchConfigType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(type.getElementName()));
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, type.getFullyQualifiedName());
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, type.getJavaProject().getElementName());
            if (this.isSWTProject(type.getJavaProject())) {
                wc.setAttribute("isSWT", true);
            }
            config = wc.doSave();
        }
        catch (CoreException ce) {
            JavaVEPlugin.log(ce.getStatus(), Level.WARNING);
        }
        return config;
    }

    private boolean isSWTProject(IJavaProject project) {
        boolean value = false;
        if (project != null) {
            HashMap containers = new HashMap();
            HashMap plugins = new HashMap();
            try {
                ProxyPlugin.getPlugin().getIDsFound(project, containers, new HashMap(), plugins, new HashMap());
                value = containers.containsKey("SWT_CONTAINER") || plugins.containsKey("org.eclipse.swt");
            }
            catch (JavaModelException javaModelException) {}
        }
        return value;
    }

    protected ILaunchConfigurationType getJavaLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType(String.valueOf(VCEPreferences.getPlugin().getBundle().getSymbolicName()) + ".launcher.JavaBean");
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    public void launch(IEditorPart editor, String mode) {
        IJavaElement je;
        IEditorInput input = editor.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((je = (IJavaElement)input.getAdapter((Class)clazz)) != null) {
            this.searchAndLaunch(new Object[]{je}, mode);
        }
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.searchAndLaunch(((IStructuredSelection)selection).toArray(), mode);
        }
    }
}

