/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.vce.launcher;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;
import org.eclipse.ve.internal.java.vce.launcher.JavaBeanSearchEngine;
import org.eclipse.ve.internal.java.vce.launcher.VCELauncherMessages;

public class JavaBeanTypeFinderDialog
extends TwoPaneElementSelector {
    private IRunnableContext fRunnableContext;
    private IJavaElement fElem;
    private int fStyle;

    public JavaBeanTypeFinderDialog(Shell shell, IRunnableContext context, IJavaElement elem, int style) {
        super(shell, (ILabelProvider)new JavaElementLabelProvider(16), (ILabelProvider)new PackageRenderer());
        Assert.isNotNull((Object)context);
        this.fRunnableContext = context;
        this.fElem = elem;
        this.fStyle = style;
    }

    public int open() {
        Object[] types;
        JavaBeanSearchEngine engine = new JavaBeanSearchEngine();
        try {
            types = engine.searchJavaBeans(this.fRunnableContext, this.fElem, this.fStyle);
        }
        catch (InterruptedException interruptedException) {
            return 1;
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle((InvocationTargetException)e, (String)VCELauncherMessages.ErrorDialog_Title, (String)e.getMessage());
            return 1;
        }
        this.setElements(types);
        return super.open();
    }

    private static class PackageRenderer
    extends JavaElementLabelProvider {
        public PackageRenderer() {
            super(2114);
        }

        public Image getImage(Object element) {
            return super.getImage((Object)((IType)element).getPackageFragment());
        }

        public String getText(Object element) {
            return super.getText((Object)((IType)element).getPackageFragment());
        }
    }
}

