/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.visual;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.core.DefaultJavaClassCellEditor;
import org.eclipse.ve.internal.java.core.JavaEditDomainHelper;
import org.eclipse.ve.internal.java.core.JavaMessages;
import org.eclipse.ve.internal.java.visual.PointJavaClassLabelProvider;

public class PointJavaClassCellEditor
extends DefaultJavaClassCellEditor
implements IExecutableExtension {
    private String pointClassName;

    public PointJavaClassCellEditor(Composite aComposite) {
        super(aComposite);
    }

    protected String doGetString(Object value) {
        if (this.isInstance(value)) {
            return PointJavaClassLabelProvider.toString((IJavaInstance)value);
        }
        return null;
    }

    protected String getJavaInitializationString(String dimString) {
        StringTokenizer st = new StringTokenizer(dimString, ",");
        StringBuffer sb = new StringBuffer(dimString.length());
        sb.append("new ");
        sb.append(this.pointClassName);
        sb.append('(');
        sb.append(st.nextToken().trim());
        while (st.hasMoreTokens()) {
            sb.append(',');
            sb.append(st.nextToken().trim());
        }
        sb.append(')');
        return sb.toString();
    }

    protected String isCorrectString(String text) {
        StringTokenizer st = new StringTokenizer(text, ",");
        String[] tokenMsgs = new String[]{JavaMessages.CellEditor_Point_XErrorMsg_ERROR_, JavaMessages.CellEditor_Point_YErrorMsg_ERROR_};
        if (st.countTokens() != tokenMsgs.length) {
            return JavaMessages.CellEditor_Point_ErrorMsg_ERROR_;
        }
        int i = 0;
        while (i < tokenMsgs.length) {
            String field = st.nextToken().trim();
            try {
                Integer.decode(field);
            }
            catch (NumberFormatException numberFormatException) {
                return tokenMsgs[i];
            }
            ++i;
        }
        return null;
    }

    public void setData(Object data) {
        super.setData(data);
        this.setJavaType(JavaRefFactory.eINSTANCE.reflectType(this.pointClassName, JavaEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain)));
    }

    public static String getJavaInitializationString(int x, int y, String aPointClassName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("new ");
        buffer.append(aPointClassName);
        buffer.append('(');
        buffer.append(String.valueOf(x));
        buffer.append(',');
        buffer.append(String.valueOf(y));
        buffer.append(')');
        return buffer.toString();
    }

    public void setInitializationData(IConfigurationElement ce, String pName, Object initData) {
        if (initData instanceof String) {
            this.pointClassName = (String)initData;
        }
    }
}

