/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.vm;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.GenericEventQueue;
import org.eclipse.jem.internal.proxy.common.ICallback;
import org.eclipse.jem.internal.proxy.common.ICallbackHandler;
import org.eclipse.jem.internal.proxy.common.ICallbackRunnable;
import org.eclipse.jem.internal.proxy.common.IVMCallbackServer;
import org.eclipse.ve.internal.jfc.vm.VisualVMMessages;

public class ComponentManager
implements ComponentListener,
HierarchyBoundsListener,
HierarchyListener {
    protected Component fComponent;
    protected ComponentManagerFeedbackController feedbackController;
    protected ComponentManagerExtension[] extensions;
    private static int INTERESTED_HIERARCHYCHANGES = 5;
    protected Point overPoint;
    protected boolean locOverridden;

    public void addExtension(ComponentManagerExtension extension) {
        if (this.extensions == null) {
            this.extensions = new ComponentManagerExtension[]{extension};
            extension.setComponentManager(this);
        } else {
            int i = 0;
            while (i < this.extensions.length) {
                if (this.extensions[i] == extension) {
                    return;
                }
                ++i;
            }
            ComponentManagerExtension[] newExtensions = new ComponentManagerExtension[this.extensions.length + 1];
            System.arraycopy(this.extensions, 0, newExtensions, 0, this.extensions.length);
            newExtensions[newExtensions.length - 1] = extension;
            this.extensions = newExtensions;
            extension.setComponentManager(this);
        }
    }

    public void removeExtension(ComponentManagerExtension extension) {
        if (this.extensions != null) {
            int i = 0;
            while (i < this.extensions.length) {
                if (this.extensions[i] == extension) {
                    if (this.extensions.length > 1) {
                        ComponentManagerExtension[] newExtensions = new ComponentManagerExtension[this.extensions.length - 1];
                        System.arraycopy(this.extensions, 0, newExtensions, 0, i);
                        int left = newExtensions.length - i;
                        if (left > 0) {
                            System.arraycopy(this.extensions, i + 1, newExtensions, i, left);
                        }
                        this.extensions = newExtensions;
                    } else {
                        this.extensions = null;
                    }
                    extension.setComponentManager(null);
                    return;
                }
                ++i;
            }
        }
    }

    public void setComponent(Component aComponent, ComponentManagerFeedbackController feedbackController) {
        this.feedbackController = feedbackController;
        if (this.fComponent != null) {
            feedbackController.deregisterComponentManager(this.fComponent);
            this.fComponent.removeComponentListener(this);
            this.fComponent.removeHierarchyBoundsListener(this);
            this.fComponent.removeHierarchyListener(this);
            this.locOverridden = false;
        }
        Component oldComponent = this.fComponent;
        this.fComponent = aComponent;
        if (this.fComponent != null) {
            feedbackController.registerComponentManager(this.fComponent, this);
            feedbackController.queueInitialRefresh(this);
        }
        if (this.extensions != null) {
            ComponentManagerExtension[] lcl = this.extensions;
            int i = 0;
            while (i < lcl.length) {
                lcl[i].componentSet(oldComponent, this.fComponent);
                ++i;
            }
        }
    }

    protected Component getComponent() {
        return this.fComponent;
    }

    public ComponentManagerFeedbackController getFeedbackController() {
        return this.feedbackController;
    }

    public void invalidate() {
        this.fComponent.invalidate();
        this.feedbackController.invalidateImage(this.fComponent);
    }

    protected void invalidated() {
        if (this.extensions != null) {
            ComponentManagerExtension[] lcl = this.extensions;
            int i = 0;
            while (i < lcl.length) {
                lcl[i].invalidated();
                ++i;
            }
        }
    }

    protected void startComponentListening() {
        this.fComponent.addComponentListener(this);
        this.fComponent.addHierarchyListener(this);
        this.fComponent.addHierarchyBoundsListener(this);
        if (this.extensions != null) {
            ComponentManagerExtension[] lcl = this.extensions;
            int i = 0;
            while (i < lcl.length) {
                lcl[i].startComponentListening();
                ++i;
            }
        }
    }

    public Object[] getLocation() {
        if (this.fComponent != null) {
            int x = 0;
            int y = 0;
            Component comp = this.fComponent;
            while (comp != null && !(comp instanceof Window)) {
                x += comp.getX();
                y += comp.getY();
                comp = comp.getParent();
            }
            return new Object[]{new Integer(x), new Integer(y)};
        }
        return null;
    }

    public Object[] getBounds() {
        if (this.fComponent != null) {
            Object[] location = this.getLocation();
            Dimension size = this.fComponent.getSize();
            return new Object[]{location[0], location[1], new Integer(size.width), new Integer(size.height)};
        }
        return null;
    }

    public void componentResized(ComponentEvent e) {
        Component c = e.getComponent();
        this.feedbackController.addTransaction(this, 2, new Object[]{new Integer(c.getWidth()), new Integer(c.getHeight())}, true);
        if (this.extensions != null) {
            ComponentManagerExtension[] lcl = this.extensions;
            int i = 0;
            while (i < lcl.length) {
                lcl[i].componentResized();
                ++i;
            }
        }
    }

    public void componentMoved(ComponentEvent e) {
        this.fireMoved();
    }

    protected void fireMoved() {
        this.feedbackController.addTransaction(this, 3, this.getLocation(), true);
        if (this.extensions != null) {
            ComponentManagerExtension[] lcl = this.extensions;
            int i = 0;
            while (i < lcl.length) {
                lcl[i].componentMoved();
                ++i;
            }
        }
    }

    public void componentShown(ComponentEvent e) {
        this.feedbackController.addTransaction(this, 1, null, true);
        if (this.extensions != null) {
            ComponentManagerExtension[] lcl = this.extensions;
            int i = 0;
            while (i < lcl.length) {
                lcl[i].componentShown();
                ++i;
            }
        }
    }

    public void componentHidden(ComponentEvent e) {
        this.feedbackController.addTransaction(this, 0, null, true);
        if (this.extensions != null) {
            ComponentManagerExtension[] lcl = this.extensions;
            int i = 0;
            while (i < lcl.length) {
                lcl[i].componentHidden();
                ++i;
            }
        }
    }

    private Object[] getRefreshParms() {
        return this.getBounds();
    }

    public void queueRefresh() {
        this.feedbackController.addTransaction(this, 4, this.getRefreshParms(), true);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ComponentManager.this.feedbackController.addTransaction(ComponentManager.this, 4, ComponentManager.this.getRefreshParms(), true);
            }
        });
        if (this.extensions != null) {
            ComponentManagerExtension[] lcl = this.extensions;
            int i = 0;
            while (i < lcl.length) {
                lcl[i].refreshQueued();
                ++i;
            }
        }
    }

    public void ancestorMoved(HierarchyEvent e) {
        Component cMoved = e.getChanged();
        if (cMoved != this.fComponent) {
            Container cntr = this.fComponent.getParent();
            while (cntr != null && !(cntr instanceof Window)) {
                if (cntr == cMoved) {
                    this.fireMoved();
                    break;
                }
                cntr = cntr.getParent();
            }
        }
    }

    public void ancestorResized(HierarchyEvent e) {
    }

    public void hierarchyChanged(HierarchyEvent e) {
        if (e.getID() == 1400 && (e.getChangeFlags() & (long)INTERESTED_HIERARCHYCHANGES) != 0L && this.fComponent.isShowing()) {
            this.queueRefresh();
        }
    }

    public void applyBounds(Rectangle rect, Rectangle oldRect) {
        if (!this.locOverridden) {
            if (oldRect != null) {
                this.fComponent.getBounds(oldRect);
            }
            this.fComponent.setBounds(rect);
        } else {
            if (oldRect != null) {
                oldRect.setLocation(this.overPoint);
                oldRect.setSize(this.fComponent.getWidth(), this.fComponent.getHeight());
            }
            this.fComponent.setSize(rect.width, rect.height);
            this.overPoint.x = rect.x;
            this.overPoint.y = rect.y;
        }
    }

    public void applyLocation(Point point, Point oldPoint) {
        if (!this.locOverridden) {
            if (oldPoint != null) {
                this.fComponent.getLocation(oldPoint);
            }
            this.fComponent.setLocation(point);
        } else {
            if (oldPoint != null) {
                oldPoint.setLocation(this.overPoint);
            }
            this.overPoint.x = point.x;
            this.overPoint.y = point.y;
        }
    }

    public void overrideLoc(int x, int y) {
        if (!this.locOverridden) {
            this.overPoint = this.fComponent.getLocation(this.overPoint);
            this.locOverridden = true;
        }
        this.fComponent.setLocation(x, y);
    }

    public void removeOverrideLoc() {
        if (this.locOverridden) {
            this.locOverridden = false;
            if (this.overPoint != null) {
                this.fComponent.setLocation(this.overPoint);
            }
        }
    }

    public Point getDefaultLocation() {
        if (this.locOverridden) {
            return this.overPoint;
        }
        return this.fComponent.getLocation();
    }

    public Rectangle getDefaultBounds() {
        if (this.locOverridden) {
            return new Rectangle(this.overPoint.x, this.overPoint.y, this.fComponent.getWidth(), this.fComponent.getHeight());
        }
        return this.fComponent.getBounds();
    }

    public static abstract class ComponentManagerExtension {
        private ComponentManager componentManager;

        void setComponentManager(ComponentManager componentManager) {
            ComponentManager old = this.componentManager;
            this.componentManager = componentManager;
            this.componentManagerSet(old);
        }

        protected void componentManagerSet(ComponentManager oldManager) {
        }

        public final ComponentManager getComponentManager() {
            return this.componentManager;
        }

        public final Component getComponent() {
            return this.componentManager != null ? this.componentManager.getComponent() : null;
        }

        protected void componentMoved() {
        }

        protected void componentHidden() {
        }

        protected void componentResized() {
        }

        protected void componentShown() {
        }

        protected void refreshQueued() {
        }

        protected void invalidated() {
        }

        protected void startComponentListening() {
        }

        protected void componentSet(Component oldComponent, Component newComponent) {
        }
    }

    public static class ComponentManagerFeedbackController
    implements ICallback,
    Runnable {
        protected IVMCallbackServer fServer;
        protected int fCallbackID;
        private boolean changesHeld;
        private GenericEventQueue callbackEventQueue = new GenericEventQueue(VisualVMMessages.getString("ComponentManager.CallbackQueueThreadTitle"));
        private List transactions = new ArrayList();
        private Map uniquesMap = new HashMap();
        private List queuedRefreshRequests;
        private Set queuedInvalidImages;
        private Set queuedInvalidWindows;
        private Map componentToComponentManagers = new HashMap();
        private Runnable validateImages = new Runnable(this){
            final /* synthetic */ ComponentManagerFeedbackController this$1;
            {
                this.this$1 = componentManagerFeedbackController;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (ComponentManagerFeedbackController.access$0(this.this$1) != null && !ComponentManagerFeedbackController.access$0(this.this$1).isEmpty()) {
                    Iterator<E> itr = ComponentManagerFeedbackController.access$0(this.this$1).iterator();
                    while (itr.hasNext()) {
                        Component component = (Component)itr.next();
                        ComponentManager cmanager = (ComponentManager)ComponentManagerFeedbackController.access$1(this.this$1).get(component);
                        if (cmanager == null) continue;
                        cmanager.invalidated();
                    }
                    itr = ComponentManagerFeedbackController.access$2(this.this$1).iterator();
                    while (itr.hasNext()) {
                        Window window = (Window)itr.next();
                        window.validate();
                    }
                    ComponentManagerFeedbackController.access$2(this.this$1).clear();
                    List list = ComponentManagerFeedbackController.access$3(this.this$1);
                    synchronized (list) {
                        if (this.this$1.fServer == null) {
                            return;
                        }
                        Iterator<E> itr2 = ComponentManagerFeedbackController.access$0(this.this$1).iterator();
                        while (itr2.hasNext()) {
                            Component component = (Component)itr2.next();
                            ComponentManager cmanager = (ComponentManager)ComponentManagerFeedbackController.access$1(this.this$1).get(component);
                            if (cmanager == null) continue;
                            ComponentManagerFeedbackController.access$4(this.this$1, cmanager, 6, null, true);
                        }
                    }
                    ComponentManagerFeedbackController.access$0(this.this$1).clear();
                    ComponentManagerFeedbackController.access$5(this.this$1);
                }
            }
        };

        public void initializeCallback(IVMCallbackServer server, int callbackID) {
            this.fServer = server;
            this.fCallbackID = callbackID;
            server.getIVMServer().addShutdownListener(new Runnable(this){
                final /* synthetic */ ComponentManagerFeedbackController this$1;
                {
                    this.this$1 = componentManagerFeedbackController;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    List list = ComponentManagerFeedbackController.access$3(this.this$1);
                    synchronized (list) {
                        if (this.this$1.fServer != null) {
                            this.this$1.fServer = null;
                            ComponentManagerFeedbackController.access$6(this.this$1).close();
                        }
                    }
                }
            });
        }

        public void registerComponentManager(Component component, ComponentManager manager) {
            this.componentToComponentManagers.put(component, manager);
        }

        public void deregisterComponentManager(Component component) {
            this.componentToComponentManagers.remove(component);
        }

        private void postCallback() {
            this.callbackEventQueue.postEvent((Runnable)this);
        }

        public void invalidateImage(Component component) {
            if (this.queuedInvalidImages == null) {
                this.queuedInvalidImages = new HashSet();
                this.queuedInvalidWindows = new HashSet();
            }
            while (component != null) {
                this.queuedInvalidImages.add(component);
                if (component instanceof Window) {
                    this.queuedInvalidWindows.add(component);
                    break;
                }
                component = component.getParent();
            }
        }

        public void postInvalidImages() {
            if (this.queuedInvalidImages != null && !this.queuedInvalidImages.isEmpty()) {
                EventQueue.invokeLater(this.validateImages);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addTransaction(Object notifier, int callbackID, Object[] parms, boolean unique) {
            boolean queueNow;
            this.appendTransaction(notifier, callbackID, parms, unique);
            ComponentManagerFeedbackController componentManagerFeedbackController = this;
            synchronized (componentManagerFeedbackController) {
                queueNow = !this.changesHeld;
            }
            if (queueNow) {
                this.postCallback();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void appendTransaction(Object notifier, int callbackID, Object[] parms, boolean unique) {
            List list = this.transactions;
            synchronized (list) {
                if (this.fServer == null) {
                    return;
                }
                if (unique) {
                    UniqueEntry newUE = new UniqueEntry(notifier, callbackID);
                    UniqueEntry ue = (UniqueEntry)this.uniquesMap.get(newUE);
                    if (ue != null) {
                        int index = ue.getIndex();
                        this.transactions.set(index++, null);
                        this.transactions.set(index++, null);
                        this.transactions.set(index++, null);
                    } else {
                        ue = newUE;
                        this.uniquesMap.put(ue, ue);
                    }
                    ue.setIndex(this.transactions.size());
                }
                this.transactions.add(notifier);
                this.transactions.add(new Integer(callbackID));
                this.transactions.add(parms != null ? new ICallbackHandler.TransmitableArray((Object[])parms) : parms);
            }
        }

        void queueInitialRefresh(ComponentManager manager) {
            if (this.queuedRefreshRequests == null) {
                this.queuedRefreshRequests = new ArrayList();
            }
            this.queuedRefreshRequests.add(manager);
        }

        public void postInitialRefresh() {
            if (this.queuedRefreshRequests != null && !this.queuedRefreshRequests.isEmpty()) {
                List queued = this.queuedRefreshRequests;
                EventQueue.invokeLater(new Runnable(this, queued){
                    final /* synthetic */ ComponentManagerFeedbackController this$1;
                    private final /* synthetic */ List val$queued;
                    {
                        this.this$1 = componentManagerFeedbackController;
                        this.val$queued = list;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        List list = ComponentManagerFeedbackController.access$3(this.this$1);
                        synchronized (list) {
                            if (this.this$1.fServer == null) {
                                return;
                            }
                            int i = 0;
                            while (i < this.val$queued.size()) {
                                ComponentManager manager = (ComponentManager)this.val$queued.get(i);
                                if (manager.fComponent != null) {
                                    ComponentManagerFeedbackController.access$4(this.this$1, manager, 4, ComponentManager.access$0(manager), true);
                                    manager.startComponentListening();
                                }
                                ++i;
                            }
                        }
                        ComponentManagerFeedbackController.access$5(this.this$1);
                    }
                });
            }
            this.queuedRefreshRequests = null;
        }

        public synchronized void startingChanges() {
            this.changesHeld = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postChanges() {
            ComponentManagerFeedbackController componentManagerFeedbackController = this;
            synchronized (componentManagerFeedbackController) {
                this.changesHeld = false;
            }
            this.postCallback();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            IVMCallbackServer server;
            Object[] trans;
            List list = this.transactions;
            synchronized (list) {
                if (this.fServer == null) {
                    return;
                }
                if (this.transactions.isEmpty()) {
                    return;
                }
                if (this.componentToComponentManagers.isEmpty()) {
                    this.transactions.clear();
                    return;
                }
                trans = this.transactions.toArray();
                this.transactions.clear();
                this.uniquesMap.clear();
                server = this.fServer;
            }
            try {
                server.doCallback(new ICallbackRunnable(this, trans){
                    final /* synthetic */ ComponentManagerFeedbackController this$1;
                    private final /* synthetic */ Object[] val$trans;
                    {
                        this.this$1 = componentManagerFeedbackController;
                        this.val$trans = objectArray;
                    }

                    public Object run(ICallbackHandler handler) throws CommandException {
                        return handler.callbackWithParms(this.this$1.fCallbackID, 5, this.val$trans);
                    }
                });
            }
            catch (CommandException exp) {
                exp.printStackTrace();
            }
        }

        static /* synthetic */ Set access$0(ComponentManagerFeedbackController componentManagerFeedbackController) {
            return componentManagerFeedbackController.queuedInvalidImages;
        }

        static /* synthetic */ Map access$1(ComponentManagerFeedbackController componentManagerFeedbackController) {
            return componentManagerFeedbackController.componentToComponentManagers;
        }

        static /* synthetic */ Set access$2(ComponentManagerFeedbackController componentManagerFeedbackController) {
            return componentManagerFeedbackController.queuedInvalidWindows;
        }

        static /* synthetic */ List access$3(ComponentManagerFeedbackController componentManagerFeedbackController) {
            return componentManagerFeedbackController.transactions;
        }

        static /* synthetic */ void access$4(ComponentManagerFeedbackController componentManagerFeedbackController, Object object, int n, Object[] objectArray, boolean bl) {
            componentManagerFeedbackController.appendTransaction(object, n, objectArray, bl);
        }

        static /* synthetic */ void access$5(ComponentManagerFeedbackController componentManagerFeedbackController) {
            componentManagerFeedbackController.postCallback();
        }

        static /* synthetic */ GenericEventQueue access$6(ComponentManagerFeedbackController componentManagerFeedbackController) {
            return componentManagerFeedbackController.callbackEventQueue;
        }

        private static class UniqueEntry {
            protected final Object notifier;
            protected final int ID;
            private int index;

            public UniqueEntry(Object notifier, int ID) {
                this.notifier = notifier;
                this.ID = ID;
            }

            public int hashCode() {
                return 31 * (31 + this.notifier.hashCode()) + this.ID;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                try {
                    UniqueEntry ue = (UniqueEntry)obj;
                    return this.notifier == ue.notifier && this.ID == ue.ID;
                }
                catch (ClassCastException classCastException) {
                    return false;
                }
            }

            public void setIndex(int index) {
                this.index = index;
            }

            public int getIndex() {
                return this.index;
            }
        }
    }
}

