/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.vm;

import java.awt.Component;
import java.awt.Container;

public class ContainerManager {
    public static int componentIndex(Container container, Component beforeComponent, Component addingComponent) {
        if (beforeComponent != null) {
            Component[] components = container.getComponents();
            int i = 0;
            int r = 0;
            while (i < components.length) {
                if (components[i] == beforeComponent) {
                    return r;
                }
                if (components[i] == addingComponent) {
                    --r;
                }
                ++i;
                ++r;
            }
        }
        return -1;
    }

    public static void changeConstraint(Container container, Component component, Object constraint, boolean useDefaultConstraint) {
        Component[] components = container.getComponents();
        int pos = -1;
        int i = 0;
        while (i < components.length) {
            if (components[i] == component) {
                pos = i;
                break;
            }
            ++i;
        }
        if (pos != -1) {
            if (useDefaultConstraint) {
                ContainerManager.addComponent(container, component, useDefaultConstraint, pos);
            } else {
                container.add(component, constraint, pos);
            }
        }
    }

    public static void addComponentBefore(Container container, Component addComponent, Component beforeComponent, boolean useDefaultConstraint) {
        if (addComponent.getParent() == container) {
            container.remove(addComponent);
        }
        int pos = ContainerManager.componentIndex(container, beforeComponent, addComponent);
        ContainerManager.addComponent(container, addComponent, useDefaultConstraint, pos);
    }

    public static void addComponentBefore(Container container, Component addComponent, Object constraint, Component beforeComponent) {
        if (addComponent.getParent() == container) {
            container.remove(addComponent);
        }
        int pos = ContainerManager.componentIndex(container, beforeComponent, addComponent);
        container.add(addComponent, constraint, pos);
    }

    public static void removeComponent(Container container, Component component) {
        container.remove(component);
    }

    protected static void addComponent(Container container, Component addComponent, boolean useDefaultConstraint, int pos) {
        if (!useDefaultConstraint) {
            container.add(addComponent, pos);
        } else {
            container.add(addComponent, addComponent.getName(), pos);
        }
    }
}

