/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.vm;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JDialog;
import org.eclipse.ve.internal.jfc.vm.FreeFormSwingContainer;
import org.eclipse.ve.internal.jfc.vm.VisualVMMessages;

public class FreeFormSwingDialog
extends JDialog {
    private static final long serialVersionUID = -1700965019233269959L;
    protected boolean isValidating;
    protected Dimension minSize;
    protected boolean isDisposing = false;
    protected static FreeFormSwingDialog SWING_DIALOG;

    public static FreeFormSwingDialog getFreeFormDialog(int x, int y) {
        if (SWING_DIALOG == null) {
            SWING_DIALOG = new FreeFormSwingDialog(x, y);
        } else {
            SWING_DIALOG.setLocation(x, y);
        }
        return SWING_DIALOG;
    }

    public FreeFormSwingDialog(int x, int y) {
        this.getContentPane().setLayout(new FlowLayout(0, 0, 0));
        this.setLocation(x, y);
        this.setTitle(VisualVMMessages.getString("FreeForm.Dialog.Title"));
        this.setVisible(true);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                FreeFormSwingDialog.this.removeComponentListener(this);
                FreeFormSwingDialog.this.minSize = FreeFormSwingDialog.this.getSize();
            }
        });
    }

    public FreeFormSwingDialog(Frame parent) {
        super(parent);
    }

    public Component add(Component aComponent) {
        FreeFormSwingContainer aContainer = new FreeFormSwingContainer();
        aContainer.add(aComponent);
        this.getContentPane().add(aContainer);
        this.pack();
        return aComponent;
    }

    protected FreeFormSwingContainer findContainer(Component aComponent) {
        Container contentPane = this.getContentPane();
        int i = contentPane.getComponentCount() - 1;
        while (i >= 0) {
            FreeFormSwingContainer freeFormContainer = (FreeFormSwingContainer)contentPane.getComponent(i);
            if (freeFormContainer.getComponentCount() == 0) {
                super.remove(freeFormContainer);
            } else if (freeFormContainer.getComponent(0) == aComponent) {
                return freeFormContainer;
            }
            --i;
        }
        return null;
    }

    public void setUseComponentSize(Component aComponent, boolean useComponentSize) {
        FreeFormSwingContainer f = this.findContainer(aComponent);
        if (f != null) {
            f.setUseComponentSize(useComponentSize);
            this.invalidate();
        }
    }

    public void remove(Component aComponent) {
        FreeFormSwingContainer f = this.findContainer(aComponent);
        if (f != null) {
            this.getContentPane().remove(f);
        }
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        boolean valid = this.isValid();
        super.validate();
        if (!valid) {
            Object object = this.getTreeLock();
            synchronized (object) {
                if (!this.isValidating) {
                    this.isValidating = true;
                    if (this.minSize != null) {
                        this.pack();
                    }
                }
                this.isValidating = false;
            }
        }
    }

    public Dimension getPreferredSize() {
        Dimension calc = super.getPreferredSize();
        if (this.minSize != null) {
            calc.width = Math.max(this.minSize.width, calc.width);
            calc.height = Math.max(this.minSize.height, calc.height);
        }
        return calc;
    }
}

