/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IPointBeanProxy;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.vce.SubclassCompositionContainerPolicy;
import org.eclipse.ve.internal.java.visual.VisualContainerPolicy;
import org.eclipse.ve.internal.jcm.BeanSubclassComposition;
import org.eclipse.ve.internal.jfc.core.BeanAwtUtilities;
import org.eclipse.ve.internal.jfc.core.BorderLayoutPolicyHelper;
import org.eclipse.ve.internal.jfc.core.LayoutSwitcher;

public class BorderLayoutSwitcher
extends LayoutSwitcher {
    BorderLayoutPolicyHelper helper;
    SubclassCompositionContainerPolicy freeFormContainerPolicy;

    public BorderLayoutSwitcher(VisualContainerPolicy aPolicy) {
        super(aPolicy);
        this.helper = new BorderLayoutPolicyHelper(aPolicy);
    }

    protected Command getChangeConstraintsCommand(List children) {
        ArrayList regions = new ArrayList(5);
        List internalTags = BorderLayoutPolicyHelper.REAL_INTERNAL_TAGS;
        int i = 0;
        while (i < 5) {
            regions.add(internalTags.get(i));
            ++i;
        }
        ArrayList<IJavaObjectInstance> remComps = new ArrayList<IJavaObjectInstance>();
        CompoundCommand cc = new CompoundCommand("Create constraints");
        Iterator comps = children.iterator();
        ArrayList<String> constraints = new ArrayList<String>(5);
        ArrayList<Object> compsWithConstraints = new ArrayList<Object>(5);
        while (comps.hasNext()) {
            IJavaObjectInstance comp = (IJavaObjectInstance)comps.next();
            IBeanProxy proxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)comp);
            IPointBeanProxy pointProxy = BeanAwtUtilities.invoke_getLocation(proxy);
            Point loc = new Point(pointProxy.getX(), pointProxy.getY());
            if (loc == null) continue;
            String str = this.helper.getCurrentConstraint(this.helper.convertLocation(loc));
            if (str != null && regions.contains(str)) {
                constraints.add(str);
                compsWithConstraints.add(comp);
                regions.remove(str);
                continue;
            }
            remComps.add(comp);
        }
        while (!remComps.isEmpty() && !regions.isEmpty()) {
            constraints.add((String)regions.get(0));
            compsWithConstraints.add(remComps.get(0));
            regions.remove(regions.get(0));
            remComps.remove(remComps.get(0));
        }
        cc.add(this.helper.getChangeConstraintCommand(compsWithConstraints, constraints));
        if (!remComps.isEmpty()) {
            cc.add(this.removeComponents(remComps));
        }
        if (cc.size() > 0) {
            return cc.unwrap();
        }
        return null;
    }

    private Command removeComponents(List comps) {
        if (this.freeFormContainerPolicy == null) {
            IJavaObjectInstance component = (IJavaObjectInstance)comps.get(0);
            EObject componentOwner = component.eContainer();
            while (componentOwner != null) {
                if (componentOwner instanceof BeanSubclassComposition) {
                    this.freeFormContainerPolicy = new SubclassCompositionContainerPolicy(this.policy.getEditDomain());
                    this.freeFormContainerPolicy.setContainer((Object)componentOwner);
                    break;
                }
                componentOwner = componentOwner.eContainer();
            }
        }
        CompoundCommand cc = new CompoundCommand("Move the extra components from the BorderLayout container to the free form");
        cc.add(this.policy.getOrphanChildrenCommand(comps));
        cc.add(this.freeFormContainerPolicy.getAddCommand(comps, null));
        return cc;
    }
}

