/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.TreeEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.jem.internal.instantiation.base.IJavaDataTypeInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.EMFEditDomainHelper;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.core.JavaBeanCustomizeLayoutPage;
import org.eclipse.ve.internal.java.rules.RuledCommandBuilder;
import org.eclipse.ve.internal.jfc.core.JFCConstants;
import org.eclipse.ve.internal.jfc.core.JFCMessages;
import org.eclipse.ve.internal.propertysheet.common.commands.AbstractCommand;

public class GridLayoutLayoutPage
extends JavaBeanCustomizeLayoutPage {
    EditPart fEditPart = null;
    int currentRowValue = 1;
    int currentColsValue = 1;
    Spinner columnsSpinner;
    Spinner rowsSpinner;
    Spinner hgapSpinner;
    Spinner vgapSpinner;
    ResourceSet rset;
    protected EReference sfCompositeLayout;
    EStructuralFeature sfColumns;
    EStructuralFeature sfRows;
    EStructuralFeature sfHgap;
    EStructuralFeature sfVgap;
    boolean initialized = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    protected void handleSelectionProviderInitialization(ISelectionProvider selectionProvider) {
    }

    public Control getControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout());
        ModifyListener spinnerModify = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                GridLayoutLayoutPage.this.spinnerModified((Spinner)event.widget);
            }
        };
        Group dimensionsGroup = new Group(c, 0);
        GridData gd = new GridData();
        gd.verticalAlignment = 1;
        dimensionsGroup.setLayoutData((Object)gd);
        GridLayout g2 = new GridLayout();
        g2.numColumns = 2;
        dimensionsGroup.setLayout((Layout)g2);
        dimensionsGroup.setText(JFCMessages.GridLayoutLayoutPage_gridDimensionsTitle);
        Label label = new Label((Composite)dimensionsGroup, 0);
        label.setText(JFCMessages.GridLayoutLayoutPage_columns);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gd);
        this.columnsSpinner = new Spinner((Composite)dimensionsGroup, 2048);
        this.columnsSpinner.setMinimum(0);
        this.columnsSpinner.setSelection(0);
        this.columnsSpinner.addModifyListener(spinnerModify);
        label = new Label((Composite)dimensionsGroup, 0);
        label.setText(JFCMessages.GridLayoutLayoutPage_rows);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gd);
        this.rowsSpinner = new Spinner((Composite)dimensionsGroup, 2048);
        this.rowsSpinner.setMinimum(0);
        this.rowsSpinner.setSelection(0);
        this.rowsSpinner.addModifyListener(spinnerModify);
        Group spaceGroup = new Group(c, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        spaceGroup.setLayoutData((Object)gd);
        GridLayout g3 = new GridLayout();
        g3.numColumns = 2;
        spaceGroup.setLayout((Layout)g3);
        spaceGroup.setText(JFCMessages.GridLayoutLayoutPage_spacingTitle);
        label = new Label((Composite)spaceGroup, 0);
        label.setText(JFCMessages.GridLayoutLayoutPage_horizontalGap);
        this.hgapSpinner = new Spinner((Composite)spaceGroup, 2048);
        this.hgapSpinner.setSelection(5);
        this.hgapSpinner.setMaximum(9999);
        this.hgapSpinner.addModifyListener(spinnerModify);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gd);
        label = new Label((Composite)spaceGroup, 0);
        label.setText(JFCMessages.GridLayoutLayoutPage_verticalGap);
        this.vgapSpinner = new Spinner((Composite)spaceGroup, 2048);
        this.vgapSpinner.setSelection(5);
        this.vgapSpinner.setMaximum(9999);
        this.vgapSpinner.addModifyListener(spinnerModify);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gd);
        if (this.fEditPart != null) {
            this.initialized = false;
            this.initializeValues();
        }
        return c;
    }

    protected boolean handleSelectionChanged(ISelection oldSelection) {
        ISelection newSelection = this.getSelection();
        if (newSelection != null && newSelection instanceof IStructuredSelection && !((IStructuredSelection)newSelection).isEmpty()) {
            EditPart firstParent;
            List editparts = ((IStructuredSelection)newSelection).toList();
            boolean enableAll = true;
            if (editparts.size() == 1 && editparts.get(0) instanceof EditPart && this.isValidTarget(firstParent = (EditPart)editparts.get(0))) {
                this.fEditPart = firstParent;
                this.initialized = false;
                this.initializeValues();
                return true;
            }
            if (editparts.get(0) instanceof EditPart && ((EditPart)editparts.get(0)).getParent() != null && this.isValidTarget(firstParent = ((EditPart)editparts.get(0)).getParent())) {
                EditPart ep = (EditPart)editparts.get(0);
                int i = 1;
                while (i < editparts.size()) {
                    if (editparts.get(i) instanceof EditPart) {
                        ep = (EditPart)editparts.get(i);
                        if (ep.getParent() == null || ep.getParent() != firstParent) {
                            enableAll = false;
                            break;
                        }
                    } else {
                        enableAll = false;
                        break;
                    }
                    ++i;
                }
                if (enableAll) {
                    this.fEditPart = firstParent;
                    this.initialized = false;
                    this.initializeValues();
                    return true;
                }
            }
        }
        this.fEditPart = null;
        return false;
    }

    public boolean isValidTarget(EditPart target) {
        IActionFilter af;
        Class<?> clazz;
        if (target instanceof TreeEditPart) {
            EditPart ep;
            EditPartViewer viewer;
            EditDomain ed = EditDomain.getEditDomain((EditPart)target);
            IEditorPart iEditorPart = ed.getEditorPart();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.gef.EditPartViewer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((viewer = (EditPartViewer)iEditorPart.getAdapter((Class)clazz2)) != null && (ep = (EditPart)viewer.getEditPartRegistry().get(target.getModel())) != null) {
                target = ep;
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.IActionFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (af = (IActionFilter)target.getAdapter((Class)clazz)) != null && af.testAttribute((Object)target, "EDITPOLICY#LAYOUTPOLICY", "java.awt.GridLayout");
    }

    protected boolean selectionIsContainer(ISelection oldSelection) {
        EditPart firstParent;
        List editparts;
        ISelection newSelection = this.getSelection();
        return newSelection != null && newSelection instanceof IStructuredSelection && !((IStructuredSelection)newSelection).isEmpty() && (editparts = ((IStructuredSelection)newSelection).toList()).size() == 1 && editparts.get(0) instanceof EditPart && this.isValidTarget(firstParent = (EditPart)editparts.get(0));
    }

    protected void handleEditorPartChanged(IEditorPart oldEditorPart) {
        this.resetVariables();
    }

    private void initializeValues() {
        if (!this.initialized) {
            this.getResourceSet(this.fEditPart);
            if (this.columnsSpinner == null) {
                return;
            }
            this.columnsSpinner.setSelection(this.getIntValue(this.fEditPart, this.sfColumns));
            this.currentColsValue = this.columnsSpinner.getSelection();
            this.columnsSpinner.setEnabled(true);
            this.rowsSpinner.setSelection(this.getIntValue(this.fEditPart, this.sfRows));
            this.currentRowValue = this.rowsSpinner.getSelection();
            this.rowsSpinner.setEnabled(true);
            this.hgapSpinner.setSelection(this.getIntValue(this.fEditPart, this.sfHgap));
            this.hgapSpinner.setEnabled(true);
            this.vgapSpinner.setSelection(this.getIntValue(this.fEditPart, this.sfVgap));
            this.vgapSpinner.setEnabled(true);
            this.initialized = true;
        }
    }

    private EStructuralFeature getSFForSpinner(Spinner s) {
        if (s == this.columnsSpinner) {
            return this.sfColumns;
        }
        if (s == this.rowsSpinner) {
            return this.sfRows;
        }
        if (s == this.hgapSpinner) {
            return this.sfHgap;
        }
        if (s == this.vgapSpinner) {
            return this.sfVgap;
        }
        return null;
    }

    private void spinnerModified(Spinner s) {
        if (this.initialized) {
            if (s == this.rowsSpinner && this.columnsSpinner.getSelection() == 0) {
                if (this.rowsSpinner.getSelection() == 0) {
                    if (this.currentRowValue == 0) {
                        this.rowsSpinner.setSelection(1);
                    } else {
                        this.rowsSpinner.setSelection(this.currentRowValue);
                    }
                }
                this.currentRowValue = this.rowsSpinner.getSelection();
            } else if (s == this.columnsSpinner && this.rowsSpinner.getSelection() == 0) {
                if (this.columnsSpinner.getSelection() == 0) {
                    if (this.currentColsValue == 0) {
                        this.columnsSpinner.setSelection(1);
                    } else {
                        this.columnsSpinner.setSelection(this.currentColsValue);
                    }
                }
                this.currentColsValue = this.columnsSpinner.getSelection();
            }
            this.execute(this.createSpinnerCommand(this.fEditPart, this.getSFForSpinner(s), s));
        }
    }

    protected Command createSpinnerCommand(EditPart editpart, EStructuralFeature sf, Spinner spinner) {
        CommandBuilder cb = new CommandBuilder();
        EObject control = (EObject)editpart.getModel();
        if (control != null) {
            RuledCommandBuilder componentCB;
            IJavaInstance gridLayout = (IJavaInstance)control.eGet((EStructuralFeature)this.sfCompositeLayout);
            if (gridLayout != null) {
                componentCB = new RuledCommandBuilder(EditDomain.getEditDomain((EditPart)editpart), null, false);
                String init = String.valueOf(spinner.getSelection());
                IJavaInstance intObject = BeanUtilities.createJavaObject((String)"int", (ResourceSet)this.rset, (String)init);
                componentCB.applyAttributeSetting((EObject)gridLayout, sf, (Object)intObject);
                if (this.columnsSpinner.getSelection() == 0) {
                    componentCB.cancelAttributeSetting((EObject)gridLayout, this.sfColumns);
                }
            } else {
                return UnexecutableCommand.INSTANCE;
            }
            componentCB.applyAttributeSetting(control, (EStructuralFeature)this.sfCompositeLayout, (Object)gridLayout);
            cb.append(componentCB.getCommand());
            cb.append((Command)new EnableSpinnerCommand(spinner));
            return cb.getCommand();
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected int getIntValue(EditPart ep, EStructuralFeature sf) {
        Object intPV;
        IPropertySource gridLayout;
        IPropertySource ps;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((ps = (IPropertySource)ep.getAdapter((Class)clazz)) != null && this.getResourceSet(ep) != null && (gridLayout = (IPropertySource)ps.getPropertyValue((Object)this.sfCompositeLayout)) != null && (intPV = gridLayout.getPropertyValue((Object)sf)) != null && intPV instanceof IJavaDataTypeInstance) {
            IIntegerBeanProxy intProxy = (IIntegerBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaDataTypeInstance)intPV), (ResourceSet)this.rset);
            return intProxy.intValue();
        }
        return 0;
    }

    protected void execute(Command command) {
        CommandStack cmdStack;
        if (command == null || !command.canExecute()) {
            return;
        }
        IEditorPart iEditorPart = this.getEditorPart();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.gef.commands.CommandStack");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((cmdStack = (CommandStack)iEditorPart.getAdapter((Class)clazz)) != null) {
            cmdStack.execute(command);
        }
    }

    private void resetVariables() {
        this.rset = null;
        this.sfCompositeLayout = null;
        this.sfColumns = null;
        this.sfRows = null;
        this.sfHgap = null;
        this.sfVgap = null;
        this.initialized = false;
    }

    protected ResourceSet getResourceSet(EditPart editpart) {
        if (this.rset == null) {
            this.rset = EMFEditDomainHelper.getResourceSet((EditDomain)EditDomain.getEditDomain((EditPart)editpart));
            this.sfCompositeLayout = JavaInstantiation.getReference((ResourceSet)this.rset, (URI)JFCConstants.SF_CONTAINER_LAYOUT);
            this.sfColumns = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)JFCConstants.SF_GRIDLAYOUT_COLUMNS);
            this.sfRows = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)JFCConstants.SF_GRIDLAYOUT_ROWS);
            this.sfHgap = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)JFCConstants.SF_GRIDLAYOUT_HGAP);
            this.sfVgap = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)JFCConstants.SF_GRIDLAYOUT_VGAP);
        }
        return this.rset;
    }

    protected class EnableSpinnerCommand
    extends AbstractCommand {
        protected Spinner spinner;

        public EnableSpinnerCommand(Spinner spinner) {
            this.spinner = spinner;
        }

        public void execute() {
            if (this.spinner != null) {
                this.spinner.setEnabled(true);
            }
        }

        public boolean canExecute() {
            return true;
        }
    }
}

