/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.io.File;
import java.io.FileFilter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.jfc.core.IconDialog;
import org.eclipse.ve.internal.jfc.core.IconScreenDisplay;
import org.eclipse.ve.internal.jfc.core.JFCMessages;
import org.eclipse.ve.internal.jfc.core.JFCVisualPlugin;
import org.eclipse.ve.internal.jfc.core.SingleImageDisplay;

public class IconController {
    private static final String PROJECT_SCOPE_START_STRING = "getClass().getResource(";
    private List fileList;
    private IconScreenDisplay drawingBoard;
    private boolean crawlEnabled;
    private boolean allImagesLoaded;
    private Label path;
    private SingleImageDisplay imageCanvas;
    private ImageFileFilter imageFilter = new ImageFileFilter();
    private DirectoryFilter df = new DirectoryFilter();
    private Display dialogDisplay;
    private ArrayList completeFilepaths = new ArrayList();
    private String filterText = "";
    private IconDialog dialog;
    private IPath initialTry;
    private Combo filter;
    private IJavaProject jproj;
    private TreeViewer treeViewer;
    private Group locationGroup;
    private IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    private static final int NO_MODE = -1;
    public static final int SEARCH_PROJECT = 0;
    public static final int SEARCH_FILE_SYSTEM = 1;
    private int currentScope = -1;
    private String initString = "";
    private ImageLoaderThread imageLoaderThread = null;
    static Image noMemoryIcon = null;
    static Image errorIcon = null;
    static Image warnIcon = null;
    private static final Object[] NO_CHILDREN;
    public static final String[] VALID_EXTENSIONS;
    static /* synthetic */ Class class$0;

    static {
        noMemoryIcon = CDEPlugin.getImageFromPlugin((Plugin)JFCVisualPlugin.getPlugin(), (String)"icons/cview16/nomemory.gif");
        errorIcon = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
        warnIcon = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
        NO_CHILDREN = new Object[0];
        VALID_EXTENSIONS = new String[]{".gif", ".jpg", ".png"};
    }

    public IconController(IconDialog dialog, IProject proj, Tree t, List l, IconScreenDisplay g, Label p, SingleImageDisplay c, Display screen, Button crawlButton, Group lg, Combo imgFilter) {
        this.dialog = dialog;
        this.jproj = JavaCore.create((IProject)proj);
        this.fileList = l;
        this.drawingBoard = g;
        this.path = p;
        this.imageCanvas = c;
        this.dialogDisplay = screen;
        this.locationGroup = lg;
        this.filter = imgFilter;
        this.allImagesLoaded = true;
        this.fileList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IconController.this.listSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                IconController.this.closeOKDialog();
            }
        });
        this.drawingBoard.addSelectionListener(new IconScreenDisplay.SelectionListener(){

            public void imageSelected(int index) {
                this.updateScreen(index);
            }

            public void imageDefaultSelected() {
                IconController.this.closeOKDialog();
            }

            private void updateScreen(int index) {
                if (IconController.this.drawingBoard.isValidIndex(index)) {
                    if (IconController.this.fileList.getSelectionIndex() != index) {
                        IconController.this.fileList.setSelection(index);
                        IconController.this.fileList.showSelection();
                    }
                } else {
                    IconController.this.fileList.deselectAll();
                }
                IPath selectedPath = IconController.this.drawingBoard.getSelectedImagePath();
                IconController.this.dialog.getStatusLineManager().setErrorMessage("");
                if (selectedPath != null) {
                    IconController.this.updateSelectedImage(selectedPath);
                } else {
                    IconController.this.clearDisplay();
                }
            }
        });
        crawlButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IconController.this.crawlEnabled = ((Button)event.widget).getSelection();
                IconController.this.rebuildList();
            }
        });
        this.filter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                this.selectionChanged();
            }

            private void selectionChanged() {
                String choice = IconController.this.filter.getText().trim();
                if (!IconController.this.filterText.equals(choice)) {
                    IconController.this.filterText = choice;
                    if (IconController.this.allImagesLoaded) {
                        this.refineList();
                    } else {
                        IconController.this.rebuildList();
                    }
                }
            }

            private void refineList() {
                if (IconController.this.completeFilepaths.size() != 0) {
                    IconController.this.fileList.removeAll();
                    IconController.this.drawingBoard.removeAll();
                    IconController.this.clearDisplay();
                    int size = IconController.this.completeFilepaths.size();
                    int i = 0;
                    while (i < size) {
                        IPath entry = (IPath)IconController.this.completeFilepaths.get(i);
                        if (IconController.this.meetsFilter(entry)) {
                            IconController.this.drawingBoard.add(entry);
                            IconController.this.fileList.add(entry.lastSegment());
                        }
                        ++i;
                    }
                    IconController.this.listSelected();
                }
            }
        });
        this.treeViewer = new TreeViewer(t);
        this.treeViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IconController.this.treeSelected((IStructuredSelection)event.getSelection());
            }
        });
    }

    public int setInitialValue(String value) {
        if (value != null && value.length() > 0) {
            if (value.startsWith(PROJECT_SCOPE_START_STRING)) {
                int lastQuoteIndex;
                IPackageFragment startSelectionFragment = null;
                int firstQuoteIndex = value.indexOf(34, PROJECT_SCOPE_START_STRING.length());
                if (firstQuoteIndex != -1 && (lastQuoteIndex = value.indexOf(34, firstQuoteIndex + 1)) != -1) {
                    String pathString = value.substring(firstQuoteIndex + 1, lastQuoteIndex).trim();
                    try {
                        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                        IPackageFragmentRoot[] roots = this.jproj.getAllPackageFragmentRoots();
                        int i = 0;
                        while (i < roots.length) {
                            IResource res = workspaceRoot.findMember(roots[i].getPath().append(pathString));
                            if (res instanceof IFile) {
                                startSelectionFragment = this.jproj.findPackageFragment(res.getFullPath().removeLastSegments(1));
                                this.initialTry = res.getFullPath();
                                break;
                            }
                            ++i;
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
                this.setSearchScope(0);
                if (startSelectionFragment != null) {
                    this.treeViewer.setSelection((ISelection)new StructuredSelection(startSelectionFragment), true);
                }
            } else if (value.length() > 3 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                Path path = new Path(value.substring(1, value.length() - 1));
                File startSelectionDirectory = path.toFile();
                if (startSelectionDirectory.canRead() && !startSelectionDirectory.isHidden()) {
                    startSelectionDirectory = startSelectionDirectory.getParentFile();
                }
                this.setSearchScope(1);
                if (startSelectionDirectory != null) {
                    this.initialTry = path;
                    this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)startSelectionDirectory), true);
                }
            } else {
                this.setSearchScope(0);
            }
        } else {
            this.setSearchScope(0);
        }
        return this.currentScope;
    }

    protected void rebuildList() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        if (!selection.isEmpty()) {
            this.treeSelected(selection);
        }
    }

    private Button getOKButton() {
        return this.dialog.getButton(0);
    }

    private void closeOKDialog() {
        this.getOKButton().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IconController.this.getOKButton().getShell().traverse(4);
            }
        });
    }

    public void setSearchScope(int newMode) {
        block7: {
            boolean changedScope = this.currentScope != newMode;
            this.currentScope = newMode;
            if (!changedScope) break block7;
            this.clearDisplay();
            this.fileList.removeAll();
            this.drawingBoard.removeAll();
            this.dialog.getStatusLineManager().setErrorMessage("");
            switch (this.currentScope) {
                case 0: {
                    JavaContentProvider contentProvider = new JavaContentProvider();
                    JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(){

                        public String getText(Object element) {
                            String result = super.getText(element);
                            if (element instanceof IPackageFragmentRoot) {
                                result = MessageFormat.format(JFCMessages.IconController_RootLabel, result, ((IPackageFragmentRoot)element).getJavaProject().getElementName());
                            }
                            return result;
                        }
                    };
                    this.treeViewer.setContentProvider((IContentProvider)contentProvider);
                    this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
                    this.treeViewer.setInput((Object)this.jproj);
                    break;
                }
                case 1: {
                    this.treeViewer.setContentProvider((IContentProvider)new FileContentProvider());
                    this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
                        Image folderImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");

                        public String getText(Object element) {
                            if (element instanceof File) {
                                File f = (File)element;
                                if (f.getParent() == null) {
                                    return f.toString();
                                }
                                return f.getName();
                            }
                            return super.getText(element);
                        }

                        public Image getImage(Object element) {
                            return element instanceof File ? this.folderImage : super.getImage(element);
                        }
                    });
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("java.io.File");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    this.treeViewer.setInput((Object)clazz);
                }
            }
        }
    }

    public String getInitString() {
        return this.initString;
    }

    private void setInitString(String newVal) {
        this.initString = newVal;
    }

    private void updateSelectedImage(IPath fpath) {
        this.path.setToolTipText(fpath.toString());
        this.path.setText(fpath.toString());
        this.imageCanvas.setImage(this.drawingBoard.getSelectedImagePath(), this.currentScope == 0 ? this.workspaceRoot : null);
        if (this.imageCanvas.getImageMessage() != null) {
            this.dialog.getStatusLineManager().setErrorMessage(warnIcon, this.imageCanvas.getImageMessage());
        }
        if (this.currentScope == 1) {
            this.getOKButton().setEnabled(true);
            this.setInitString(BeanUtilities.createStringInitString((String)fpath.toString()));
        } else {
            IPath rootPath;
            IPackageFragmentRoot[] roots = null;
            try {
                roots = this.jproj.getAllPackageFragmentRoots();
            }
            catch (JavaModelException javaModelException) {}
            IPath relativePath = null;
            int rootIndex = -1;
            int i = 0;
            while (i < roots.length) {
                rootPath = roots[i].getPath();
                if (rootPath.isPrefixOf(fpath)) {
                    relativePath = fpath.removeFirstSegments(rootPath.segmentCount());
                    rootIndex = i;
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < rootIndex) {
                rootPath = roots[i].getPath();
                IResource res = this.workspaceRoot.findMember(rootPath.append(relativePath));
                if (res instanceof IFile) {
                    this.getOKButton().setEnabled(false);
                    this.dialog.getStatusLineManager().setErrorMessage(MessageFormat.format(JFCMessages.IconController_HiddenImage_ERROR_, res.getFullPath().toString()));
                    return;
                }
                ++i;
            }
            this.getOKButton().setEnabled(true);
            relativePath = relativePath.makeAbsolute();
            this.setInitString(PROJECT_SCOPE_START_STRING + BeanUtilities.createStringInitString((String)relativePath.toString()) + ")");
        }
    }

    private void listSelected() {
        this.drawingBoard.setSelected(this.fileList.getSelectionIndex());
        this.drawingBoard.showSelection();
    }

    private void treeSelected(IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        File f = null;
        Path path = null;
        if (element instanceof IJavaElement && (this.crawlEnabled || !(element instanceof IPackageFragmentRoot))) {
            try {
                IResource res = ((IJavaElement)element).getUnderlyingResource();
                f = res.getLocation().toFile();
                path = res.getFullPath();
            }
            catch (JavaModelException javaModelException) {}
        } else if (element instanceof File) {
            f = (File)element;
            path = new Path(f.getPath());
        }
        this.imageLoaderThread = new ImageLoaderThread(f, (IPath)path);
        this.imageLoaderThread.setPriority(5);
        this.imageLoaderThread.start();
    }

    public void dispose() {
        if (this.imageLoaderThread != null) {
            this.imageLoaderThread.terminateThread();
        }
    }

    private void clearDisplay() {
        this.getOKButton().setEnabled(false);
        this.path.setText("");
        this.path.setToolTipText("");
        this.imageCanvas.setImage(null, null);
    }

    private boolean meetsFilter(IPath path) {
        String name = path.lastSegment();
        StringTokenizer stk = new StringTokenizer(this.filterText, ",");
        boolean result = false;
        if (stk.hasMoreTokens()) {
            while (!result && stk.hasMoreTokens()) {
                result = this.meetsFilterHelper(name, stk.nextToken().trim());
            }
        } else {
            result = this.meetsFilterHelper(name, this.filterText);
        }
        return result;
    }

    private boolean meetsFilterHelper(String name, String afilterText) {
        String start = "";
        String end = "";
        int index = afilterText.indexOf("*");
        if (index >= 0) {
            start = afilterText.substring(0, index);
            end = afilterText.substring(index + 1, afilterText.length());
        } else {
            start = afilterText;
        }
        return name.toUpperCase().startsWith(start.toUpperCase()) && name.toUpperCase().endsWith(end.toUpperCase());
    }

    static /* synthetic */ IPath access$5(IconController iconController) {
        return iconController.initialTry;
    }

    static /* synthetic */ void access$6(IconController iconController, IPath iPath) {
        iconController.initialTry = iPath;
    }

    static /* synthetic */ int access$11(IconController iconController) {
        return iconController.currentScope;
    }

    static /* synthetic */ void access$13(IconController iconController, boolean bl) {
        iconController.allImagesLoaded = bl;
    }

    static /* synthetic */ ImageFileFilter access$14(IconController iconController) {
        return iconController.imageFilter;
    }

    static /* synthetic */ boolean access$15(IconController iconController) {
        return iconController.crawlEnabled;
    }

    private static class JavaContentProvider
    extends StandardJavaElementContentProvider {
        JavaContentProvider() {
        }

        private boolean validRoot(IPackageFragmentRoot root) {
            return !root.isExternal() && !root.isArchive();
        }

        public Object[] getElements(Object inputElement) {
            try {
                if (inputElement instanceof IJavaProject) {
                    IPackageFragmentRoot[] roots = ((IJavaProject)inputElement).getAllPackageFragmentRoots();
                    ArrayList<IPackageFragmentRoot> newRoots = new ArrayList<IPackageFragmentRoot>(roots.length);
                    int i = 0;
                    while (i < roots.length) {
                        if (this.validRoot(roots[i])) {
                            newRoots.add(roots[i]);
                        }
                        ++i;
                    }
                    return newRoots.toArray();
                }
            }
            catch (JavaModelException javaModelException) {}
            return StandardJavaElementContentProvider.NO_CHILDREN;
        }

        public Object[] getChildren(Object parentElement) {
            try {
                if (parentElement instanceof IPackageFragmentRoot) {
                    return ((IPackageFragmentRoot)parentElement).getChildren();
                }
            }
            catch (JavaModelException javaModelException) {}
            return StandardJavaElementContentProvider.NO_CHILDREN;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IPackageFragment) {
                return false;
            }
            return super.hasChildren(element);
        }

        protected Object skipProjectPackageFragmentRoot(IPackageFragmentRoot root) {
            return root;
        }
    }

    private class FileContentProvider
    implements ITreeContentProvider {
        static /* synthetic */ Class class$0;

        FileContentProvider() {
        }

        public Object[] getChildren(Object o) {
            Object[] children = null;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.io.File");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (o == clazz) {
                children = File.listRoots();
            } else if (o instanceof File) {
                children = ((File)o).listFiles(IconController.this.df);
            }
            if (children != null) {
                Arrays.sort(children, new Comparator(this){
                    final /* synthetic */ FileContentProvider this$1;
                    {
                        this.this$1 = fileContentProvider;
                    }

                    public int compare(Object o1, Object o2) {
                        return ((File)o1).getName().compareToIgnoreCase(((File)o2).getName());
                    }
                });
            } else {
                children = NO_CHILDREN;
            }
            return children;
        }

        public boolean hasChildren(Object o) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.io.File");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (o == clazz) {
                return true;
            }
            if (o instanceof File) {
                File[] lf = ((File)o).listFiles(IconController.this.df);
                return lf != null && lf.length > 0;
            }
            return false;
        }

        public Object getParent(Object element) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.io.File");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (element == clazz) {
                return null;
            }
            if (element instanceof File) {
                return ((File)element).getParentFile();
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private static class ImageFileFilter
    implements FileFilter {
        ImageFileFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return file.canRead() && !file.isHidden();
            }
            String name = file.getName().toLowerCase();
            int i = 0;
            while (i < VALID_EXTENSIONS.length) {
                if (name.endsWith(VALID_EXTENSIONS[i])) {
                    return file.canRead() && !file.isHidden();
                }
                ++i;
            }
            return false;
        }
    }

    private static class DirectoryFilter
    implements FileFilter {
        DirectoryFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() && f.canRead() && !f.isHidden();
        }
    }

    private class ImageLoaderThread
    extends Thread {
        private boolean terminateThread;
        private StatusLineManager manager;
        private IProgressMonitor monitor;
        private File f;
        private IPath path;
        private Control inLocation;

        public ImageLoaderThread(File f, IPath path) {
            this.f = f;
            this.path = path;
        }

        public void terminateThread() {
            this.terminateThread = true;
        }

        private void beginTask(IProgressMonitor pm, String task, int ticks) {
            IconController.this.dialogDisplay.syncExec(new Runnable(this, pm, task, ticks){
                final /* synthetic */ ImageLoaderThread this$1;
                private final /* synthetic */ IProgressMonitor val$pm;
                private final /* synthetic */ String val$task;
                private final /* synthetic */ int val$ticks;
                {
                    this.this$1 = imageLoaderThread;
                    this.val$pm = iProgressMonitor;
                    this.val$task = string;
                    this.val$ticks = n;
                }

                public void run() {
                    if (!ImageLoaderThread.access$0(this.this$1)) {
                        this.val$pm.beginTask(this.val$task, this.val$ticks);
                    }
                }
            });
        }

        private void worked(IProgressMonitor pm, int worked) {
            IconController.this.dialogDisplay.asyncExec(new Runnable(this, pm, worked){
                final /* synthetic */ ImageLoaderThread this$1;
                private final /* synthetic */ IProgressMonitor val$pm;
                private final /* synthetic */ int val$worked;
                {
                    this.this$1 = imageLoaderThread;
                    this.val$pm = iProgressMonitor;
                    this.val$worked = n;
                }

                public void run() {
                    if (!ImageLoaderThread.access$0(this.this$1)) {
                        this.val$pm.worked(this.val$worked);
                    }
                }
            });
        }

        private void done(IProgressMonitor pm) {
            IconController.this.dialogDisplay.syncExec(new Runnable(this, pm){
                final /* synthetic */ ImageLoaderThread this$1;
                private final /* synthetic */ IProgressMonitor val$pm;
                {
                    this.this$1 = imageLoaderThread;
                    this.val$pm = iProgressMonitor;
                }

                public void run() {
                    if (!ImageLoaderThread.access$0(this.this$1)) {
                        this.val$pm.done();
                    }
                }
            });
        }

        private void setEnabledForLocGroup(boolean enabled) {
            int i;
            Control[] children = IconController.this.locationGroup.getChildren();
            if (!enabled) {
                this.inLocation = null;
                i = 0;
                while (i < children.length) {
                    if (children[i].isFocusControl()) {
                        this.inLocation = children[i];
                        break;
                    }
                    ++i;
                }
            }
            IconController.this.locationGroup.setEnabled(enabled);
            i = 0;
            while (i < children.length) {
                children[i].setEnabled(enabled);
                ++i;
            }
            if (enabled) {
                if (this.inLocation != null && IconController.this.filter.getParent().isFocusControl()) {
                    this.inLocation.forceFocus();
                }
                this.inLocation = null;
            }
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 193->197)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        private void addImages(File file, IPath dirPath, IProgressMonitor pm, int ticksAvailable) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 272->276)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        static /* synthetic */ boolean access$0(ImageLoaderThread imageLoaderThread) {
            return imageLoaderThread.terminateThread;
        }

        static /* synthetic */ void access$1(ImageLoaderThread imageLoaderThread, boolean bl) {
            imageLoaderThread.setEnabledForLocGroup(bl);
        }

        static /* synthetic */ StatusLineManager access$2(ImageLoaderThread imageLoaderThread) {
            return imageLoaderThread.manager;
        }

        static /* synthetic */ IProgressMonitor access$3(ImageLoaderThread imageLoaderThread) {
            return imageLoaderThread.monitor;
        }

        static /* synthetic */ IconController access$4(ImageLoaderThread imageLoaderThread) {
            return imageLoaderThread.IconController.this;
        }
    }
}

