/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.logging.Level;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.jem.internal.proxy.core.ICallback;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.vce.VCEPreferences;
import org.eclipse.ve.internal.jfc.core.JFCAwtConstants;

public class ImageDataCollector
implements ICallback {
    protected IBeanProxy fDataCollectorProxy;
    protected DataCollectedRunnable fDataCollectedRunnable;
    protected int fAbortedStatus = 5;

    public ImageDataCollector(ProxyFactoryRegistry registry) {
        try {
            this.fDataCollectorProxy = registry.getBeanTypeProxyFactory().getBeanTypeProxy("org.eclipse.ve.internal.jfc.vm.ImageDataCollector").newInstance();
        }
        catch (ThrowableProxy e) {
            JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
            return;
        }
        registry.getCallbackRegistry().registerCallback(this.fDataCollectorProxy, (ICallback)this);
    }

    public void release() {
        if (this.fDataCollectorProxy != null && this.fDataCollectorProxy.isValid()) {
            if (this.isCollectingData()) {
                this.abort();
                this.waitForCompletion();
            }
            this.fDataCollectorProxy.getProxyFactoryRegistry().getCallbackRegistry().deregisterCallback(this.fDataCollectorProxy);
            this.fDataCollectorProxy.getProxyFactoryRegistry().getBeanProxyFactory().releaseProxy(this.fDataCollectorProxy);
        }
        this.fDataCollectorProxy = null;
    }

    public void abort() {
        JFCAwtConstants c = JFCAwtConstants.getConstants(this.fDataCollectorProxy.getProxyFactoryRegistry());
        c.getDataCollectorAbort().invokeCatchThrowableExceptions(this.fDataCollectorProxy);
    }

    public boolean isCollectingData() {
        JFCAwtConstants c = JFCAwtConstants.getConstants(this.fDataCollectorProxy.getProxyFactoryRegistry());
        return ((IBooleanBeanProxy)c.getDataCollectorBusy().invokeCatchThrowableExceptions(this.fDataCollectorProxy)).booleanValue();
    }

    public void waitForCompletion() {
        JFCAwtConstants c = JFCAwtConstants.getConstants(this.fDataCollectorProxy.getProxyFactoryRegistry());
        c.getDataCollectorWait().invokeCatchThrowableExceptions(this.fDataCollectorProxy);
    }

    public IBeanProxy getDataCollectorProxy() {
        return this.fDataCollectorProxy;
    }

    public void startImage(IBeanProxy anImageProxy, DataCollectedRunnable dc) throws ThrowableProxy {
        JFCAwtConstants c = JFCAwtConstants.getConstants(this.fDataCollectorProxy.getProxyFactoryRegistry());
        this.fDataCollectedRunnable = dc;
        IBooleanBeanProxy r = (IBooleanBeanProxy)c.getDataCollectorStartImage().invoke(this.fDataCollectorProxy, new IBeanProxy[]{anImageProxy});
        if (r == null || !r.booleanValue()) {
            dc.imageStarted(-1);
            dc.imageData(null);
        }
    }

    public void startComponent(IBeanProxy aComponentProxy, DataCollectedRunnable dc) throws ThrowableProxy {
        ProxyFactoryRegistry registry = this.fDataCollectorProxy.getProxyFactoryRegistry();
        JFCAwtConstants c = JFCAwtConstants.getConstants(registry);
        this.fDataCollectedRunnable = dc;
        IIntegerBeanProxy maxWidth = registry.getBeanProxyFactory().createBeanProxyWith(VCEPreferences.getPlugin().getPluginPreferences().getInt("MAX_AWT_COMPONENT_IMAGE_WIDTH"));
        IIntegerBeanProxy maxHeight = registry.getBeanProxyFactory().createBeanProxyWith(VCEPreferences.getPlugin().getPluginPreferences().getInt("MAX_AWT_COMPONENT_IMAGE_HEIGHT"));
        IBooleanBeanProxy r = (IBooleanBeanProxy)c.getDataCollectorStartComponent().invoke(this.fDataCollectorProxy, new IBeanProxy[]{aComponentProxy, maxWidth, maxHeight});
        if (r == null || !r.booleanValue()) {
            dc.imageStarted(-1);
            dc.imageData(null);
        }
    }

    public void startProducer(IBeanProxy aProducerProxy, DataCollectedRunnable dc) throws ThrowableProxy {
        JFCAwtConstants c = JFCAwtConstants.getConstants(this.fDataCollectorProxy.getProxyFactoryRegistry());
        this.fDataCollectedRunnable = dc;
        IBooleanBeanProxy r = (IBooleanBeanProxy)c.getDataCollectorStartProducer().invoke(this.fDataCollectorProxy, new IBeanProxy[]{aProducerProxy});
        if (r == null || !r.booleanValue()) {
            dc.imageStarted(-1);
            dc.imageData(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object calledBack(int msgId, IBeanProxy p2) {
        switch (msgId) {
            case 2: {
                final int[] depth = new int[1];
                Display dsp = Display.getCurrent();
                if (dsp == null) {
                    dsp = Display.getDefault();
                }
                dsp.syncExec(new Runnable(){

                    public void run() {
                        depth[0] = Display.getCurrent().getDepth();
                    }
                });
                return new Integer(depth[0]);
            }
            case 3: {
                ImageDataCollector imageDataCollector = this;
                synchronized (imageDataCollector) {
                    this.fAbortedStatus = ((IIntegerBeanProxy)p2).intValue();
                    break;
                }
            }
            case 4: {
                this.fDataCollectedRunnable.imageStarted(((IIntegerBeanProxy)p2).intValue());
                break;
            }
            case 5: {
                this.fDataCollectedRunnable.imageException((ThrowableProxy)p2);
            }
        }
        return null;
    }

    public Object calledBack(int p1, Object[] p2) {
        return null;
    }

    public Object calledBack(int p1, Object p2) {
        return null;
    }

    public void calledBackStream(int msgID, InputStream is) {
        switch (msgID) {
            case 1: {
                this.createImageData(new DataInputStream(is));
                break;
            }
            default: {
                if (!JavaVEPlugin.isLoggingLevel((Level)Level.WARNING)) break;
                JavaVEPlugin.log((Object)("Invalid callback in ImageDataCollector=" + msgID), (Level)Level.WARNING);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createImageData(DataInputStream is) {
        int width = -1;
        int height = -1;
        int depth = -1;
        int transparentPixel = -1;
        PaletteData palette = null;
        ImageData imageData = null;
        byte[] bytes = null;
        int[] ints = null;
        int x = 0;
        int y = 0;
        boolean byteMode = false;
        int abortStatus = 5;
        ImageDataCollector imageDataCollector = this;
        synchronized (imageDataCollector) {
            this.fAbortedStatus = 5;
        }
        try {
            byte cmd;
            block26: while (true) {
                cmd = is.readByte();
                ImageDataCollector imageDataCollector2 = this;
                synchronized (imageDataCollector2) {
                    if (this.fAbortedStatus != 5) {
                        abortStatus = this.fAbortedStatus;
                        this.fAbortedStatus = 5;
                    }
                }
                if (abortStatus != 5) {
                    this.fDataCollectedRunnable.imageNotCollected(abortStatus);
                    return;
                }
                switch (cmd) {
                    case 1: {
                        width = is.readInt();
                        height = is.readInt();
                        continue block26;
                    }
                    case 2: {
                        depth = is.readByte();
                        palette = depth == 16 ? new PaletteData(31744, 992, 31) : new PaletteData(255, 65280, 0xFF0000);
                        if (imageData == null || imageData.palette.isDirect) continue block26;
                        imageData = this.convertToDirect(depth, imageData, palette);
                        bytes = null;
                        ints = new int[imageData.width];
                        continue block26;
                    }
                    case 3: {
                        depth = is.readByte();
                        transparentPixel = is.readInt();
                        int rgbCnt = is.readInt();
                        RGB[] rgbs = new RGB[rgbCnt];
                        int i = 0;
                        while (true) {
                            if (i >= rgbCnt) {
                                palette = new PaletteData(rgbs);
                                continue block26;
                            }
                            rgbs[i] = new RGB(is.readByte() & 0xFF, is.readByte() & 0xFF, is.readByte() & 0xFF);
                            ++i;
                        }
                    }
                    case 4: {
                        if (imageData == null) {
                            imageData = new ImageData(width, height, depth, palette);
                            if (transparentPixel != -1) {
                                imageData.transparentPixel = transparentPixel;
                            }
                        }
                        if (bytes == null) {
                            bytes = new byte[width];
                        }
                        x = is.readInt();
                        y = is.readInt();
                        byteMode = true;
                        continue block26;
                    }
                    case 5: {
                        if (imageData == null) {
                            imageData = new ImageData(width, height, depth, palette);
                        }
                        if (ints == null) {
                            ints = new int[width];
                        }
                        x = is.readInt();
                        y = is.readInt();
                        byteMode = false;
                        continue block26;
                    }
                    case 7: {
                        int count = is.readInt();
                        if (byteMode) {
                            is.readFully(bytes, 0, count);
                            imageData.setPixels(x, y, count, bytes, 0);
                        } else {
                            int i = 0;
                            while (true) {
                                if (i >= count) {
                                    imageData.setPixels(x, y, count, ints, 0);
                                    break;
                                }
                                ints[i] = is.readInt();
                                ++i;
                            }
                        }
                        x += count;
                        continue block26;
                    }
                    case 6: {
                        int count = is.readInt();
                        if (byteMode) {
                            Arrays.fill(bytes, 0, count, is.readByte());
                            imageData.setPixels(x, y, count, bytes, 0);
                        } else {
                            Arrays.fill(ints, 0, count, is.readInt());
                            imageData.setPixels(x, y, count, ints, 0);
                        }
                        x += count;
                        continue block26;
                    }
                    case 8: {
                        int status = is.readInt();
                        switch (status) {
                            case 2: 
                            case 3: {
                                if (imageData == null) {
                                    imageData = new ImageData(width, height, depth, palette);
                                    if (transparentPixel != -1) {
                                        imageData.transparentPixel = transparentPixel;
                                    }
                                }
                                this.fDataCollectedRunnable.imageData(imageData);
                                return;
                            }
                            case -2: {
                                this.fDataCollectedRunnable.imageData(null);
                                return;
                            }
                        }
                        this.fDataCollectedRunnable.imageNotCollected(status);
                        return;
                    }
                }
                break;
            }
            throw new IOException("Invalid cmd=" + cmd);
        }
        catch (EOFException e) {
            ImageDataCollector imageDataCollector3 = this;
            synchronized (imageDataCollector3) {
                if (this.fAbortedStatus != 5) {
                    abortStatus = this.fAbortedStatus;
                    this.fAbortedStatus = 5;
                }
            }
            if (abortStatus != 5) {
                this.fDataCollectedRunnable.imageNotCollected(abortStatus);
                return;
            }
            JavaVEPlugin.log((Throwable)e, (Level)Level.FINE);
            this.fDataCollectedRunnable.imageNotCollected(1);
            return;
        }
        catch (IOException e) {
            JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
            this.fDataCollectedRunnable.imageNotCollected(1);
        }
    }

    protected ImageData convertToDirect(int depth, ImageData oldImageData, PaletteData palette) {
        ImageData newImageData = new ImageData(oldImageData.width, oldImageData.height, depth, palette);
        int[] pixelRow = new int[oldImageData.width];
        RGB[] oldColorModel = oldImageData.palette.getRGBs();
        int row = 0;
        while (row < oldImageData.height) {
            oldImageData.getPixels(0, row, oldImageData.width, pixelRow, 0);
            int col = 0;
            while (col < oldImageData.width) {
                int pixel = pixelRow[col];
                int red = oldColorModel[pixel].red;
                int green = oldColorModel[pixel].green;
                int blue = oldColorModel[pixel].blue;
                if (depth == 16) {
                    red = red >> 3 & 0x1F;
                    green = green >> 3 & 0x1F;
                    blue = blue >> 3 & 0x1F;
                    pixelRow[col] = red << 10 | green << 5 | blue;
                } else {
                    pixelRow[col] = (blue & 0xFF) << 16 | (green & 0xFF) << 8 | red & 0xFF;
                }
                ++col;
            }
            newImageData.setPixels(0, row, newImageData.width, pixelRow, 0);
            ++row;
        }
        return newImageData;
    }

    public static interface DataCollectedRunnable {
        public void imageStarted(int var1);

        public void imageData(ImageData var1);

        public void imageNotCollected(int var1);

        public void imageException(ThrowableProxy var1);
    }
}

